/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagent.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagent.model.BedrockAgentRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartIngestionJobRequest
extends BedrockAgentRequest
implements ToCopyableBuilder<Builder, StartIngestionJobRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(StartIngestionJobRequest.getter(StartIngestionJobRequest::clientToken)).setter(StartIngestionJobRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> DATA_SOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dataSourceId").getter(StartIngestionJobRequest.getter(StartIngestionJobRequest::dataSourceId)).setter(StartIngestionJobRequest.setter(Builder::dataSourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("dataSourceId").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(StartIngestionJobRequest.getter(StartIngestionJobRequest::description)).setter(StartIngestionJobRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> KNOWLEDGE_BASE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("knowledgeBaseId").getter(StartIngestionJobRequest.getter(StartIngestionJobRequest::knowledgeBaseId)).setter(StartIngestionJobRequest.setter(Builder::knowledgeBaseId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("knowledgeBaseId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD, DATA_SOURCE_ID_FIELD, DESCRIPTION_FIELD, KNOWLEDGE_BASE_ID_FIELD));
    private final String clientToken;
    private final String dataSourceId;
    private final String description;
    private final String knowledgeBaseId;

    private StartIngestionJobRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.dataSourceId = builder.dataSourceId;
        this.description = builder.description;
        this.knowledgeBaseId = builder.knowledgeBaseId;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String dataSourceId() {
        return this.dataSourceId;
    }

    public final String description() {
        return this.description;
    }

    public final String knowledgeBaseId() {
        return this.knowledgeBaseId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.knowledgeBaseId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartIngestionJobRequest)) {
            return false;
        }
        StartIngestionJobRequest other = (StartIngestionJobRequest)((Object)obj);
        return Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.dataSourceId(), other.dataSourceId()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.knowledgeBaseId(), other.knowledgeBaseId());
    }

    public final String toString() {
        return ToString.builder((String)"StartIngestionJobRequest").add("ClientToken", (Object)this.clientToken()).add("DataSourceId", (Object)this.dataSourceId()).add("Description", (Object)this.description()).add("KnowledgeBaseId", (Object)this.knowledgeBaseId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "dataSourceId": {
                return Optional.ofNullable(clazz.cast(this.dataSourceId()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "knowledgeBaseId": {
                return Optional.ofNullable(clazz.cast(this.knowledgeBaseId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartIngestionJobRequest, T> g) {
        return obj -> g.apply((StartIngestionJobRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockAgentRequest.BuilderImpl
    implements Builder {
        private String clientToken;
        private String dataSourceId;
        private String description;
        private String knowledgeBaseId;

        private BuilderImpl() {
        }

        private BuilderImpl(StartIngestionJobRequest model) {
            super(model);
            this.clientToken(model.clientToken);
            this.dataSourceId(model.dataSourceId);
            this.description(model.description);
            this.knowledgeBaseId(model.knowledgeBaseId);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getDataSourceId() {
            return this.dataSourceId;
        }

        public final void setDataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
        }

        @Override
        public final Builder dataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getKnowledgeBaseId() {
            return this.knowledgeBaseId;
        }

        public final void setKnowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
        }

        @Override
        public final Builder knowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartIngestionJobRequest build() {
            return new StartIngestionJobRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends BedrockAgentRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartIngestionJobRequest> {
        public Builder clientToken(String var1);

        public Builder dataSourceId(String var1);

        public Builder description(String var1);

        public Builder knowledgeBaseId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

