/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagent.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.bedrockagent.BedrockAgentClient;
import software.amazon.awssdk.services.bedrockagent.internal.UserAgentUtils;
import software.amazon.awssdk.services.bedrockagent.model.AgentAliasSummary;
import software.amazon.awssdk.services.bedrockagent.model.ListAgentAliasesRequest;
import software.amazon.awssdk.services.bedrockagent.model.ListAgentAliasesResponse;

public class ListAgentAliasesIterable
implements SdkIterable<ListAgentAliasesResponse> {
    private final BedrockAgentClient client;
    private final ListAgentAliasesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAgentAliasesIterable(BedrockAgentClient client, ListAgentAliasesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListAgentAliasesResponseFetcher();
    }

    public Iterator<ListAgentAliasesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<AgentAliasSummary> agentAliasSummaries() {
        Function<ListAgentAliasesResponse, Iterator> getIterator = response -> {
            if (response != null && response.agentAliasSummaries() != null) {
                return response.agentAliasSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListAgentAliasesResponseFetcher
    implements SyncPageFetcher<ListAgentAliasesResponse> {
        private ListAgentAliasesResponseFetcher() {
        }

        public boolean hasNextPage(ListAgentAliasesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAgentAliasesResponse nextPage(ListAgentAliasesResponse previousPage) {
            if (previousPage == null) {
                return ListAgentAliasesIterable.this.client.listAgentAliases(ListAgentAliasesIterable.this.firstRequest);
            }
            return ListAgentAliasesIterable.this.client.listAgentAliases((ListAgentAliasesRequest)((Object)ListAgentAliasesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

