/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagentruntime.model.ActionGroupInvocationOutput;
import software.amazon.awssdk.services.bedrockagentruntime.model.FinalResponse;
import software.amazon.awssdk.services.bedrockagentruntime.model.KnowledgeBaseLookupOutput;
import software.amazon.awssdk.services.bedrockagentruntime.model.RepromptResponse;
import software.amazon.awssdk.services.bedrockagentruntime.model.Type;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Observation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Observation> {
    private static final SdkField<ActionGroupInvocationOutput> ACTION_GROUP_INVOCATION_OUTPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("actionGroupInvocationOutput").getter(Observation.getter(Observation::actionGroupInvocationOutput)).setter(Observation.setter(Builder::actionGroupInvocationOutput)).constructor(ActionGroupInvocationOutput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionGroupInvocationOutput").build()}).build();
    private static final SdkField<FinalResponse> FINAL_RESPONSE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("finalResponse").getter(Observation.getter(Observation::finalResponse)).setter(Observation.setter(Builder::finalResponse)).constructor(FinalResponse::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("finalResponse").build()}).build();
    private static final SdkField<KnowledgeBaseLookupOutput> KNOWLEDGE_BASE_LOOKUP_OUTPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("knowledgeBaseLookupOutput").getter(Observation.getter(Observation::knowledgeBaseLookupOutput)).setter(Observation.setter(Builder::knowledgeBaseLookupOutput)).constructor(KnowledgeBaseLookupOutput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("knowledgeBaseLookupOutput").build()}).build();
    private static final SdkField<RepromptResponse> REPROMPT_RESPONSE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("repromptResponse").getter(Observation.getter(Observation::repromptResponse)).setter(Observation.setter(Builder::repromptResponse)).constructor(RepromptResponse::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repromptResponse").build()}).build();
    private static final SdkField<String> TRACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("traceId").getter(Observation.getter(Observation::traceId)).setter(Observation.setter(Builder::traceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("traceId").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(Observation.getter(Observation::typeAsString)).setter(Observation.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_GROUP_INVOCATION_OUTPUT_FIELD, FINAL_RESPONSE_FIELD, KNOWLEDGE_BASE_LOOKUP_OUTPUT_FIELD, REPROMPT_RESPONSE_FIELD, TRACE_ID_FIELD, TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final ActionGroupInvocationOutput actionGroupInvocationOutput;
    private final FinalResponse finalResponse;
    private final KnowledgeBaseLookupOutput knowledgeBaseLookupOutput;
    private final RepromptResponse repromptResponse;
    private final String traceId;
    private final String type;

    private Observation(BuilderImpl builder) {
        this.actionGroupInvocationOutput = builder.actionGroupInvocationOutput;
        this.finalResponse = builder.finalResponse;
        this.knowledgeBaseLookupOutput = builder.knowledgeBaseLookupOutput;
        this.repromptResponse = builder.repromptResponse;
        this.traceId = builder.traceId;
        this.type = builder.type;
    }

    public final ActionGroupInvocationOutput actionGroupInvocationOutput() {
        return this.actionGroupInvocationOutput;
    }

    public final FinalResponse finalResponse() {
        return this.finalResponse;
    }

    public final KnowledgeBaseLookupOutput knowledgeBaseLookupOutput() {
        return this.knowledgeBaseLookupOutput;
    }

    public final RepromptResponse repromptResponse() {
        return this.repromptResponse;
    }

    public final String traceId() {
        return this.traceId;
    }

    public final Type type() {
        return Type.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.actionGroupInvocationOutput());
        hashCode = 31 * hashCode + Objects.hashCode(this.finalResponse());
        hashCode = 31 * hashCode + Objects.hashCode(this.knowledgeBaseLookupOutput());
        hashCode = 31 * hashCode + Objects.hashCode(this.repromptResponse());
        hashCode = 31 * hashCode + Objects.hashCode(this.traceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Observation)) {
            return false;
        }
        Observation other = (Observation)obj;
        return Objects.equals(this.actionGroupInvocationOutput(), other.actionGroupInvocationOutput()) && Objects.equals(this.finalResponse(), other.finalResponse()) && Objects.equals(this.knowledgeBaseLookupOutput(), other.knowledgeBaseLookupOutput()) && Objects.equals(this.repromptResponse(), other.repromptResponse()) && Objects.equals(this.traceId(), other.traceId()) && Objects.equals(this.typeAsString(), other.typeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"Observation").add("ActionGroupInvocationOutput", (Object)this.actionGroupInvocationOutput()).add("FinalResponse", (Object)this.finalResponse()).add("KnowledgeBaseLookupOutput", (Object)this.knowledgeBaseLookupOutput()).add("RepromptResponse", (Object)(this.repromptResponse() == null ? null : "*** Sensitive Data Redacted ***")).add("TraceId", (Object)this.traceId()).add("Type", (Object)this.typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "actionGroupInvocationOutput": {
                return Optional.ofNullable(clazz.cast(this.actionGroupInvocationOutput()));
            }
            case "finalResponse": {
                return Optional.ofNullable(clazz.cast(this.finalResponse()));
            }
            case "knowledgeBaseLookupOutput": {
                return Optional.ofNullable(clazz.cast(this.knowledgeBaseLookupOutput()));
            }
            case "repromptResponse": {
                return Optional.ofNullable(clazz.cast(this.repromptResponse()));
            }
            case "traceId": {
                return Optional.ofNullable(clazz.cast(this.traceId()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Observation, T> g) {
        return obj -> g.apply((Observation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ActionGroupInvocationOutput actionGroupInvocationOutput;
        private FinalResponse finalResponse;
        private KnowledgeBaseLookupOutput knowledgeBaseLookupOutput;
        private RepromptResponse repromptResponse;
        private String traceId;
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(Observation model) {
            this.actionGroupInvocationOutput(model.actionGroupInvocationOutput);
            this.finalResponse(model.finalResponse);
            this.knowledgeBaseLookupOutput(model.knowledgeBaseLookupOutput);
            this.repromptResponse(model.repromptResponse);
            this.traceId(model.traceId);
            this.type(model.type);
        }

        public final ActionGroupInvocationOutput.Builder getActionGroupInvocationOutput() {
            return this.actionGroupInvocationOutput != null ? this.actionGroupInvocationOutput.toBuilder() : null;
        }

        public final void setActionGroupInvocationOutput(ActionGroupInvocationOutput.BuilderImpl actionGroupInvocationOutput) {
            this.actionGroupInvocationOutput = actionGroupInvocationOutput != null ? actionGroupInvocationOutput.build() : null;
        }

        @Override
        public final Builder actionGroupInvocationOutput(ActionGroupInvocationOutput actionGroupInvocationOutput) {
            this.actionGroupInvocationOutput = actionGroupInvocationOutput;
            return this;
        }

        public final FinalResponse.Builder getFinalResponse() {
            return this.finalResponse != null ? this.finalResponse.toBuilder() : null;
        }

        public final void setFinalResponse(FinalResponse.BuilderImpl finalResponse) {
            this.finalResponse = finalResponse != null ? finalResponse.build() : null;
        }

        @Override
        public final Builder finalResponse(FinalResponse finalResponse) {
            this.finalResponse = finalResponse;
            return this;
        }

        public final KnowledgeBaseLookupOutput.Builder getKnowledgeBaseLookupOutput() {
            return this.knowledgeBaseLookupOutput != null ? this.knowledgeBaseLookupOutput.toBuilder() : null;
        }

        public final void setKnowledgeBaseLookupOutput(KnowledgeBaseLookupOutput.BuilderImpl knowledgeBaseLookupOutput) {
            this.knowledgeBaseLookupOutput = knowledgeBaseLookupOutput != null ? knowledgeBaseLookupOutput.build() : null;
        }

        @Override
        public final Builder knowledgeBaseLookupOutput(KnowledgeBaseLookupOutput knowledgeBaseLookupOutput) {
            this.knowledgeBaseLookupOutput = knowledgeBaseLookupOutput;
            return this;
        }

        public final RepromptResponse.Builder getRepromptResponse() {
            return this.repromptResponse != null ? this.repromptResponse.toBuilder() : null;
        }

        public final void setRepromptResponse(RepromptResponse.BuilderImpl repromptResponse) {
            this.repromptResponse = repromptResponse != null ? repromptResponse.build() : null;
        }

        @Override
        public final Builder repromptResponse(RepromptResponse repromptResponse) {
            this.repromptResponse = repromptResponse;
            return this;
        }

        public final String getTraceId() {
            return this.traceId;
        }

        public final void setTraceId(String traceId) {
            this.traceId = traceId;
        }

        @Override
        public final Builder traceId(String traceId) {
            this.traceId = traceId;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(Type type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public Observation build() {
            return new Observation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Observation> {
        public Builder actionGroupInvocationOutput(ActionGroupInvocationOutput var1);

        default public Builder actionGroupInvocationOutput(Consumer<ActionGroupInvocationOutput.Builder> actionGroupInvocationOutput) {
            return this.actionGroupInvocationOutput((ActionGroupInvocationOutput)((ActionGroupInvocationOutput.Builder)ActionGroupInvocationOutput.builder().applyMutation(actionGroupInvocationOutput)).build());
        }

        public Builder finalResponse(FinalResponse var1);

        default public Builder finalResponse(Consumer<FinalResponse.Builder> finalResponse) {
            return this.finalResponse((FinalResponse)((FinalResponse.Builder)FinalResponse.builder().applyMutation(finalResponse)).build());
        }

        public Builder knowledgeBaseLookupOutput(KnowledgeBaseLookupOutput var1);

        default public Builder knowledgeBaseLookupOutput(Consumer<KnowledgeBaseLookupOutput.Builder> knowledgeBaseLookupOutput) {
            return this.knowledgeBaseLookupOutput((KnowledgeBaseLookupOutput)((KnowledgeBaseLookupOutput.Builder)KnowledgeBaseLookupOutput.builder().applyMutation(knowledgeBaseLookupOutput)).build());
        }

        public Builder repromptResponse(RepromptResponse var1);

        default public Builder repromptResponse(Consumer<RepromptResponse.Builder> repromptResponse) {
            return this.repromptResponse((RepromptResponse)((RepromptResponse.Builder)RepromptResponse.builder().applyMutation(repromptResponse)).build());
        }

        public Builder traceId(String var1);

        public Builder type(String var1);

        public Builder type(Type var1);
    }
}

