/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrockagentruntime.model.BedrockAgentRuntimeResponse;
import software.amazon.awssdk.services.bedrockagentruntime.model.Citation;
import software.amazon.awssdk.services.bedrockagentruntime.model.CitationsCopier;
import software.amazon.awssdk.services.bedrockagentruntime.model.RetrieveAndGenerateOutput;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RetrieveAndGenerateResponse
extends BedrockAgentRuntimeResponse
implements ToCopyableBuilder<Builder, RetrieveAndGenerateResponse> {
    private static final SdkField<List<Citation>> CITATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("citations").getter(RetrieveAndGenerateResponse.getter(RetrieveAndGenerateResponse::citations)).setter(RetrieveAndGenerateResponse.setter(Builder::citations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("citations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Citation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<RetrieveAndGenerateOutput> OUTPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("output").getter(RetrieveAndGenerateResponse.getter(RetrieveAndGenerateResponse::output)).setter(RetrieveAndGenerateResponse.setter(Builder::output)).constructor(RetrieveAndGenerateOutput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("output").build()}).build();
    private static final SdkField<String> SESSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sessionId").getter(RetrieveAndGenerateResponse.getter(RetrieveAndGenerateResponse::sessionId)).setter(RetrieveAndGenerateResponse.setter(Builder::sessionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CITATIONS_FIELD, OUTPUT_FIELD, SESSION_ID_FIELD));
    private final List<Citation> citations;
    private final RetrieveAndGenerateOutput output;
    private final String sessionId;

    private RetrieveAndGenerateResponse(BuilderImpl builder) {
        super(builder);
        this.citations = builder.citations;
        this.output = builder.output;
        this.sessionId = builder.sessionId;
    }

    public final boolean hasCitations() {
        return this.citations != null && !(this.citations instanceof SdkAutoConstructList);
    }

    public final List<Citation> citations() {
        return this.citations;
    }

    public final RetrieveAndGenerateOutput output() {
        return this.output;
    }

    public final String sessionId() {
        return this.sessionId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCitations() ? this.citations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.output());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RetrieveAndGenerateResponse)) {
            return false;
        }
        RetrieveAndGenerateResponse other = (RetrieveAndGenerateResponse)((Object)obj);
        return this.hasCitations() == other.hasCitations() && Objects.equals(this.citations(), other.citations()) && Objects.equals(this.output(), other.output()) && Objects.equals(this.sessionId(), other.sessionId());
    }

    public final String toString() {
        return ToString.builder((String)"RetrieveAndGenerateResponse").add("Citations", this.hasCitations() ? this.citations() : null).add("Output", (Object)(this.output() == null ? null : "*** Sensitive Data Redacted ***")).add("SessionId", (Object)this.sessionId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "citations": {
                return Optional.ofNullable(clazz.cast(this.citations()));
            }
            case "output": {
                return Optional.ofNullable(clazz.cast(this.output()));
            }
            case "sessionId": {
                return Optional.ofNullable(clazz.cast(this.sessionId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RetrieveAndGenerateResponse, T> g) {
        return obj -> g.apply((RetrieveAndGenerateResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockAgentRuntimeResponse.BuilderImpl
    implements Builder {
        private List<Citation> citations = DefaultSdkAutoConstructList.getInstance();
        private RetrieveAndGenerateOutput output;
        private String sessionId;

        private BuilderImpl() {
        }

        private BuilderImpl(RetrieveAndGenerateResponse model) {
            super(model);
            this.citations(model.citations);
            this.output(model.output);
            this.sessionId(model.sessionId);
        }

        public final List<Citation.Builder> getCitations() {
            List<Citation.Builder> result = CitationsCopier.copyToBuilder(this.citations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCitations(Collection<Citation.BuilderImpl> citations) {
            this.citations = CitationsCopier.copyFromBuilder(citations);
        }

        @Override
        public final Builder citations(Collection<Citation> citations) {
            this.citations = CitationsCopier.copy(citations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder citations(Citation ... citations) {
            this.citations(Arrays.asList(citations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder citations(Consumer<Citation.Builder> ... citations) {
            this.citations(Stream.of(citations).map(c -> (Citation)((Citation.Builder)Citation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final RetrieveAndGenerateOutput.Builder getOutput() {
            return this.output != null ? this.output.toBuilder() : null;
        }

        public final void setOutput(RetrieveAndGenerateOutput.BuilderImpl output) {
            this.output = output != null ? output.build() : null;
        }

        @Override
        public final Builder output(RetrieveAndGenerateOutput output) {
            this.output = output;
            return this;
        }

        public final String getSessionId() {
            return this.sessionId;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        @Override
        public RetrieveAndGenerateResponse build() {
            return new RetrieveAndGenerateResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends BedrockAgentRuntimeResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RetrieveAndGenerateResponse> {
        public Builder citations(Collection<Citation> var1);

        public Builder citations(Citation ... var1);

        public Builder citations(Consumer<Citation.Builder> ... var1);

        public Builder output(RetrieveAndGenerateOutput var1);

        default public Builder output(Consumer<RetrieveAndGenerateOutput.Builder> output) {
            return this.output((RetrieveAndGenerateOutput)((RetrieveAndGenerateOutput.Builder)RetrieveAndGenerateOutput.builder().applyMutation(output)).build());
        }

        public Builder sessionId(String var1);
    }
}

