/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockruntime;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.bedrockruntime.BedrockRuntimeAsyncClient;
import software.amazon.awssdk.services.bedrockruntime.BedrockRuntimeAsyncClientBuilder;
import software.amazon.awssdk.services.bedrockruntime.BedrockRuntimeServiceClientConfiguration;
import software.amazon.awssdk.services.bedrockruntime.DefaultBedrockRuntimeAsyncClient;
import software.amazon.awssdk.services.bedrockruntime.DefaultBedrockRuntimeBaseClientBuilder;
import software.amazon.awssdk.services.bedrockruntime.endpoints.BedrockRuntimeEndpointProvider;

@SdkInternalApi
final class DefaultBedrockRuntimeAsyncClientBuilder
extends DefaultBedrockRuntimeBaseClientBuilder<BedrockRuntimeAsyncClientBuilder, BedrockRuntimeAsyncClient>
implements BedrockRuntimeAsyncClientBuilder {
    DefaultBedrockRuntimeAsyncClientBuilder() {
    }

    @Override
    public DefaultBedrockRuntimeAsyncClientBuilder endpointProvider(BedrockRuntimeEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final BedrockRuntimeAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultBedrockRuntimeAsyncClientBuilder.validateClientOptions(clientConfiguration);
        BedrockRuntimeServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultBedrockRuntimeAsyncClient client = new DefaultBedrockRuntimeAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private BedrockRuntimeServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return BedrockRuntimeServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

