/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockruntime.model.AudioFormat;
import software.amazon.awssdk.services.bedrockruntime.model.AudioSource;
import software.amazon.awssdk.services.bedrockruntime.model.ErrorBlock;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AudioBlock
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AudioBlock> {
    private static final SdkField<String> FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("format").getter(AudioBlock.getter(AudioBlock::formatAsString)).setter(AudioBlock.setter(Builder::format)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("format").build()}).build();
    private static final SdkField<AudioSource> SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("source").getter(AudioBlock.getter(AudioBlock::source)).setter(AudioBlock.setter(Builder::source)).constructor(AudioSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("source").build()}).build();
    private static final SdkField<ErrorBlock> ERROR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("error").getter(AudioBlock.getter(AudioBlock::error)).setter(AudioBlock.setter(Builder::error)).constructor(ErrorBlock::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("error").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FORMAT_FIELD, SOURCE_FIELD, ERROR_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AudioBlock.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String format;
    private final AudioSource source;
    private final ErrorBlock error;

    private AudioBlock(BuilderImpl builder) {
        this.format = builder.format;
        this.source = builder.source;
        this.error = builder.error;
    }

    public final AudioFormat format() {
        return AudioFormat.fromValue(this.format);
    }

    public final String formatAsString() {
        return this.format;
    }

    public final AudioSource source() {
        return this.source;
    }

    public final ErrorBlock error() {
        return this.error;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.formatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.source());
        hashCode = 31 * hashCode + Objects.hashCode(this.error());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AudioBlock)) {
            return false;
        }
        AudioBlock other = (AudioBlock)obj;
        return Objects.equals(this.formatAsString(), other.formatAsString()) && Objects.equals(this.source(), other.source()) && Objects.equals(this.error(), other.error());
    }

    public final String toString() {
        return ToString.builder((String)"AudioBlock").add("Format", (Object)this.formatAsString()).add("Source", (Object)(this.source() == null ? null : "*** Sensitive Data Redacted ***")).add("Error", (Object)(this.error() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "format": {
                return Optional.ofNullable(clazz.cast(this.formatAsString()));
            }
            case "source": {
                return Optional.ofNullable(clazz.cast(this.source()));
            }
            case "error": {
                return Optional.ofNullable(clazz.cast(this.error()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("format", FORMAT_FIELD);
        map.put("source", SOURCE_FIELD);
        map.put("error", ERROR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AudioBlock, T> g) {
        return obj -> g.apply((AudioBlock)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String format;
        private AudioSource source;
        private ErrorBlock error;

        private BuilderImpl() {
        }

        private BuilderImpl(AudioBlock model) {
            this.format(model.format);
            this.source(model.source);
            this.error(model.error);
        }

        public final String getFormat() {
            return this.format;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        public final Builder format(AudioFormat format) {
            this.format(format == null ? null : format.toString());
            return this;
        }

        public final AudioSource.Builder getSource() {
            return this.source != null ? this.source.toBuilder() : null;
        }

        public final void setSource(AudioSource.BuilderImpl source) {
            this.source = source != null ? source.build() : null;
        }

        @Override
        public final Builder source(AudioSource source) {
            this.source = source;
            return this;
        }

        public final ErrorBlock.Builder getError() {
            return this.error != null ? this.error.toBuilder() : null;
        }

        public final void setError(ErrorBlock.BuilderImpl error) {
            this.error = error != null ? error.build() : null;
        }

        @Override
        public final Builder error(ErrorBlock error) {
            this.error = error;
            return this;
        }

        public AudioBlock build() {
            return new AudioBlock(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AudioBlock> {
        public Builder format(String var1);

        public Builder format(AudioFormat var1);

        public Builder source(AudioSource var1);

        default public Builder source(Consumer<AudioSource.Builder> source) {
            return this.source((AudioSource)((AudioSource.Builder)AudioSource.builder().applyMutation(source)).build());
        }

        public Builder error(ErrorBlock var1);

        default public Builder error(Consumer<ErrorBlock.Builder> error) {
            return this.error((ErrorBlock)((ErrorBlock.Builder)ErrorBlock.builder().applyMutation(error)).build());
        }
    }
}

