/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockruntime.model.ConverseStreamMetrics;
import software.amazon.awssdk.services.bedrockruntime.model.ConverseStreamOutput;
import software.amazon.awssdk.services.bedrockruntime.model.ConverseStreamResponseHandler;
import software.amazon.awssdk.services.bedrockruntime.model.ConverseStreamTrace;
import software.amazon.awssdk.services.bedrockruntime.model.PerformanceConfiguration;
import software.amazon.awssdk.services.bedrockruntime.model.ServiceTier;
import software.amazon.awssdk.services.bedrockruntime.model.TokenUsage;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ConverseStreamMetadataEvent
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ConverseStreamMetadataEvent>,
ConverseStreamOutput {
    private static final SdkField<TokenUsage> USAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("usage").getter(ConverseStreamMetadataEvent.getter(ConverseStreamMetadataEvent::usage)).setter(ConverseStreamMetadataEvent.setter(Builder::usage)).constructor(TokenUsage::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("usage").build()}).build();
    private static final SdkField<ConverseStreamMetrics> METRICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("metrics").getter(ConverseStreamMetadataEvent.getter(ConverseStreamMetadataEvent::metrics)).setter(ConverseStreamMetadataEvent.setter(Builder::metrics)).constructor(ConverseStreamMetrics::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metrics").build()}).build();
    private static final SdkField<ConverseStreamTrace> TRACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("trace").getter(ConverseStreamMetadataEvent.getter(ConverseStreamMetadataEvent::trace)).setter(ConverseStreamMetadataEvent.setter(Builder::trace)).constructor(ConverseStreamTrace::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trace").build()}).build();
    private static final SdkField<PerformanceConfiguration> PERFORMANCE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("performanceConfig").getter(ConverseStreamMetadataEvent.getter(ConverseStreamMetadataEvent::performanceConfig)).setter(ConverseStreamMetadataEvent.setter(Builder::performanceConfig)).constructor(PerformanceConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("performanceConfig").build()}).build();
    private static final SdkField<ServiceTier> SERVICE_TIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("serviceTier").getter(ConverseStreamMetadataEvent.getter(ConverseStreamMetadataEvent::serviceTier)).setter(ConverseStreamMetadataEvent.setter(Builder::serviceTier)).constructor(ServiceTier::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceTier").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USAGE_FIELD, METRICS_FIELD, TRACE_FIELD, PERFORMANCE_CONFIG_FIELD, SERVICE_TIER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ConverseStreamMetadataEvent.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final TokenUsage usage;
    private final ConverseStreamMetrics metrics;
    private final ConverseStreamTrace trace;
    private final PerformanceConfiguration performanceConfig;
    private final ServiceTier serviceTier;

    protected ConverseStreamMetadataEvent(BuilderImpl builder) {
        this.usage = builder.usage;
        this.metrics = builder.metrics;
        this.trace = builder.trace;
        this.performanceConfig = builder.performanceConfig;
        this.serviceTier = builder.serviceTier;
    }

    public final TokenUsage usage() {
        return this.usage;
    }

    public final ConverseStreamMetrics metrics() {
        return this.metrics;
    }

    public final ConverseStreamTrace trace() {
        return this.trace;
    }

    public final PerformanceConfiguration performanceConfig() {
        return this.performanceConfig;
    }

    public final ServiceTier serviceTier() {
        return this.serviceTier;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.usage());
        hashCode = 31 * hashCode + Objects.hashCode(this.metrics());
        hashCode = 31 * hashCode + Objects.hashCode(this.trace());
        hashCode = 31 * hashCode + Objects.hashCode(this.performanceConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceTier());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConverseStreamMetadataEvent)) {
            return false;
        }
        ConverseStreamMetadataEvent other = (ConverseStreamMetadataEvent)obj;
        return Objects.equals(this.usage(), other.usage()) && Objects.equals(this.metrics(), other.metrics()) && Objects.equals(this.trace(), other.trace()) && Objects.equals(this.performanceConfig(), other.performanceConfig()) && Objects.equals(this.serviceTier(), other.serviceTier());
    }

    public final String toString() {
        return ToString.builder((String)"ConverseStreamMetadataEvent").add("Usage", (Object)this.usage()).add("Metrics", (Object)this.metrics()).add("Trace", (Object)this.trace()).add("PerformanceConfig", (Object)this.performanceConfig()).add("ServiceTier", (Object)this.serviceTier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "usage": {
                return Optional.ofNullable(clazz.cast(this.usage()));
            }
            case "metrics": {
                return Optional.ofNullable(clazz.cast(this.metrics()));
            }
            case "trace": {
                return Optional.ofNullable(clazz.cast(this.trace()));
            }
            case "performanceConfig": {
                return Optional.ofNullable(clazz.cast(this.performanceConfig()));
            }
            case "serviceTier": {
                return Optional.ofNullable(clazz.cast(this.serviceTier()));
            }
        }
        return Optional.empty();
    }

    public final ConverseStreamMetadataEvent copy(Consumer<? super Builder> modifier) {
        return (ConverseStreamMetadataEvent)super.copy(modifier);
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("usage", USAGE_FIELD);
        map.put("metrics", METRICS_FIELD);
        map.put("trace", TRACE_FIELD);
        map.put("performanceConfig", PERFORMANCE_CONFIG_FIELD);
        map.put("serviceTier", SERVICE_TIER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConverseStreamMetadataEvent, T> g) {
        return obj -> g.apply((ConverseStreamMetadataEvent)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    @Override
    public void accept(ConverseStreamResponseHandler.Visitor visitor) {
        throw new UnsupportedOperationException();
    }

    protected static class BuilderImpl
    implements Builder {
        private TokenUsage usage;
        private ConverseStreamMetrics metrics;
        private ConverseStreamTrace trace;
        private PerformanceConfiguration performanceConfig;
        private ServiceTier serviceTier;

        protected BuilderImpl() {
        }

        protected BuilderImpl(ConverseStreamMetadataEvent model) {
            this.usage(model.usage);
            this.metrics(model.metrics);
            this.trace(model.trace);
            this.performanceConfig(model.performanceConfig);
            this.serviceTier(model.serviceTier);
        }

        public final TokenUsage.Builder getUsage() {
            return this.usage != null ? this.usage.toBuilder() : null;
        }

        public final void setUsage(TokenUsage.BuilderImpl usage) {
            this.usage = usage != null ? usage.build() : null;
        }

        @Override
        public final Builder usage(TokenUsage usage) {
            this.usage = usage;
            return this;
        }

        public final ConverseStreamMetrics.Builder getMetrics() {
            return this.metrics != null ? this.metrics.toBuilder() : null;
        }

        public final void setMetrics(ConverseStreamMetrics.BuilderImpl metrics) {
            this.metrics = metrics != null ? metrics.build() : null;
        }

        @Override
        public final Builder metrics(ConverseStreamMetrics metrics) {
            this.metrics = metrics;
            return this;
        }

        public final ConverseStreamTrace.Builder getTrace() {
            return this.trace != null ? this.trace.toBuilder() : null;
        }

        public final void setTrace(ConverseStreamTrace.BuilderImpl trace) {
            this.trace = trace != null ? trace.build() : null;
        }

        @Override
        public final Builder trace(ConverseStreamTrace trace) {
            this.trace = trace;
            return this;
        }

        public final PerformanceConfiguration.Builder getPerformanceConfig() {
            return this.performanceConfig != null ? this.performanceConfig.toBuilder() : null;
        }

        public final void setPerformanceConfig(PerformanceConfiguration.BuilderImpl performanceConfig) {
            this.performanceConfig = performanceConfig != null ? performanceConfig.build() : null;
        }

        @Override
        public final Builder performanceConfig(PerformanceConfiguration performanceConfig) {
            this.performanceConfig = performanceConfig;
            return this;
        }

        public final ServiceTier.Builder getServiceTier() {
            return this.serviceTier != null ? this.serviceTier.toBuilder() : null;
        }

        public final void setServiceTier(ServiceTier.BuilderImpl serviceTier) {
            this.serviceTier = serviceTier != null ? serviceTier.build() : null;
        }

        @Override
        public final Builder serviceTier(ServiceTier serviceTier) {
            this.serviceTier = serviceTier;
            return this;
        }

        public ConverseStreamMetadataEvent build() {
            return new ConverseStreamMetadataEvent(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ConverseStreamMetadataEvent> {
        public Builder usage(TokenUsage var1);

        default public Builder usage(Consumer<TokenUsage.Builder> usage) {
            return this.usage((TokenUsage)((TokenUsage.Builder)TokenUsage.builder().applyMutation(usage)).build());
        }

        public Builder metrics(ConverseStreamMetrics var1);

        default public Builder metrics(Consumer<ConverseStreamMetrics.Builder> metrics) {
            return this.metrics((ConverseStreamMetrics)((ConverseStreamMetrics.Builder)ConverseStreamMetrics.builder().applyMutation(metrics)).build());
        }

        public Builder trace(ConverseStreamTrace var1);

        default public Builder trace(Consumer<ConverseStreamTrace.Builder> trace) {
            return this.trace((ConverseStreamTrace)((ConverseStreamTrace.Builder)ConverseStreamTrace.builder().applyMutation(trace)).build());
        }

        public Builder performanceConfig(PerformanceConfiguration var1);

        default public Builder performanceConfig(Consumer<PerformanceConfiguration.Builder> performanceConfig) {
            return this.performanceConfig((PerformanceConfiguration)((PerformanceConfiguration.Builder)PerformanceConfiguration.builder().applyMutation(performanceConfig)).build());
        }

        public Builder serviceTier(ServiceTier var1);

        default public Builder serviceTier(Consumer<ServiceTier.Builder> serviceTier) {
            return this.serviceTier((ServiceTier)((ServiceTier.Builder)ServiceTier.builder().applyMutation(serviceTier)).build());
        }
    }
}

