/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.billingconductor.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The billing period range in which the custom line item request will be applied.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CustomLineItemBillingPeriodRange implements SdkPojo, Serializable,
        ToCopyableBuilder<CustomLineItemBillingPeriodRange.Builder, CustomLineItemBillingPeriodRange> {
    private static final SdkField<String> INCLUSIVE_START_BILLING_PERIOD_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("InclusiveStartBillingPeriod")
            .getter(getter(CustomLineItemBillingPeriodRange::inclusiveStartBillingPeriod))
            .setter(setter(Builder::inclusiveStartBillingPeriod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InclusiveStartBillingPeriod")
                    .build()).build();

    private static final SdkField<String> EXCLUSIVE_END_BILLING_PERIOD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExclusiveEndBillingPeriod").getter(getter(CustomLineItemBillingPeriodRange::exclusiveEndBillingPeriod))
            .setter(setter(Builder::exclusiveEndBillingPeriod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExclusiveEndBillingPeriod").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            INCLUSIVE_START_BILLING_PERIOD_FIELD, EXCLUSIVE_END_BILLING_PERIOD_FIELD));

    private static final long serialVersionUID = 1L;

    private final String inclusiveStartBillingPeriod;

    private final String exclusiveEndBillingPeriod;

    private CustomLineItemBillingPeriodRange(BuilderImpl builder) {
        this.inclusiveStartBillingPeriod = builder.inclusiveStartBillingPeriod;
        this.exclusiveEndBillingPeriod = builder.exclusiveEndBillingPeriod;
    }

    /**
     * <p>
     * The inclusive start billing period that defines a billing period range where a custom line is applied.
     * </p>
     * 
     * @return The inclusive start billing period that defines a billing period range where a custom line is applied.
     */
    public final String inclusiveStartBillingPeriod() {
        return inclusiveStartBillingPeriod;
    }

    /**
     * <p>
     * The inclusive end billing period that defines a billing period range where a custom line is applied.
     * </p>
     * 
     * @return The inclusive end billing period that defines a billing period range where a custom line is applied.
     */
    public final String exclusiveEndBillingPeriod() {
        return exclusiveEndBillingPeriod;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(inclusiveStartBillingPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(exclusiveEndBillingPeriod());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomLineItemBillingPeriodRange)) {
            return false;
        }
        CustomLineItemBillingPeriodRange other = (CustomLineItemBillingPeriodRange) obj;
        return Objects.equals(inclusiveStartBillingPeriod(), other.inclusiveStartBillingPeriod())
                && Objects.equals(exclusiveEndBillingPeriod(), other.exclusiveEndBillingPeriod());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CustomLineItemBillingPeriodRange")
                .add("InclusiveStartBillingPeriod", inclusiveStartBillingPeriod())
                .add("ExclusiveEndBillingPeriod", exclusiveEndBillingPeriod()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InclusiveStartBillingPeriod":
            return Optional.ofNullable(clazz.cast(inclusiveStartBillingPeriod()));
        case "ExclusiveEndBillingPeriod":
            return Optional.ofNullable(clazz.cast(exclusiveEndBillingPeriod()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CustomLineItemBillingPeriodRange, T> g) {
        return obj -> g.apply((CustomLineItemBillingPeriodRange) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CustomLineItemBillingPeriodRange> {
        /**
         * <p>
         * The inclusive start billing period that defines a billing period range where a custom line is applied.
         * </p>
         * 
         * @param inclusiveStartBillingPeriod
         *        The inclusive start billing period that defines a billing period range where a custom line is applied.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inclusiveStartBillingPeriod(String inclusiveStartBillingPeriod);

        /**
         * <p>
         * The inclusive end billing period that defines a billing period range where a custom line is applied.
         * </p>
         * 
         * @param exclusiveEndBillingPeriod
         *        The inclusive end billing period that defines a billing period range where a custom line is applied.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exclusiveEndBillingPeriod(String exclusiveEndBillingPeriod);
    }

    static final class BuilderImpl implements Builder {
        private String inclusiveStartBillingPeriod;

        private String exclusiveEndBillingPeriod;

        private BuilderImpl() {
        }

        private BuilderImpl(CustomLineItemBillingPeriodRange model) {
            inclusiveStartBillingPeriod(model.inclusiveStartBillingPeriod);
            exclusiveEndBillingPeriod(model.exclusiveEndBillingPeriod);
        }

        public final String getInclusiveStartBillingPeriod() {
            return inclusiveStartBillingPeriod;
        }

        public final void setInclusiveStartBillingPeriod(String inclusiveStartBillingPeriod) {
            this.inclusiveStartBillingPeriod = inclusiveStartBillingPeriod;
        }

        @Override
        public final Builder inclusiveStartBillingPeriod(String inclusiveStartBillingPeriod) {
            this.inclusiveStartBillingPeriod = inclusiveStartBillingPeriod;
            return this;
        }

        public final String getExclusiveEndBillingPeriod() {
            return exclusiveEndBillingPeriod;
        }

        public final void setExclusiveEndBillingPeriod(String exclusiveEndBillingPeriod) {
            this.exclusiveEndBillingPeriod = exclusiveEndBillingPeriod;
        }

        @Override
        public final Builder exclusiveEndBillingPeriod(String exclusiveEndBillingPeriod) {
            this.exclusiveEndBillingPeriod = exclusiveEndBillingPeriod;
            return this;
        }

        @Override
        public CustomLineItemBillingPeriodRange build() {
            return new CustomLineItemBillingPeriodRange(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
