/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.billingconductor.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum BillingGroupStatus {
    ACTIVE("ACTIVE"),
    PRIMARY_ACCOUNT_MISSING("PRIMARY_ACCOUNT_MISSING"),
    PENDING("PENDING"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, BillingGroupStatus> VALUE_MAP;
    private final String value;

    private BillingGroupStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static BillingGroupStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<BillingGroupStatus> knownValues() {
        EnumSet<BillingGroupStatus> knownValues = EnumSet.allOf(BillingGroupStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(BillingGroupStatus.class, BillingGroupStatus::toString);
    }
}

