/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.billingconductor.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.billingconductor.model.BillingGroupArnListCopier;
import software.amazon.awssdk.services.billingconductor.model.BillingGroupStatus;
import software.amazon.awssdk.services.billingconductor.model.BillingGroupStatusListCopier;
import software.amazon.awssdk.services.billingconductor.model.BillingGroupType;
import software.amazon.awssdk.services.billingconductor.model.BillingGroupTypeListCopier;
import software.amazon.awssdk.services.billingconductor.model.PrimaryAccountIdListCopier;
import software.amazon.awssdk.services.billingconductor.model.ResponsibilityTransferArnsListCopier;
import software.amazon.awssdk.services.billingconductor.model.StringSearch;
import software.amazon.awssdk.services.billingconductor.model.StringSearchesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListBillingGroupsFilter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ListBillingGroupsFilter> {
    private static final SdkField<List<String>> ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Arns").getter(ListBillingGroupsFilter.getter(ListBillingGroupsFilter::arns)).setter(ListBillingGroupsFilter.setter(Builder::arns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> PRICING_PLAN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PricingPlan").getter(ListBillingGroupsFilter.getter(ListBillingGroupsFilter::pricingPlan)).setter(ListBillingGroupsFilter.setter(Builder::pricingPlan)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PricingPlan").build()}).build();
    private static final SdkField<List<String>> STATUSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Statuses").getter(ListBillingGroupsFilter.getter(ListBillingGroupsFilter::statusesAsStrings)).setter(ListBillingGroupsFilter.setter(Builder::statusesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Statuses").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> AUTO_ASSOCIATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AutoAssociate").getter(ListBillingGroupsFilter.getter(ListBillingGroupsFilter::autoAssociate)).setter(ListBillingGroupsFilter.setter(Builder::autoAssociate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoAssociate").build()}).build();
    private static final SdkField<List<String>> PRIMARY_ACCOUNT_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PrimaryAccountIds").getter(ListBillingGroupsFilter.getter(ListBillingGroupsFilter::primaryAccountIds)).setter(ListBillingGroupsFilter.setter(Builder::primaryAccountIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrimaryAccountIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> BILLING_GROUP_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("BillingGroupTypes").getter(ListBillingGroupsFilter.getter(ListBillingGroupsFilter::billingGroupTypesAsStrings)).setter(ListBillingGroupsFilter.setter(Builder::billingGroupTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BillingGroupTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<StringSearch>> NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Names").getter(ListBillingGroupsFilter.getter(ListBillingGroupsFilter::names)).setter(ListBillingGroupsFilter.setter(Builder::names)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Names").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(StringSearch::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> RESPONSIBILITY_TRANSFER_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ResponsibilityTransferArns").getter(ListBillingGroupsFilter.getter(ListBillingGroupsFilter::responsibilityTransferArns)).setter(ListBillingGroupsFilter.setter(Builder::responsibilityTransferArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResponsibilityTransferArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARNS_FIELD, PRICING_PLAN_FIELD, STATUSES_FIELD, AUTO_ASSOCIATE_FIELD, PRIMARY_ACCOUNT_IDS_FIELD, BILLING_GROUP_TYPES_FIELD, NAMES_FIELD, RESPONSIBILITY_TRANSFER_ARNS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListBillingGroupsFilter.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> arns;
    private final String pricingPlan;
    private final List<String> statuses;
    private final Boolean autoAssociate;
    private final List<String> primaryAccountIds;
    private final List<String> billingGroupTypes;
    private final List<StringSearch> names;
    private final List<String> responsibilityTransferArns;

    private ListBillingGroupsFilter(BuilderImpl builder) {
        this.arns = builder.arns;
        this.pricingPlan = builder.pricingPlan;
        this.statuses = builder.statuses;
        this.autoAssociate = builder.autoAssociate;
        this.primaryAccountIds = builder.primaryAccountIds;
        this.billingGroupTypes = builder.billingGroupTypes;
        this.names = builder.names;
        this.responsibilityTransferArns = builder.responsibilityTransferArns;
    }

    public final boolean hasArns() {
        return this.arns != null && !(this.arns instanceof SdkAutoConstructList);
    }

    public final List<String> arns() {
        return this.arns;
    }

    public final String pricingPlan() {
        return this.pricingPlan;
    }

    public final List<BillingGroupStatus> statuses() {
        return BillingGroupStatusListCopier.copyStringToEnum(this.statuses);
    }

    public final boolean hasStatuses() {
        return this.statuses != null && !(this.statuses instanceof SdkAutoConstructList);
    }

    public final List<String> statusesAsStrings() {
        return this.statuses;
    }

    public final Boolean autoAssociate() {
        return this.autoAssociate;
    }

    public final boolean hasPrimaryAccountIds() {
        return this.primaryAccountIds != null && !(this.primaryAccountIds instanceof SdkAutoConstructList);
    }

    public final List<String> primaryAccountIds() {
        return this.primaryAccountIds;
    }

    public final List<BillingGroupType> billingGroupTypes() {
        return BillingGroupTypeListCopier.copyStringToEnum(this.billingGroupTypes);
    }

    public final boolean hasBillingGroupTypes() {
        return this.billingGroupTypes != null && !(this.billingGroupTypes instanceof SdkAutoConstructList);
    }

    public final List<String> billingGroupTypesAsStrings() {
        return this.billingGroupTypes;
    }

    public final boolean hasNames() {
        return this.names != null && !(this.names instanceof SdkAutoConstructList);
    }

    public final List<StringSearch> names() {
        return this.names;
    }

    public final boolean hasResponsibilityTransferArns() {
        return this.responsibilityTransferArns != null && !(this.responsibilityTransferArns instanceof SdkAutoConstructList);
    }

    public final List<String> responsibilityTransferArns() {
        return this.responsibilityTransferArns;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasArns() ? this.arns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.pricingPlan());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStatuses() ? this.statusesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.autoAssociate());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPrimaryAccountIds() ? this.primaryAccountIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBillingGroupTypes() ? this.billingGroupTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNames() ? this.names() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResponsibilityTransferArns() ? this.responsibilityTransferArns() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListBillingGroupsFilter)) {
            return false;
        }
        ListBillingGroupsFilter other = (ListBillingGroupsFilter)obj;
        return this.hasArns() == other.hasArns() && Objects.equals(this.arns(), other.arns()) && Objects.equals(this.pricingPlan(), other.pricingPlan()) && this.hasStatuses() == other.hasStatuses() && Objects.equals(this.statusesAsStrings(), other.statusesAsStrings()) && Objects.equals(this.autoAssociate(), other.autoAssociate()) && this.hasPrimaryAccountIds() == other.hasPrimaryAccountIds() && Objects.equals(this.primaryAccountIds(), other.primaryAccountIds()) && this.hasBillingGroupTypes() == other.hasBillingGroupTypes() && Objects.equals(this.billingGroupTypesAsStrings(), other.billingGroupTypesAsStrings()) && this.hasNames() == other.hasNames() && Objects.equals(this.names(), other.names()) && this.hasResponsibilityTransferArns() == other.hasResponsibilityTransferArns() && Objects.equals(this.responsibilityTransferArns(), other.responsibilityTransferArns());
    }

    public final String toString() {
        return ToString.builder((String)"ListBillingGroupsFilter").add("Arns", this.hasArns() ? this.arns() : null).add("PricingPlan", (Object)this.pricingPlan()).add("Statuses", this.hasStatuses() ? this.statusesAsStrings() : null).add("AutoAssociate", (Object)this.autoAssociate()).add("PrimaryAccountIds", this.hasPrimaryAccountIds() ? this.primaryAccountIds() : null).add("BillingGroupTypes", this.hasBillingGroupTypes() ? this.billingGroupTypesAsStrings() : null).add("Names", this.hasNames() ? this.names() : null).add("ResponsibilityTransferArns", this.hasResponsibilityTransferArns() ? this.responsibilityTransferArns() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arns": {
                return Optional.ofNullable(clazz.cast(this.arns()));
            }
            case "PricingPlan": {
                return Optional.ofNullable(clazz.cast(this.pricingPlan()));
            }
            case "Statuses": {
                return Optional.ofNullable(clazz.cast(this.statusesAsStrings()));
            }
            case "AutoAssociate": {
                return Optional.ofNullable(clazz.cast(this.autoAssociate()));
            }
            case "PrimaryAccountIds": {
                return Optional.ofNullable(clazz.cast(this.primaryAccountIds()));
            }
            case "BillingGroupTypes": {
                return Optional.ofNullable(clazz.cast(this.billingGroupTypesAsStrings()));
            }
            case "Names": {
                return Optional.ofNullable(clazz.cast(this.names()));
            }
            case "ResponsibilityTransferArns": {
                return Optional.ofNullable(clazz.cast(this.responsibilityTransferArns()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Arns", ARNS_FIELD);
        map.put("PricingPlan", PRICING_PLAN_FIELD);
        map.put("Statuses", STATUSES_FIELD);
        map.put("AutoAssociate", AUTO_ASSOCIATE_FIELD);
        map.put("PrimaryAccountIds", PRIMARY_ACCOUNT_IDS_FIELD);
        map.put("BillingGroupTypes", BILLING_GROUP_TYPES_FIELD);
        map.put("Names", NAMES_FIELD);
        map.put("ResponsibilityTransferArns", RESPONSIBILITY_TRANSFER_ARNS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListBillingGroupsFilter, T> g) {
        return obj -> g.apply((ListBillingGroupsFilter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> arns = DefaultSdkAutoConstructList.getInstance();
        private String pricingPlan;
        private List<String> statuses = DefaultSdkAutoConstructList.getInstance();
        private Boolean autoAssociate;
        private List<String> primaryAccountIds = DefaultSdkAutoConstructList.getInstance();
        private List<String> billingGroupTypes = DefaultSdkAutoConstructList.getInstance();
        private List<StringSearch> names = DefaultSdkAutoConstructList.getInstance();
        private List<String> responsibilityTransferArns = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListBillingGroupsFilter model) {
            this.arns(model.arns);
            this.pricingPlan(model.pricingPlan);
            this.statusesWithStrings(model.statuses);
            this.autoAssociate(model.autoAssociate);
            this.primaryAccountIds(model.primaryAccountIds);
            this.billingGroupTypesWithStrings(model.billingGroupTypes);
            this.names(model.names);
            this.responsibilityTransferArns(model.responsibilityTransferArns);
        }

        public final Collection<String> getArns() {
            if (this.arns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.arns;
        }

        public final void setArns(Collection<String> arns) {
            this.arns = BillingGroupArnListCopier.copy(arns);
        }

        @Override
        public final Builder arns(Collection<String> arns) {
            this.arns = BillingGroupArnListCopier.copy(arns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder arns(String ... arns) {
            this.arns(Arrays.asList(arns));
            return this;
        }

        public final String getPricingPlan() {
            return this.pricingPlan;
        }

        public final void setPricingPlan(String pricingPlan) {
            this.pricingPlan = pricingPlan;
        }

        @Override
        public final Builder pricingPlan(String pricingPlan) {
            this.pricingPlan = pricingPlan;
            return this;
        }

        public final Collection<String> getStatuses() {
            if (this.statuses instanceof SdkAutoConstructList) {
                return null;
            }
            return this.statuses;
        }

        public final void setStatuses(Collection<String> statuses) {
            this.statuses = BillingGroupStatusListCopier.copy(statuses);
        }

        @Override
        public final Builder statusesWithStrings(Collection<String> statuses) {
            this.statuses = BillingGroupStatusListCopier.copy(statuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statusesWithStrings(String ... statuses) {
            this.statusesWithStrings(Arrays.asList(statuses));
            return this;
        }

        @Override
        public final Builder statuses(Collection<BillingGroupStatus> statuses) {
            this.statuses = BillingGroupStatusListCopier.copyEnumToString(statuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statuses(BillingGroupStatus ... statuses) {
            this.statuses(Arrays.asList(statuses));
            return this;
        }

        public final Boolean getAutoAssociate() {
            return this.autoAssociate;
        }

        public final void setAutoAssociate(Boolean autoAssociate) {
            this.autoAssociate = autoAssociate;
        }

        @Override
        public final Builder autoAssociate(Boolean autoAssociate) {
            this.autoAssociate = autoAssociate;
            return this;
        }

        public final Collection<String> getPrimaryAccountIds() {
            if (this.primaryAccountIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.primaryAccountIds;
        }

        public final void setPrimaryAccountIds(Collection<String> primaryAccountIds) {
            this.primaryAccountIds = PrimaryAccountIdListCopier.copy(primaryAccountIds);
        }

        @Override
        public final Builder primaryAccountIds(Collection<String> primaryAccountIds) {
            this.primaryAccountIds = PrimaryAccountIdListCopier.copy(primaryAccountIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder primaryAccountIds(String ... primaryAccountIds) {
            this.primaryAccountIds(Arrays.asList(primaryAccountIds));
            return this;
        }

        public final Collection<String> getBillingGroupTypes() {
            if (this.billingGroupTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.billingGroupTypes;
        }

        public final void setBillingGroupTypes(Collection<String> billingGroupTypes) {
            this.billingGroupTypes = BillingGroupTypeListCopier.copy(billingGroupTypes);
        }

        @Override
        public final Builder billingGroupTypesWithStrings(Collection<String> billingGroupTypes) {
            this.billingGroupTypes = BillingGroupTypeListCopier.copy(billingGroupTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder billingGroupTypesWithStrings(String ... billingGroupTypes) {
            this.billingGroupTypesWithStrings(Arrays.asList(billingGroupTypes));
            return this;
        }

        @Override
        public final Builder billingGroupTypes(Collection<BillingGroupType> billingGroupTypes) {
            this.billingGroupTypes = BillingGroupTypeListCopier.copyEnumToString(billingGroupTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder billingGroupTypes(BillingGroupType ... billingGroupTypes) {
            this.billingGroupTypes(Arrays.asList(billingGroupTypes));
            return this;
        }

        public final List<StringSearch.Builder> getNames() {
            List<StringSearch.Builder> result = StringSearchesCopier.copyToBuilder(this.names);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNames(Collection<StringSearch.BuilderImpl> names) {
            this.names = StringSearchesCopier.copyFromBuilder(names);
        }

        @Override
        public final Builder names(Collection<StringSearch> names) {
            this.names = StringSearchesCopier.copy(names);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder names(StringSearch ... names) {
            this.names(Arrays.asList(names));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder names(Consumer<StringSearch.Builder> ... names) {
            this.names(Stream.of(names).map(c -> (StringSearch)((StringSearch.Builder)StringSearch.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getResponsibilityTransferArns() {
            if (this.responsibilityTransferArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.responsibilityTransferArns;
        }

        public final void setResponsibilityTransferArns(Collection<String> responsibilityTransferArns) {
            this.responsibilityTransferArns = ResponsibilityTransferArnsListCopier.copy(responsibilityTransferArns);
        }

        @Override
        public final Builder responsibilityTransferArns(Collection<String> responsibilityTransferArns) {
            this.responsibilityTransferArns = ResponsibilityTransferArnsListCopier.copy(responsibilityTransferArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder responsibilityTransferArns(String ... responsibilityTransferArns) {
            this.responsibilityTransferArns(Arrays.asList(responsibilityTransferArns));
            return this;
        }

        public ListBillingGroupsFilter build() {
            return new ListBillingGroupsFilter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ListBillingGroupsFilter> {
        public Builder arns(Collection<String> var1);

        public Builder arns(String ... var1);

        public Builder pricingPlan(String var1);

        public Builder statusesWithStrings(Collection<String> var1);

        public Builder statusesWithStrings(String ... var1);

        public Builder statuses(Collection<BillingGroupStatus> var1);

        public Builder statuses(BillingGroupStatus ... var1);

        public Builder autoAssociate(Boolean var1);

        public Builder primaryAccountIds(Collection<String> var1);

        public Builder primaryAccountIds(String ... var1);

        public Builder billingGroupTypesWithStrings(Collection<String> var1);

        public Builder billingGroupTypesWithStrings(String ... var1);

        public Builder billingGroupTypes(Collection<BillingGroupType> var1);

        public Builder billingGroupTypes(BillingGroupType ... var1);

        public Builder names(Collection<StringSearch> var1);

        public Builder names(StringSearch ... var1);

        public Builder names(Consumer<StringSearch.Builder> ... var1);

        public Builder responsibilityTransferArns(Collection<String> var1);

        public Builder responsibilityTransferArns(String ... var1);
    }
}

