/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.billingconductor.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.billingconductor.model.SearchOption;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StringSearch
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, StringSearch> {
    private static final SdkField<String> SEARCH_OPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SearchOption").getter(StringSearch.getter(StringSearch::searchOptionAsString)).setter(StringSearch.setter(Builder::searchOption)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SearchOption").build()}).build();
    private static final SdkField<String> SEARCH_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SearchValue").getter(StringSearch.getter(StringSearch::searchValue)).setter(StringSearch.setter(Builder::searchValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SearchValue").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SEARCH_OPTION_FIELD, SEARCH_VALUE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StringSearch.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String searchOption;
    private final String searchValue;

    private StringSearch(BuilderImpl builder) {
        this.searchOption = builder.searchOption;
        this.searchValue = builder.searchValue;
    }

    public final SearchOption searchOption() {
        return SearchOption.fromValue(this.searchOption);
    }

    public final String searchOptionAsString() {
        return this.searchOption;
    }

    public final String searchValue() {
        return this.searchValue;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.searchOptionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.searchValue());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StringSearch)) {
            return false;
        }
        StringSearch other = (StringSearch)obj;
        return Objects.equals(this.searchOptionAsString(), other.searchOptionAsString()) && Objects.equals(this.searchValue(), other.searchValue());
    }

    public final String toString() {
        return ToString.builder((String)"StringSearch").add("SearchOption", (Object)this.searchOptionAsString()).add("SearchValue", (Object)this.searchValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SearchOption": {
                return Optional.ofNullable(clazz.cast(this.searchOptionAsString()));
            }
            case "SearchValue": {
                return Optional.ofNullable(clazz.cast(this.searchValue()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("SearchOption", SEARCH_OPTION_FIELD);
        map.put("SearchValue", SEARCH_VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StringSearch, T> g) {
        return obj -> g.apply((StringSearch)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String searchOption;
        private String searchValue;

        private BuilderImpl() {
        }

        private BuilderImpl(StringSearch model) {
            this.searchOption(model.searchOption);
            this.searchValue(model.searchValue);
        }

        public final String getSearchOption() {
            return this.searchOption;
        }

        public final void setSearchOption(String searchOption) {
            this.searchOption = searchOption;
        }

        @Override
        public final Builder searchOption(String searchOption) {
            this.searchOption = searchOption;
            return this;
        }

        @Override
        public final Builder searchOption(SearchOption searchOption) {
            this.searchOption(searchOption == null ? null : searchOption.toString());
            return this;
        }

        public final String getSearchValue() {
            return this.searchValue;
        }

        public final void setSearchValue(String searchValue) {
            this.searchValue = searchValue;
        }

        @Override
        public final Builder searchValue(String searchValue) {
            this.searchValue = searchValue;
            return this;
        }

        public StringSearch build() {
            return new StringSearch(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, StringSearch> {
        public Builder searchOption(String var1);

        public Builder searchOption(SearchOption var1);

        public Builder searchValue(String var1);
    }
}

