/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.braket.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configures the resource instances to use while running the Amazon Braket hybrid job on Amazon Braket.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InstanceConfig implements SdkPojo, Serializable, ToCopyableBuilder<InstanceConfig.Builder, InstanceConfig> {
    private static final SdkField<Integer> INSTANCE_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("instanceCount").getter(getter(InstanceConfig::instanceCount)).setter(setter(Builder::instanceCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceCount").build()).build();

    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("instanceType").getter(getter(InstanceConfig::instanceTypeAsString))
            .setter(setter(Builder::instanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceType").build()).build();

    private static final SdkField<Integer> VOLUME_SIZE_IN_GB_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("volumeSizeInGb").getter(getter(InstanceConfig::volumeSizeInGb)).setter(setter(Builder::volumeSizeInGb))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("volumeSizeInGb").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_COUNT_FIELD,
            INSTANCE_TYPE_FIELD, VOLUME_SIZE_IN_GB_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer instanceCount;

    private final String instanceType;

    private final Integer volumeSizeInGb;

    private InstanceConfig(BuilderImpl builder) {
        this.instanceCount = builder.instanceCount;
        this.instanceType = builder.instanceType;
        this.volumeSizeInGb = builder.volumeSizeInGb;
    }

    /**
     * <p>
     * Configures the number of resource instances to use while running an Amazon Braket job on Amazon Braket. The
     * default value is 1.
     * </p>
     * 
     * @return Configures the number of resource instances to use while running an Amazon Braket job on Amazon Braket.
     *         The default value is 1.
     */
    public final Integer instanceCount() {
        return instanceCount;
    }

    /**
     * <p>
     * Configures the type resource instances to use while running an Amazon Braket hybrid job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceType} will
     * return {@link InstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #instanceTypeAsString}.
     * </p>
     * 
     * @return Configures the type resource instances to use while running an Amazon Braket hybrid job.
     * @see InstanceType
     */
    public final InstanceType instanceType() {
        return InstanceType.fromValue(instanceType);
    }

    /**
     * <p>
     * Configures the type resource instances to use while running an Amazon Braket hybrid job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceType} will
     * return {@link InstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #instanceTypeAsString}.
     * </p>
     * 
     * @return Configures the type resource instances to use while running an Amazon Braket hybrid job.
     * @see InstanceType
     */
    public final String instanceTypeAsString() {
        return instanceType;
    }

    /**
     * <p>
     * The size of the storage volume, in GB, that user wants to provision.
     * </p>
     * 
     * @return The size of the storage volume, in GB, that user wants to provision.
     */
    public final Integer volumeSizeInGb() {
        return volumeSizeInGb;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(instanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(instanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(volumeSizeInGb());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceConfig)) {
            return false;
        }
        InstanceConfig other = (InstanceConfig) obj;
        return Objects.equals(instanceCount(), other.instanceCount())
                && Objects.equals(instanceTypeAsString(), other.instanceTypeAsString())
                && Objects.equals(volumeSizeInGb(), other.volumeSizeInGb());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InstanceConfig").add("InstanceCount", instanceCount())
                .add("InstanceType", instanceTypeAsString()).add("VolumeSizeInGb", volumeSizeInGb()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "instanceCount":
            return Optional.ofNullable(clazz.cast(instanceCount()));
        case "instanceType":
            return Optional.ofNullable(clazz.cast(instanceTypeAsString()));
        case "volumeSizeInGb":
            return Optional.ofNullable(clazz.cast(volumeSizeInGb()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InstanceConfig, T> g) {
        return obj -> g.apply((InstanceConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InstanceConfig> {
        /**
         * <p>
         * Configures the number of resource instances to use while running an Amazon Braket job on Amazon Braket. The
         * default value is 1.
         * </p>
         * 
         * @param instanceCount
         *        Configures the number of resource instances to use while running an Amazon Braket job on Amazon
         *        Braket. The default value is 1.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceCount(Integer instanceCount);

        /**
         * <p>
         * Configures the type resource instances to use while running an Amazon Braket hybrid job.
         * </p>
         * 
         * @param instanceType
         *        Configures the type resource instances to use while running an Amazon Braket hybrid job.
         * @see InstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceType
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * Configures the type resource instances to use while running an Amazon Braket hybrid job.
         * </p>
         * 
         * @param instanceType
         *        Configures the type resource instances to use while running an Amazon Braket hybrid job.
         * @see InstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceType
         */
        Builder instanceType(InstanceType instanceType);

        /**
         * <p>
         * The size of the storage volume, in GB, that user wants to provision.
         * </p>
         * 
         * @param volumeSizeInGb
         *        The size of the storage volume, in GB, that user wants to provision.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeSizeInGb(Integer volumeSizeInGb);
    }

    static final class BuilderImpl implements Builder {
        private Integer instanceCount;

        private String instanceType;

        private Integer volumeSizeInGb;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceConfig model) {
            instanceCount(model.instanceCount);
            instanceType(model.instanceType);
            volumeSizeInGb(model.volumeSizeInGb);
        }

        public final Integer getInstanceCount() {
            return instanceCount;
        }

        public final void setInstanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
        }

        @Override
        public final Builder instanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
            return this;
        }

        public final String getInstanceType() {
            return instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        public final Builder instanceType(InstanceType instanceType) {
            this.instanceType(instanceType == null ? null : instanceType.toString());
            return this;
        }

        public final Integer getVolumeSizeInGb() {
            return volumeSizeInGb;
        }

        public final void setVolumeSizeInGb(Integer volumeSizeInGb) {
            this.volumeSizeInGb = volumeSizeInGb;
        }

        @Override
        public final Builder volumeSizeInGb(Integer volumeSizeInGb) {
            this.volumeSizeInGb = volumeSizeInGb;
            return this;
        }

        @Override
        public InstanceConfig build() {
            return new InstanceConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
