/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.braket.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.braket.model.BraketRequest;
import software.amazon.awssdk.services.braket.model.TagsMapCopier;
import software.amazon.awssdk.services.braket.model.TimePeriod;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateSpendingLimitRequest
extends BraketRequest
implements ToCopyableBuilder<Builder, CreateSpendingLimitRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CreateSpendingLimitRequest.getter(CreateSpendingLimitRequest::clientToken)).setter(CreateSpendingLimitRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> DEVICE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("deviceArn").getter(CreateSpendingLimitRequest.getter(CreateSpendingLimitRequest::deviceArn)).setter(CreateSpendingLimitRequest.setter(Builder::deviceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deviceArn").build()}).build();
    private static final SdkField<String> SPENDING_LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("spendingLimit").getter(CreateSpendingLimitRequest.getter(CreateSpendingLimitRequest::spendingLimit)).setter(CreateSpendingLimitRequest.setter(Builder::spendingLimit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("spendingLimit").build()}).build();
    private static final SdkField<TimePeriod> TIME_PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("timePeriod").getter(CreateSpendingLimitRequest.getter(CreateSpendingLimitRequest::timePeriod)).setter(CreateSpendingLimitRequest.setter(Builder::timePeriod)).constructor(TimePeriod::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timePeriod").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateSpendingLimitRequest.getter(CreateSpendingLimitRequest::tags)).setter(CreateSpendingLimitRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD, DEVICE_ARN_FIELD, SPENDING_LIMIT_FIELD, TIME_PERIOD_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateSpendingLimitRequest.memberNameToFieldInitializer();
    private final String clientToken;
    private final String deviceArn;
    private final String spendingLimit;
    private final TimePeriod timePeriod;
    private final Map<String, String> tags;

    private CreateSpendingLimitRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.deviceArn = builder.deviceArn;
        this.spendingLimit = builder.spendingLimit;
        this.timePeriod = builder.timePeriod;
        this.tags = builder.tags;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String deviceArn() {
        return this.deviceArn;
    }

    public final String spendingLimit() {
        return this.spendingLimit;
    }

    public final TimePeriod timePeriod() {
        return this.timePeriod;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.spendingLimit());
        hashCode = 31 * hashCode + Objects.hashCode(this.timePeriod());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSpendingLimitRequest)) {
            return false;
        }
        CreateSpendingLimitRequest other = (CreateSpendingLimitRequest)((Object)obj);
        return Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.deviceArn(), other.deviceArn()) && Objects.equals(this.spendingLimit(), other.spendingLimit()) && Objects.equals(this.timePeriod(), other.timePeriod()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateSpendingLimitRequest").add("ClientToken", (Object)this.clientToken()).add("DeviceArn", (Object)this.deviceArn()).add("SpendingLimit", (Object)this.spendingLimit()).add("TimePeriod", (Object)this.timePeriod()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "deviceArn": {
                return Optional.ofNullable(clazz.cast(this.deviceArn()));
            }
            case "spendingLimit": {
                return Optional.ofNullable(clazz.cast(this.spendingLimit()));
            }
            case "timePeriod": {
                return Optional.ofNullable(clazz.cast(this.timePeriod()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("deviceArn", DEVICE_ARN_FIELD);
        map.put("spendingLimit", SPENDING_LIMIT_FIELD);
        map.put("timePeriod", TIME_PERIOD_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateSpendingLimitRequest, T> g) {
        return obj -> g.apply((CreateSpendingLimitRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BraketRequest.BuilderImpl
    implements Builder {
        private String clientToken;
        private String deviceArn;
        private String spendingLimit;
        private TimePeriod timePeriod;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSpendingLimitRequest model) {
            super(model);
            this.clientToken(model.clientToken);
            this.deviceArn(model.deviceArn);
            this.spendingLimit(model.spendingLimit);
            this.timePeriod(model.timePeriod);
            this.tags(model.tags);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getDeviceArn() {
            return this.deviceArn;
        }

        public final void setDeviceArn(String deviceArn) {
            this.deviceArn = deviceArn;
        }

        @Override
        public final Builder deviceArn(String deviceArn) {
            this.deviceArn = deviceArn;
            return this;
        }

        public final String getSpendingLimit() {
            return this.spendingLimit;
        }

        public final void setSpendingLimit(String spendingLimit) {
            this.spendingLimit = spendingLimit;
        }

        @Override
        public final Builder spendingLimit(String spendingLimit) {
            this.spendingLimit = spendingLimit;
            return this;
        }

        public final TimePeriod.Builder getTimePeriod() {
            return this.timePeriod != null ? this.timePeriod.toBuilder() : null;
        }

        public final void setTimePeriod(TimePeriod.BuilderImpl timePeriod) {
            this.timePeriod = timePeriod != null ? timePeriod.build() : null;
        }

        @Override
        public final Builder timePeriod(TimePeriod timePeriod) {
            this.timePeriod = timePeriod;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateSpendingLimitRequest build() {
            return new CreateSpendingLimitRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BraketRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateSpendingLimitRequest> {
        public Builder clientToken(String var1);

        public Builder deviceArn(String var1);

        public Builder spendingLimit(String var1);

        public Builder timePeriod(TimePeriod var1);

        default public Builder timePeriod(Consumer<TimePeriod.Builder> timePeriod) {
            return this.timePeriod((TimePeriod)((TimePeriod.Builder)TimePeriod.builder().applyMutation(timePeriod)).build());
        }

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

