/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.braket.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.braket.model.BraketResponse;
import software.amazon.awssdk.services.braket.model.SpendingLimitSummary;
import software.amazon.awssdk.services.braket.model.SpendingLimitSummaryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SearchSpendingLimitsResponse
extends BraketResponse
implements ToCopyableBuilder<Builder, SearchSpendingLimitsResponse> {
    private static final SdkField<List<SpendingLimitSummary>> SPENDING_LIMITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("spendingLimits").getter(SearchSpendingLimitsResponse.getter(SearchSpendingLimitsResponse::spendingLimits)).setter(SearchSpendingLimitsResponse.setter(Builder::spendingLimits)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("spendingLimits").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SpendingLimitSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(SearchSpendingLimitsResponse.getter(SearchSpendingLimitsResponse::nextToken)).setter(SearchSpendingLimitsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SPENDING_LIMITS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SearchSpendingLimitsResponse.memberNameToFieldInitializer();
    private final List<SpendingLimitSummary> spendingLimits;
    private final String nextToken;

    private SearchSpendingLimitsResponse(BuilderImpl builder) {
        super(builder);
        this.spendingLimits = builder.spendingLimits;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasSpendingLimits() {
        return this.spendingLimits != null && !(this.spendingLimits instanceof SdkAutoConstructList);
    }

    public final List<SpendingLimitSummary> spendingLimits() {
        return this.spendingLimits;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSpendingLimits() ? this.spendingLimits() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchSpendingLimitsResponse)) {
            return false;
        }
        SearchSpendingLimitsResponse other = (SearchSpendingLimitsResponse)((Object)obj);
        return this.hasSpendingLimits() == other.hasSpendingLimits() && Objects.equals(this.spendingLimits(), other.spendingLimits()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"SearchSpendingLimitsResponse").add("SpendingLimits", this.hasSpendingLimits() ? this.spendingLimits() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "spendingLimits": {
                return Optional.ofNullable(clazz.cast(this.spendingLimits()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("spendingLimits", SPENDING_LIMITS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SearchSpendingLimitsResponse, T> g) {
        return obj -> g.apply((SearchSpendingLimitsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BraketResponse.BuilderImpl
    implements Builder {
        private List<SpendingLimitSummary> spendingLimits = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchSpendingLimitsResponse model) {
            super(model);
            this.spendingLimits(model.spendingLimits);
            this.nextToken(model.nextToken);
        }

        public final List<SpendingLimitSummary.Builder> getSpendingLimits() {
            List<SpendingLimitSummary.Builder> result = SpendingLimitSummaryListCopier.copyToBuilder(this.spendingLimits);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSpendingLimits(Collection<SpendingLimitSummary.BuilderImpl> spendingLimits) {
            this.spendingLimits = SpendingLimitSummaryListCopier.copyFromBuilder(spendingLimits);
        }

        @Override
        public final Builder spendingLimits(Collection<SpendingLimitSummary> spendingLimits) {
            this.spendingLimits = SpendingLimitSummaryListCopier.copy(spendingLimits);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder spendingLimits(SpendingLimitSummary ... spendingLimits) {
            this.spendingLimits(Arrays.asList(spendingLimits));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder spendingLimits(Consumer<SpendingLimitSummary.Builder> ... spendingLimits) {
            this.spendingLimits(Stream.of(spendingLimits).map(c -> (SpendingLimitSummary)((SpendingLimitSummary.Builder)SpendingLimitSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public SearchSpendingLimitsResponse build() {
            return new SearchSpendingLimitsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BraketResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SearchSpendingLimitsResponse> {
        public Builder spendingLimits(Collection<SpendingLimitSummary> var1);

        public Builder spendingLimits(SpendingLimitSummary ... var1);

        public Builder spendingLimits(Consumer<SpendingLimitSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

