/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.budgets.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.budgets.model.AutoAdjustData;
import software.amazon.awssdk.services.budgets.model.BudgetType;
import software.amazon.awssdk.services.budgets.model.CalculatedSpend;
import software.amazon.awssdk.services.budgets.model.CostFiltersCopier;
import software.amazon.awssdk.services.budgets.model.CostTypes;
import software.amazon.awssdk.services.budgets.model.Expression;
import software.amazon.awssdk.services.budgets.model.HealthStatus;
import software.amazon.awssdk.services.budgets.model.Metric;
import software.amazon.awssdk.services.budgets.model.MetricsCopier;
import software.amazon.awssdk.services.budgets.model.PlannedBudgetLimitsCopier;
import software.amazon.awssdk.services.budgets.model.Spend;
import software.amazon.awssdk.services.budgets.model.TimePeriod;
import software.amazon.awssdk.services.budgets.model.TimeUnit;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Budget
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Budget> {
    private static final SdkField<String> BUDGET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BudgetName").getter(Budget.getter(Budget::budgetName)).setter(Budget.setter(Builder::budgetName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BudgetName").build()}).build();
    private static final SdkField<Spend> BUDGET_LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("BudgetLimit").getter(Budget.getter(Budget::budgetLimit)).setter(Budget.setter(Builder::budgetLimit)).constructor(Spend::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BudgetLimit").build()}).build();
    private static final SdkField<Map<String, Spend>> PLANNED_BUDGET_LIMITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("PlannedBudgetLimits").getter(Budget.getter(Budget::plannedBudgetLimits)).setter(Budget.setter(Builder::plannedBudgetLimits)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlannedBudgetLimits").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Spend::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, List<String>>> COST_FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("CostFilters").getter(Budget.getter(Budget::costFilters)).setter(Budget.setter(Builder::costFilters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CostFilters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build();
    private static final SdkField<CostTypes> COST_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CostTypes").getter(Budget.getter(Budget::costTypes)).setter(Budget.setter(Builder::costTypes)).constructor(CostTypes::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CostTypes").build()}).build();
    private static final SdkField<String> TIME_UNIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TimeUnit").getter(Budget.getter(Budget::timeUnitAsString)).setter(Budget.setter(Builder::timeUnit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeUnit").build()}).build();
    private static final SdkField<TimePeriod> TIME_PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TimePeriod").getter(Budget.getter(Budget::timePeriod)).setter(Budget.setter(Builder::timePeriod)).constructor(TimePeriod::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimePeriod").build()}).build();
    private static final SdkField<CalculatedSpend> CALCULATED_SPEND_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CalculatedSpend").getter(Budget.getter(Budget::calculatedSpend)).setter(Budget.setter(Builder::calculatedSpend)).constructor(CalculatedSpend::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CalculatedSpend").build()}).build();
    private static final SdkField<String> BUDGET_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BudgetType").getter(Budget.getter(Budget::budgetTypeAsString)).setter(Budget.setter(Builder::budgetType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BudgetType").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdatedTime").getter(Budget.getter(Budget::lastUpdatedTime)).setter(Budget.setter(Builder::lastUpdatedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTime").build()}).build();
    private static final SdkField<AutoAdjustData> AUTO_ADJUST_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AutoAdjustData").getter(Budget.getter(Budget::autoAdjustData)).setter(Budget.setter(Builder::autoAdjustData)).constructor(AutoAdjustData::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoAdjustData").build()}).build();
    private static final SdkField<Expression> FILTER_EXPRESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FilterExpression").getter(Budget.getter(Budget::filterExpression)).setter(Budget.setter(Builder::filterExpression)).constructor(Expression::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilterExpression").build()}).build();
    private static final SdkField<List<String>> METRICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Metrics").getter(Budget.getter(Budget::metricsAsStrings)).setter(Budget.setter(Builder::metricsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Metrics").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> BILLING_VIEW_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BillingViewArn").getter(Budget.getter(Budget::billingViewArn)).setter(Budget.setter(Builder::billingViewArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BillingViewArn").build()}).build();
    private static final SdkField<HealthStatus> HEALTH_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("HealthStatus").getter(Budget.getter(Budget::healthStatus)).setter(Budget.setter(Builder::healthStatus)).constructor(HealthStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HealthStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUDGET_NAME_FIELD, BUDGET_LIMIT_FIELD, PLANNED_BUDGET_LIMITS_FIELD, COST_FILTERS_FIELD, COST_TYPES_FIELD, TIME_UNIT_FIELD, TIME_PERIOD_FIELD, CALCULATED_SPEND_FIELD, BUDGET_TYPE_FIELD, LAST_UPDATED_TIME_FIELD, AUTO_ADJUST_DATA_FIELD, FILTER_EXPRESSION_FIELD, METRICS_FIELD, BILLING_VIEW_ARN_FIELD, HEALTH_STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Budget.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String budgetName;
    private final Spend budgetLimit;
    private final Map<String, Spend> plannedBudgetLimits;
    private final Map<String, List<String>> costFilters;
    private final CostTypes costTypes;
    private final String timeUnit;
    private final TimePeriod timePeriod;
    private final CalculatedSpend calculatedSpend;
    private final String budgetType;
    private final Instant lastUpdatedTime;
    private final AutoAdjustData autoAdjustData;
    private final Expression filterExpression;
    private final List<String> metrics;
    private final String billingViewArn;
    private final HealthStatus healthStatus;

    private Budget(BuilderImpl builder) {
        this.budgetName = builder.budgetName;
        this.budgetLimit = builder.budgetLimit;
        this.plannedBudgetLimits = builder.plannedBudgetLimits;
        this.costFilters = builder.costFilters;
        this.costTypes = builder.costTypes;
        this.timeUnit = builder.timeUnit;
        this.timePeriod = builder.timePeriod;
        this.calculatedSpend = builder.calculatedSpend;
        this.budgetType = builder.budgetType;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.autoAdjustData = builder.autoAdjustData;
        this.filterExpression = builder.filterExpression;
        this.metrics = builder.metrics;
        this.billingViewArn = builder.billingViewArn;
        this.healthStatus = builder.healthStatus;
    }

    public final String budgetName() {
        return this.budgetName;
    }

    public final Spend budgetLimit() {
        return this.budgetLimit;
    }

    public final boolean hasPlannedBudgetLimits() {
        return this.plannedBudgetLimits != null && !(this.plannedBudgetLimits instanceof SdkAutoConstructMap);
    }

    public final Map<String, Spend> plannedBudgetLimits() {
        return this.plannedBudgetLimits;
    }

    @Deprecated
    public final boolean hasCostFilters() {
        return this.costFilters != null && !(this.costFilters instanceof SdkAutoConstructMap);
    }

    @Deprecated
    public final Map<String, List<String>> costFilters() {
        return this.costFilters;
    }

    @Deprecated
    public final CostTypes costTypes() {
        return this.costTypes;
    }

    public final TimeUnit timeUnit() {
        return TimeUnit.fromValue(this.timeUnit);
    }

    public final String timeUnitAsString() {
        return this.timeUnit;
    }

    public final TimePeriod timePeriod() {
        return this.timePeriod;
    }

    public final CalculatedSpend calculatedSpend() {
        return this.calculatedSpend;
    }

    public final BudgetType budgetType() {
        return BudgetType.fromValue(this.budgetType);
    }

    public final String budgetTypeAsString() {
        return this.budgetType;
    }

    public final Instant lastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public final AutoAdjustData autoAdjustData() {
        return this.autoAdjustData;
    }

    public final Expression filterExpression() {
        return this.filterExpression;
    }

    public final List<Metric> metrics() {
        return MetricsCopier.copyStringToEnum(this.metrics);
    }

    public final boolean hasMetrics() {
        return this.metrics != null && !(this.metrics instanceof SdkAutoConstructList);
    }

    public final List<String> metricsAsStrings() {
        return this.metrics;
    }

    public final String billingViewArn() {
        return this.billingViewArn;
    }

    public final HealthStatus healthStatus() {
        return this.healthStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.budgetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.budgetLimit());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPlannedBudgetLimits() ? this.plannedBudgetLimits() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCostFilters() ? this.costFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.costTypes());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeUnitAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.timePeriod());
        hashCode = 31 * hashCode + Objects.hashCode(this.calculatedSpend());
        hashCode = 31 * hashCode + Objects.hashCode(this.budgetTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoAdjustData());
        hashCode = 31 * hashCode + Objects.hashCode(this.filterExpression());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMetrics() ? this.metricsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.billingViewArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.healthStatus());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Budget)) {
            return false;
        }
        Budget other = (Budget)obj;
        return Objects.equals(this.budgetName(), other.budgetName()) && Objects.equals(this.budgetLimit(), other.budgetLimit()) && this.hasPlannedBudgetLimits() == other.hasPlannedBudgetLimits() && Objects.equals(this.plannedBudgetLimits(), other.plannedBudgetLimits()) && this.hasCostFilters() == other.hasCostFilters() && Objects.equals(this.costFilters(), other.costFilters()) && Objects.equals(this.costTypes(), other.costTypes()) && Objects.equals(this.timeUnitAsString(), other.timeUnitAsString()) && Objects.equals(this.timePeriod(), other.timePeriod()) && Objects.equals(this.calculatedSpend(), other.calculatedSpend()) && Objects.equals(this.budgetTypeAsString(), other.budgetTypeAsString()) && Objects.equals(this.lastUpdatedTime(), other.lastUpdatedTime()) && Objects.equals(this.autoAdjustData(), other.autoAdjustData()) && Objects.equals(this.filterExpression(), other.filterExpression()) && this.hasMetrics() == other.hasMetrics() && Objects.equals(this.metricsAsStrings(), other.metricsAsStrings()) && Objects.equals(this.billingViewArn(), other.billingViewArn()) && Objects.equals(this.healthStatus(), other.healthStatus());
    }

    public final String toString() {
        return ToString.builder((String)"Budget").add("BudgetName", (Object)this.budgetName()).add("BudgetLimit", (Object)this.budgetLimit()).add("PlannedBudgetLimits", this.hasPlannedBudgetLimits() ? this.plannedBudgetLimits() : null).add("CostFilters", this.hasCostFilters() ? this.costFilters() : null).add("CostTypes", (Object)this.costTypes()).add("TimeUnit", (Object)this.timeUnitAsString()).add("TimePeriod", (Object)this.timePeriod()).add("CalculatedSpend", (Object)this.calculatedSpend()).add("BudgetType", (Object)this.budgetTypeAsString()).add("LastUpdatedTime", (Object)this.lastUpdatedTime()).add("AutoAdjustData", (Object)this.autoAdjustData()).add("FilterExpression", (Object)this.filterExpression()).add("Metrics", this.hasMetrics() ? this.metricsAsStrings() : null).add("BillingViewArn", (Object)this.billingViewArn()).add("HealthStatus", (Object)this.healthStatus()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BudgetName": {
                return Optional.ofNullable(clazz.cast(this.budgetName()));
            }
            case "BudgetLimit": {
                return Optional.ofNullable(clazz.cast(this.budgetLimit()));
            }
            case "PlannedBudgetLimits": {
                return Optional.ofNullable(clazz.cast(this.plannedBudgetLimits()));
            }
            case "CostFilters": {
                return Optional.ofNullable(clazz.cast(this.costFilters()));
            }
            case "CostTypes": {
                return Optional.ofNullable(clazz.cast(this.costTypes()));
            }
            case "TimeUnit": {
                return Optional.ofNullable(clazz.cast(this.timeUnitAsString()));
            }
            case "TimePeriod": {
                return Optional.ofNullable(clazz.cast(this.timePeriod()));
            }
            case "CalculatedSpend": {
                return Optional.ofNullable(clazz.cast(this.calculatedSpend()));
            }
            case "BudgetType": {
                return Optional.ofNullable(clazz.cast(this.budgetTypeAsString()));
            }
            case "LastUpdatedTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedTime()));
            }
            case "AutoAdjustData": {
                return Optional.ofNullable(clazz.cast(this.autoAdjustData()));
            }
            case "FilterExpression": {
                return Optional.ofNullable(clazz.cast(this.filterExpression()));
            }
            case "Metrics": {
                return Optional.ofNullable(clazz.cast(this.metricsAsStrings()));
            }
            case "BillingViewArn": {
                return Optional.ofNullable(clazz.cast(this.billingViewArn()));
            }
            case "HealthStatus": {
                return Optional.ofNullable(clazz.cast(this.healthStatus()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("BudgetName", BUDGET_NAME_FIELD);
        map.put("BudgetLimit", BUDGET_LIMIT_FIELD);
        map.put("PlannedBudgetLimits", PLANNED_BUDGET_LIMITS_FIELD);
        map.put("CostFilters", COST_FILTERS_FIELD);
        map.put("CostTypes", COST_TYPES_FIELD);
        map.put("TimeUnit", TIME_UNIT_FIELD);
        map.put("TimePeriod", TIME_PERIOD_FIELD);
        map.put("CalculatedSpend", CALCULATED_SPEND_FIELD);
        map.put("BudgetType", BUDGET_TYPE_FIELD);
        map.put("LastUpdatedTime", LAST_UPDATED_TIME_FIELD);
        map.put("AutoAdjustData", AUTO_ADJUST_DATA_FIELD);
        map.put("FilterExpression", FILTER_EXPRESSION_FIELD);
        map.put("Metrics", METRICS_FIELD);
        map.put("BillingViewArn", BILLING_VIEW_ARN_FIELD);
        map.put("HealthStatus", HEALTH_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Budget, T> g) {
        return obj -> g.apply((Budget)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String budgetName;
        private Spend budgetLimit;
        private Map<String, Spend> plannedBudgetLimits = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, List<String>> costFilters = DefaultSdkAutoConstructMap.getInstance();
        private CostTypes costTypes;
        private String timeUnit;
        private TimePeriod timePeriod;
        private CalculatedSpend calculatedSpend;
        private String budgetType;
        private Instant lastUpdatedTime;
        private AutoAdjustData autoAdjustData;
        private Expression filterExpression;
        private List<String> metrics = DefaultSdkAutoConstructList.getInstance();
        private String billingViewArn;
        private HealthStatus healthStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(Budget model) {
            this.budgetName(model.budgetName);
            this.budgetLimit(model.budgetLimit);
            this.plannedBudgetLimits(model.plannedBudgetLimits);
            this.costFilters(model.costFilters);
            this.costTypes(model.costTypes);
            this.timeUnit(model.timeUnit);
            this.timePeriod(model.timePeriod);
            this.calculatedSpend(model.calculatedSpend);
            this.budgetType(model.budgetType);
            this.lastUpdatedTime(model.lastUpdatedTime);
            this.autoAdjustData(model.autoAdjustData);
            this.filterExpression(model.filterExpression);
            this.metricsWithStrings(model.metrics);
            this.billingViewArn(model.billingViewArn);
            this.healthStatus(model.healthStatus);
        }

        public final String getBudgetName() {
            return this.budgetName;
        }

        public final void setBudgetName(String budgetName) {
            this.budgetName = budgetName;
        }

        @Override
        public final Builder budgetName(String budgetName) {
            this.budgetName = budgetName;
            return this;
        }

        public final Spend.Builder getBudgetLimit() {
            return this.budgetLimit != null ? this.budgetLimit.toBuilder() : null;
        }

        public final void setBudgetLimit(Spend.BuilderImpl budgetLimit) {
            this.budgetLimit = budgetLimit != null ? budgetLimit.build() : null;
        }

        @Override
        public final Builder budgetLimit(Spend budgetLimit) {
            this.budgetLimit = budgetLimit;
            return this;
        }

        public final Map<String, Spend.Builder> getPlannedBudgetLimits() {
            Map<String, Spend.Builder> result = PlannedBudgetLimitsCopier.copyToBuilder(this.plannedBudgetLimits);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setPlannedBudgetLimits(Map<String, Spend.BuilderImpl> plannedBudgetLimits) {
            this.plannedBudgetLimits = PlannedBudgetLimitsCopier.copyFromBuilder(plannedBudgetLimits);
        }

        @Override
        public final Builder plannedBudgetLimits(Map<String, Spend> plannedBudgetLimits) {
            this.plannedBudgetLimits = PlannedBudgetLimitsCopier.copy(plannedBudgetLimits);
            return this;
        }

        @Deprecated
        public final Map<String, ? extends Collection<String>> getCostFilters() {
            if (this.costFilters instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.costFilters;
        }

        @Deprecated
        public final void setCostFilters(Map<String, ? extends Collection<String>> costFilters) {
            this.costFilters = CostFiltersCopier.copy(costFilters);
        }

        @Override
        @Deprecated
        public final Builder costFilters(Map<String, ? extends Collection<String>> costFilters) {
            this.costFilters = CostFiltersCopier.copy(costFilters);
            return this;
        }

        @Deprecated
        public final CostTypes.Builder getCostTypes() {
            return this.costTypes != null ? this.costTypes.toBuilder() : null;
        }

        @Deprecated
        public final void setCostTypes(CostTypes.BuilderImpl costTypes) {
            this.costTypes = costTypes != null ? costTypes.build() : null;
        }

        @Override
        @Deprecated
        public final Builder costTypes(CostTypes costTypes) {
            this.costTypes = costTypes;
            return this;
        }

        public final String getTimeUnit() {
            return this.timeUnit;
        }

        public final void setTimeUnit(String timeUnit) {
            this.timeUnit = timeUnit;
        }

        @Override
        public final Builder timeUnit(String timeUnit) {
            this.timeUnit = timeUnit;
            return this;
        }

        @Override
        public final Builder timeUnit(TimeUnit timeUnit) {
            this.timeUnit(timeUnit == null ? null : timeUnit.toString());
            return this;
        }

        public final TimePeriod.Builder getTimePeriod() {
            return this.timePeriod != null ? this.timePeriod.toBuilder() : null;
        }

        public final void setTimePeriod(TimePeriod.BuilderImpl timePeriod) {
            this.timePeriod = timePeriod != null ? timePeriod.build() : null;
        }

        @Override
        public final Builder timePeriod(TimePeriod timePeriod) {
            this.timePeriod = timePeriod;
            return this;
        }

        public final CalculatedSpend.Builder getCalculatedSpend() {
            return this.calculatedSpend != null ? this.calculatedSpend.toBuilder() : null;
        }

        public final void setCalculatedSpend(CalculatedSpend.BuilderImpl calculatedSpend) {
            this.calculatedSpend = calculatedSpend != null ? calculatedSpend.build() : null;
        }

        @Override
        public final Builder calculatedSpend(CalculatedSpend calculatedSpend) {
            this.calculatedSpend = calculatedSpend;
            return this;
        }

        public final String getBudgetType() {
            return this.budgetType;
        }

        public final void setBudgetType(String budgetType) {
            this.budgetType = budgetType;
        }

        @Override
        public final Builder budgetType(String budgetType) {
            this.budgetType = budgetType;
            return this;
        }

        @Override
        public final Builder budgetType(BudgetType budgetType) {
            this.budgetType(budgetType == null ? null : budgetType.toString());
            return this;
        }

        public final Instant getLastUpdatedTime() {
            return this.lastUpdatedTime;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final AutoAdjustData.Builder getAutoAdjustData() {
            return this.autoAdjustData != null ? this.autoAdjustData.toBuilder() : null;
        }

        public final void setAutoAdjustData(AutoAdjustData.BuilderImpl autoAdjustData) {
            this.autoAdjustData = autoAdjustData != null ? autoAdjustData.build() : null;
        }

        @Override
        public final Builder autoAdjustData(AutoAdjustData autoAdjustData) {
            this.autoAdjustData = autoAdjustData;
            return this;
        }

        public final Expression.Builder getFilterExpression() {
            return this.filterExpression != null ? this.filterExpression.toBuilder() : null;
        }

        public final void setFilterExpression(Expression.BuilderImpl filterExpression) {
            this.filterExpression = filterExpression != null ? filterExpression.build() : null;
        }

        @Override
        public final Builder filterExpression(Expression filterExpression) {
            this.filterExpression = filterExpression;
            return this;
        }

        public final Collection<String> getMetrics() {
            if (this.metrics instanceof SdkAutoConstructList) {
                return null;
            }
            return this.metrics;
        }

        public final void setMetrics(Collection<String> metrics) {
            this.metrics = MetricsCopier.copy(metrics);
        }

        @Override
        public final Builder metricsWithStrings(Collection<String> metrics) {
            this.metrics = MetricsCopier.copy(metrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricsWithStrings(String ... metrics) {
            this.metricsWithStrings(Arrays.asList(metrics));
            return this;
        }

        @Override
        public final Builder metrics(Collection<Metric> metrics) {
            this.metrics = MetricsCopier.copyEnumToString(metrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metrics(Metric ... metrics) {
            this.metrics(Arrays.asList(metrics));
            return this;
        }

        public final String getBillingViewArn() {
            return this.billingViewArn;
        }

        public final void setBillingViewArn(String billingViewArn) {
            this.billingViewArn = billingViewArn;
        }

        @Override
        public final Builder billingViewArn(String billingViewArn) {
            this.billingViewArn = billingViewArn;
            return this;
        }

        public final HealthStatus.Builder getHealthStatus() {
            return this.healthStatus != null ? this.healthStatus.toBuilder() : null;
        }

        public final void setHealthStatus(HealthStatus.BuilderImpl healthStatus) {
            this.healthStatus = healthStatus != null ? healthStatus.build() : null;
        }

        @Override
        public final Builder healthStatus(HealthStatus healthStatus) {
            this.healthStatus = healthStatus;
            return this;
        }

        public Budget build() {
            return new Budget(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Budget> {
        public Builder budgetName(String var1);

        public Builder budgetLimit(Spend var1);

        default public Builder budgetLimit(Consumer<Spend.Builder> budgetLimit) {
            return this.budgetLimit((Spend)((Spend.Builder)Spend.builder().applyMutation(budgetLimit)).build());
        }

        public Builder plannedBudgetLimits(Map<String, Spend> var1);

        @Deprecated
        public Builder costFilters(Map<String, ? extends Collection<String>> var1);

        @Deprecated
        public Builder costTypes(CostTypes var1);

        @Deprecated
        default public Builder costTypes(Consumer<CostTypes.Builder> costTypes) {
            return this.costTypes((CostTypes)((CostTypes.Builder)CostTypes.builder().applyMutation(costTypes)).build());
        }

        public Builder timeUnit(String var1);

        public Builder timeUnit(TimeUnit var1);

        public Builder timePeriod(TimePeriod var1);

        default public Builder timePeriod(Consumer<TimePeriod.Builder> timePeriod) {
            return this.timePeriod((TimePeriod)((TimePeriod.Builder)TimePeriod.builder().applyMutation(timePeriod)).build());
        }

        public Builder calculatedSpend(CalculatedSpend var1);

        default public Builder calculatedSpend(Consumer<CalculatedSpend.Builder> calculatedSpend) {
            return this.calculatedSpend((CalculatedSpend)((CalculatedSpend.Builder)CalculatedSpend.builder().applyMutation(calculatedSpend)).build());
        }

        public Builder budgetType(String var1);

        public Builder budgetType(BudgetType var1);

        public Builder lastUpdatedTime(Instant var1);

        public Builder autoAdjustData(AutoAdjustData var1);

        default public Builder autoAdjustData(Consumer<AutoAdjustData.Builder> autoAdjustData) {
            return this.autoAdjustData((AutoAdjustData)((AutoAdjustData.Builder)AutoAdjustData.builder().applyMutation(autoAdjustData)).build());
        }

        public Builder filterExpression(Expression var1);

        default public Builder filterExpression(Consumer<Expression.Builder> filterExpression) {
            return this.filterExpression((Expression)((Expression.Builder)Expression.builder().applyMutation(filterExpression)).build());
        }

        public Builder metricsWithStrings(Collection<String> var1);

        public Builder metricsWithStrings(String ... var1);

        public Builder metrics(Collection<Metric> var1);

        public Builder metrics(Metric ... var1);

        public Builder billingViewArn(String var1);

        public Builder healthStatus(HealthStatus var1);

        default public Builder healthStatus(Consumer<HealthStatus.Builder> healthStatus) {
            return this.healthStatus((HealthStatus)((HealthStatus.Builder)HealthStatus.builder().applyMutation(healthStatus)).build());
        }
    }
}

