/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.budgets.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.budgets.model.Dimension;
import software.amazon.awssdk.services.budgets.model.MatchOption;
import software.amazon.awssdk.services.budgets.model.MatchOptionsCopier;
import software.amazon.awssdk.services.budgets.model.ValuesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExpressionDimensionValues
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ExpressionDimensionValues> {
    private static final SdkField<String> KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Key").getter(ExpressionDimensionValues.getter(ExpressionDimensionValues::keyAsString)).setter(ExpressionDimensionValues.setter(Builder::key)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Key").build()}).build();
    private static final SdkField<List<String>> VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Values").getter(ExpressionDimensionValues.getter(ExpressionDimensionValues::values)).setter(ExpressionDimensionValues.setter(Builder::values)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Values").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> MATCH_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MatchOptions").getter(ExpressionDimensionValues.getter(ExpressionDimensionValues::matchOptionsAsStrings)).setter(ExpressionDimensionValues.setter(Builder::matchOptionsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MatchOptions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_FIELD, VALUES_FIELD, MATCH_OPTIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ExpressionDimensionValues.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String key;
    private final List<String> values;
    private final List<String> matchOptions;

    private ExpressionDimensionValues(BuilderImpl builder) {
        this.key = builder.key;
        this.values = builder.values;
        this.matchOptions = builder.matchOptions;
    }

    public final Dimension key() {
        return Dimension.fromValue(this.key);
    }

    public final String keyAsString() {
        return this.key;
    }

    public final boolean hasValues() {
        return this.values != null && !(this.values instanceof SdkAutoConstructList);
    }

    public final List<String> values() {
        return this.values;
    }

    public final List<MatchOption> matchOptions() {
        return MatchOptionsCopier.copyStringToEnum(this.matchOptions);
    }

    public final boolean hasMatchOptions() {
        return this.matchOptions != null && !(this.matchOptions instanceof SdkAutoConstructList);
    }

    public final List<String> matchOptionsAsStrings() {
        return this.matchOptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.keyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasValues() ? this.values() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMatchOptions() ? this.matchOptionsAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExpressionDimensionValues)) {
            return false;
        }
        ExpressionDimensionValues other = (ExpressionDimensionValues)obj;
        return Objects.equals(this.keyAsString(), other.keyAsString()) && this.hasValues() == other.hasValues() && Objects.equals(this.values(), other.values()) && this.hasMatchOptions() == other.hasMatchOptions() && Objects.equals(this.matchOptionsAsStrings(), other.matchOptionsAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"ExpressionDimensionValues").add("Key", (Object)this.keyAsString()).add("Values", this.hasValues() ? this.values() : null).add("MatchOptions", this.hasMatchOptions() ? this.matchOptionsAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Key": {
                return Optional.ofNullable(clazz.cast(this.keyAsString()));
            }
            case "Values": {
                return Optional.ofNullable(clazz.cast(this.values()));
            }
            case "MatchOptions": {
                return Optional.ofNullable(clazz.cast(this.matchOptionsAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Key", KEY_FIELD);
        map.put("Values", VALUES_FIELD);
        map.put("MatchOptions", MATCH_OPTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExpressionDimensionValues, T> g) {
        return obj -> g.apply((ExpressionDimensionValues)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String key;
        private List<String> values = DefaultSdkAutoConstructList.getInstance();
        private List<String> matchOptions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ExpressionDimensionValues model) {
            this.key(model.key);
            this.values(model.values);
            this.matchOptionsWithStrings(model.matchOptions);
        }

        public final String getKey() {
            return this.key;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        @Override
        public final Builder key(Dimension key) {
            this.key(key == null ? null : key.toString());
            return this;
        }

        public final Collection<String> getValues() {
            if (this.values instanceof SdkAutoConstructList) {
                return null;
            }
            return this.values;
        }

        public final void setValues(Collection<String> values) {
            this.values = ValuesCopier.copy(values);
        }

        @Override
        public final Builder values(Collection<String> values) {
            this.values = ValuesCopier.copy(values);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(String ... values) {
            this.values(Arrays.asList(values));
            return this;
        }

        public final Collection<String> getMatchOptions() {
            if (this.matchOptions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.matchOptions;
        }

        public final void setMatchOptions(Collection<String> matchOptions) {
            this.matchOptions = MatchOptionsCopier.copy(matchOptions);
        }

        @Override
        public final Builder matchOptionsWithStrings(Collection<String> matchOptions) {
            this.matchOptions = MatchOptionsCopier.copy(matchOptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder matchOptionsWithStrings(String ... matchOptions) {
            this.matchOptionsWithStrings(Arrays.asList(matchOptions));
            return this;
        }

        @Override
        public final Builder matchOptions(Collection<MatchOption> matchOptions) {
            this.matchOptions = MatchOptionsCopier.copyEnumToString(matchOptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder matchOptions(MatchOption ... matchOptions) {
            this.matchOptions(Arrays.asList(matchOptions));
            return this;
        }

        public ExpressionDimensionValues build() {
            return new ExpressionDimensionValues(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ExpressionDimensionValues> {
        public Builder key(String var1);

        public Builder key(Dimension var1);

        public Builder values(Collection<String> var1);

        public Builder values(String ... var1);

        public Builder matchOptionsWithStrings(Collection<String> var1);

        public Builder matchOptionsWithStrings(String ... var1);

        public Builder matchOptions(Collection<MatchOption> var1);

        public Builder matchOptions(MatchOption ... var1);
    }
}

