/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration that allows a bot to receive outgoing events. Can be either an HTTPS endpoint or a Lambda function
 * ARN.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EventsConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<EventsConfiguration.Builder, EventsConfiguration> {
    private static final SdkField<String> BOT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("BotId")
            .getter(getter(EventsConfiguration::botId)).setter(setter(Builder::botId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BotId").build()).build();

    private static final SdkField<String> OUTBOUND_EVENTS_HTTPS_ENDPOINT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("OutboundEventsHTTPSEndpoint")
            .getter(getter(EventsConfiguration::outboundEventsHTTPSEndpoint))
            .setter(setter(Builder::outboundEventsHTTPSEndpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutboundEventsHTTPSEndpoint")
                    .build()).build();

    private static final SdkField<String> LAMBDA_FUNCTION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LambdaFunctionArn").getter(getter(EventsConfiguration::lambdaFunctionArn))
            .setter(setter(Builder::lambdaFunctionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LambdaFunctionArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOT_ID_FIELD,
            OUTBOUND_EVENTS_HTTPS_ENDPOINT_FIELD, LAMBDA_FUNCTION_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String botId;

    private final String outboundEventsHTTPSEndpoint;

    private final String lambdaFunctionArn;

    private EventsConfiguration(BuilderImpl builder) {
        this.botId = builder.botId;
        this.outboundEventsHTTPSEndpoint = builder.outboundEventsHTTPSEndpoint;
        this.lambdaFunctionArn = builder.lambdaFunctionArn;
    }

    /**
     * <p>
     * The bot ID.
     * </p>
     * 
     * @return The bot ID.
     */
    public final String botId() {
        return botId;
    }

    /**
     * <p>
     * HTTPS endpoint that allows a bot to receive outgoing events.
     * </p>
     * 
     * @return HTTPS endpoint that allows a bot to receive outgoing events.
     */
    public final String outboundEventsHTTPSEndpoint() {
        return outboundEventsHTTPSEndpoint;
    }

    /**
     * <p>
     * Lambda function ARN that allows a bot to receive outgoing events.
     * </p>
     * 
     * @return Lambda function ARN that allows a bot to receive outgoing events.
     */
    public final String lambdaFunctionArn() {
        return lambdaFunctionArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(botId());
        hashCode = 31 * hashCode + Objects.hashCode(outboundEventsHTTPSEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(lambdaFunctionArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventsConfiguration)) {
            return false;
        }
        EventsConfiguration other = (EventsConfiguration) obj;
        return Objects.equals(botId(), other.botId())
                && Objects.equals(outboundEventsHTTPSEndpoint(), other.outboundEventsHTTPSEndpoint())
                && Objects.equals(lambdaFunctionArn(), other.lambdaFunctionArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("EventsConfiguration")
                .add("BotId", botId())
                .add("OutboundEventsHTTPSEndpoint",
                        outboundEventsHTTPSEndpoint() == null ? null : "*** Sensitive Data Redacted ***")
                .add("LambdaFunctionArn", lambdaFunctionArn() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BotId":
            return Optional.ofNullable(clazz.cast(botId()));
        case "OutboundEventsHTTPSEndpoint":
            return Optional.ofNullable(clazz.cast(outboundEventsHTTPSEndpoint()));
        case "LambdaFunctionArn":
            return Optional.ofNullable(clazz.cast(lambdaFunctionArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EventsConfiguration, T> g) {
        return obj -> g.apply((EventsConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EventsConfiguration> {
        /**
         * <p>
         * The bot ID.
         * </p>
         * 
         * @param botId
         *        The bot ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botId(String botId);

        /**
         * <p>
         * HTTPS endpoint that allows a bot to receive outgoing events.
         * </p>
         * 
         * @param outboundEventsHTTPSEndpoint
         *        HTTPS endpoint that allows a bot to receive outgoing events.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outboundEventsHTTPSEndpoint(String outboundEventsHTTPSEndpoint);

        /**
         * <p>
         * Lambda function ARN that allows a bot to receive outgoing events.
         * </p>
         * 
         * @param lambdaFunctionArn
         *        Lambda function ARN that allows a bot to receive outgoing events.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lambdaFunctionArn(String lambdaFunctionArn);
    }

    static final class BuilderImpl implements Builder {
        private String botId;

        private String outboundEventsHTTPSEndpoint;

        private String lambdaFunctionArn;

        private BuilderImpl() {
        }

        private BuilderImpl(EventsConfiguration model) {
            botId(model.botId);
            outboundEventsHTTPSEndpoint(model.outboundEventsHTTPSEndpoint);
            lambdaFunctionArn(model.lambdaFunctionArn);
        }

        public final String getBotId() {
            return botId;
        }

        public final void setBotId(String botId) {
            this.botId = botId;
        }

        @Override
        public final Builder botId(String botId) {
            this.botId = botId;
            return this;
        }

        public final String getOutboundEventsHTTPSEndpoint() {
            return outboundEventsHTTPSEndpoint;
        }

        public final void setOutboundEventsHTTPSEndpoint(String outboundEventsHTTPSEndpoint) {
            this.outboundEventsHTTPSEndpoint = outboundEventsHTTPSEndpoint;
        }

        @Override
        public final Builder outboundEventsHTTPSEndpoint(String outboundEventsHTTPSEndpoint) {
            this.outboundEventsHTTPSEndpoint = outboundEventsHTTPSEndpoint;
            return this;
        }

        public final String getLambdaFunctionArn() {
            return lambdaFunctionArn;
        }

        public final void setLambdaFunctionArn(String lambdaFunctionArn) {
            this.lambdaFunctionArn = lambdaFunctionArn;
        }

        @Override
        public final Builder lambdaFunctionArn(String lambdaFunctionArn) {
            this.lambdaFunctionArn = lambdaFunctionArn;
            return this;
        }

        @Override
        public EventsConfiguration build() {
            return new EventsConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
