/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chimesdkidentity.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.chimesdkidentity.model.AppInstanceBotListCopier;
import software.amazon.awssdk.services.chimesdkidentity.model.AppInstanceBotSummary;
import software.amazon.awssdk.services.chimesdkidentity.model.ChimeSdkIdentityResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAppInstanceBotsResponse
extends ChimeSdkIdentityResponse
implements ToCopyableBuilder<Builder, ListAppInstanceBotsResponse> {
    private static final SdkField<String> APP_INSTANCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AppInstanceArn").getter(ListAppInstanceBotsResponse.getter(ListAppInstanceBotsResponse::appInstanceArn)).setter(ListAppInstanceBotsResponse.setter(Builder::appInstanceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppInstanceArn").build()}).build();
    private static final SdkField<List<AppInstanceBotSummary>> APP_INSTANCE_BOTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AppInstanceBots").getter(ListAppInstanceBotsResponse.getter(ListAppInstanceBotsResponse::appInstanceBots)).setter(ListAppInstanceBotsResponse.setter(Builder::appInstanceBots)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppInstanceBots").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AppInstanceBotSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListAppInstanceBotsResponse.getter(ListAppInstanceBotsResponse::nextToken)).setter(ListAppInstanceBotsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_INSTANCE_ARN_FIELD, APP_INSTANCE_BOTS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListAppInstanceBotsResponse.memberNameToFieldInitializer();
    private final String appInstanceArn;
    private final List<AppInstanceBotSummary> appInstanceBots;
    private final String nextToken;

    private ListAppInstanceBotsResponse(BuilderImpl builder) {
        super(builder);
        this.appInstanceArn = builder.appInstanceArn;
        this.appInstanceBots = builder.appInstanceBots;
        this.nextToken = builder.nextToken;
    }

    public final String appInstanceArn() {
        return this.appInstanceArn;
    }

    public final boolean hasAppInstanceBots() {
        return this.appInstanceBots != null && !(this.appInstanceBots instanceof SdkAutoConstructList);
    }

    public final List<AppInstanceBotSummary> appInstanceBots() {
        return this.appInstanceBots;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.appInstanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAppInstanceBots() ? this.appInstanceBots() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAppInstanceBotsResponse)) {
            return false;
        }
        ListAppInstanceBotsResponse other = (ListAppInstanceBotsResponse)((Object)obj);
        return Objects.equals(this.appInstanceArn(), other.appInstanceArn()) && this.hasAppInstanceBots() == other.hasAppInstanceBots() && Objects.equals(this.appInstanceBots(), other.appInstanceBots()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListAppInstanceBotsResponse").add("AppInstanceArn", (Object)this.appInstanceArn()).add("AppInstanceBots", this.hasAppInstanceBots() ? this.appInstanceBots() : null).add("NextToken", (Object)(this.nextToken() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AppInstanceArn": {
                return Optional.ofNullable(clazz.cast(this.appInstanceArn()));
            }
            case "AppInstanceBots": {
                return Optional.ofNullable(clazz.cast(this.appInstanceBots()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AppInstanceArn", APP_INSTANCE_ARN_FIELD);
        map.put("AppInstanceBots", APP_INSTANCE_BOTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListAppInstanceBotsResponse, T> g) {
        return obj -> g.apply((ListAppInstanceBotsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ChimeSdkIdentityResponse.BuilderImpl
    implements Builder {
        private String appInstanceArn;
        private List<AppInstanceBotSummary> appInstanceBots = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAppInstanceBotsResponse model) {
            super(model);
            this.appInstanceArn(model.appInstanceArn);
            this.appInstanceBots(model.appInstanceBots);
            this.nextToken(model.nextToken);
        }

        public final String getAppInstanceArn() {
            return this.appInstanceArn;
        }

        public final void setAppInstanceArn(String appInstanceArn) {
            this.appInstanceArn = appInstanceArn;
        }

        @Override
        public final Builder appInstanceArn(String appInstanceArn) {
            this.appInstanceArn = appInstanceArn;
            return this;
        }

        public final List<AppInstanceBotSummary.Builder> getAppInstanceBots() {
            List<AppInstanceBotSummary.Builder> result = AppInstanceBotListCopier.copyToBuilder(this.appInstanceBots);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAppInstanceBots(Collection<AppInstanceBotSummary.BuilderImpl> appInstanceBots) {
            this.appInstanceBots = AppInstanceBotListCopier.copyFromBuilder(appInstanceBots);
        }

        @Override
        public final Builder appInstanceBots(Collection<AppInstanceBotSummary> appInstanceBots) {
            this.appInstanceBots = AppInstanceBotListCopier.copy(appInstanceBots);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder appInstanceBots(AppInstanceBotSummary ... appInstanceBots) {
            this.appInstanceBots(Arrays.asList(appInstanceBots));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder appInstanceBots(Consumer<AppInstanceBotSummary.Builder> ... appInstanceBots) {
            this.appInstanceBots(Stream.of(appInstanceBots).map(c -> (AppInstanceBotSummary)((AppInstanceBotSummary.Builder)AppInstanceBotSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListAppInstanceBotsResponse build() {
            return new ListAppInstanceBotsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ChimeSdkIdentityResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAppInstanceBotsResponse> {
        public Builder appInstanceArn(String var1);

        public Builder appInstanceBots(Collection<AppInstanceBotSummary> var1);

        public Builder appInstanceBots(AppInstanceBotSummary ... var1);

        public Builder appInstanceBots(Consumer<AppInstanceBotSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

