/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkmediapipelines;

import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.BadRequestException;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.ChimeSdkMediaPipelinesException;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.ConflictException;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.CreateMediaCapturePipelineRequest;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.CreateMediaCapturePipelineResponse;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.CreateMediaConcatenationPipelineRequest;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.CreateMediaConcatenationPipelineResponse;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.CreateMediaInsightsPipelineConfigurationRequest;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.CreateMediaInsightsPipelineConfigurationResponse;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.CreateMediaInsightsPipelineRequest;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.CreateMediaInsightsPipelineResponse;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.CreateMediaLiveConnectorPipelineRequest;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.CreateMediaLiveConnectorPipelineResponse;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.CreateMediaPipelineKinesisVideoStreamPoolRequest;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.CreateMediaPipelineKinesisVideoStreamPoolResponse;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.CreateMediaStreamPipelineRequest;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.CreateMediaStreamPipelineResponse;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.DeleteMediaCapturePipelineRequest;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.DeleteMediaCapturePipelineResponse;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.DeleteMediaInsightsPipelineConfigurationRequest;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.DeleteMediaInsightsPipelineConfigurationResponse;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.DeleteMediaPipelineKinesisVideoStreamPoolRequest;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.DeleteMediaPipelineKinesisVideoStreamPoolResponse;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.DeleteMediaPipelineRequest;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.DeleteMediaPipelineResponse;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.ForbiddenException;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.GetMediaCapturePipelineRequest;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.GetMediaCapturePipelineResponse;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.GetMediaInsightsPipelineConfigurationRequest;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.GetMediaInsightsPipelineConfigurationResponse;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.GetMediaPipelineKinesisVideoStreamPoolRequest;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.GetMediaPipelineKinesisVideoStreamPoolResponse;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.GetMediaPipelineRequest;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.GetMediaPipelineResponse;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.GetSpeakerSearchTaskRequest;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.GetSpeakerSearchTaskResponse;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.GetVoiceToneAnalysisTaskRequest;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.GetVoiceToneAnalysisTaskResponse;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.ListMediaCapturePipelinesRequest;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.ListMediaCapturePipelinesResponse;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.ListMediaInsightsPipelineConfigurationsRequest;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.ListMediaInsightsPipelineConfigurationsResponse;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.ListMediaPipelineKinesisVideoStreamPoolsRequest;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.ListMediaPipelineKinesisVideoStreamPoolsResponse;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.ListMediaPipelinesRequest;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.ListMediaPipelinesResponse;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.NotFoundException;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.ResourceLimitExceededException;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.ServiceFailureException;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.ServiceUnavailableException;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.StartSpeakerSearchTaskRequest;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.StartSpeakerSearchTaskResponse;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.StartVoiceToneAnalysisTaskRequest;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.StartVoiceToneAnalysisTaskResponse;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.StopSpeakerSearchTaskRequest;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.StopSpeakerSearchTaskResponse;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.StopVoiceToneAnalysisTaskRequest;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.StopVoiceToneAnalysisTaskResponse;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.TagResourceRequest;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.TagResourceResponse;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.ThrottledClientException;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.UnauthorizedClientException;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.UntagResourceRequest;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.UntagResourceResponse;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.UpdateMediaInsightsPipelineConfigurationRequest;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.UpdateMediaInsightsPipelineConfigurationResponse;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.UpdateMediaInsightsPipelineStatusRequest;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.UpdateMediaInsightsPipelineStatusResponse;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.UpdateMediaPipelineKinesisVideoStreamPoolRequest;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.UpdateMediaPipelineKinesisVideoStreamPoolResponse;
import software.amazon.awssdk.services.chimesdkmediapipelines.transform.CreateMediaCapturePipelineRequestMarshaller;
import software.amazon.awssdk.services.chimesdkmediapipelines.transform.CreateMediaConcatenationPipelineRequestMarshaller;
import software.amazon.awssdk.services.chimesdkmediapipelines.transform.CreateMediaInsightsPipelineConfigurationRequestMarshaller;
import software.amazon.awssdk.services.chimesdkmediapipelines.transform.CreateMediaInsightsPipelineRequestMarshaller;
import software.amazon.awssdk.services.chimesdkmediapipelines.transform.CreateMediaLiveConnectorPipelineRequestMarshaller;
import software.amazon.awssdk.services.chimesdkmediapipelines.transform.CreateMediaPipelineKinesisVideoStreamPoolRequestMarshaller;
import software.amazon.awssdk.services.chimesdkmediapipelines.transform.CreateMediaStreamPipelineRequestMarshaller;
import software.amazon.awssdk.services.chimesdkmediapipelines.transform.DeleteMediaCapturePipelineRequestMarshaller;
import software.amazon.awssdk.services.chimesdkmediapipelines.transform.DeleteMediaInsightsPipelineConfigurationRequestMarshaller;
import software.amazon.awssdk.services.chimesdkmediapipelines.transform.DeleteMediaPipelineKinesisVideoStreamPoolRequestMarshaller;
import software.amazon.awssdk.services.chimesdkmediapipelines.transform.DeleteMediaPipelineRequestMarshaller;
import software.amazon.awssdk.services.chimesdkmediapipelines.transform.GetMediaCapturePipelineRequestMarshaller;
import software.amazon.awssdk.services.chimesdkmediapipelines.transform.GetMediaInsightsPipelineConfigurationRequestMarshaller;
import software.amazon.awssdk.services.chimesdkmediapipelines.transform.GetMediaPipelineKinesisVideoStreamPoolRequestMarshaller;
import software.amazon.awssdk.services.chimesdkmediapipelines.transform.GetMediaPipelineRequestMarshaller;
import software.amazon.awssdk.services.chimesdkmediapipelines.transform.GetSpeakerSearchTaskRequestMarshaller;
import software.amazon.awssdk.services.chimesdkmediapipelines.transform.GetVoiceToneAnalysisTaskRequestMarshaller;
import software.amazon.awssdk.services.chimesdkmediapipelines.transform.ListMediaCapturePipelinesRequestMarshaller;
import software.amazon.awssdk.services.chimesdkmediapipelines.transform.ListMediaInsightsPipelineConfigurationsRequestMarshaller;
import software.amazon.awssdk.services.chimesdkmediapipelines.transform.ListMediaPipelineKinesisVideoStreamPoolsRequestMarshaller;
import software.amazon.awssdk.services.chimesdkmediapipelines.transform.ListMediaPipelinesRequestMarshaller;
import software.amazon.awssdk.services.chimesdkmediapipelines.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.chimesdkmediapipelines.transform.StartSpeakerSearchTaskRequestMarshaller;
import software.amazon.awssdk.services.chimesdkmediapipelines.transform.StartVoiceToneAnalysisTaskRequestMarshaller;
import software.amazon.awssdk.services.chimesdkmediapipelines.transform.StopSpeakerSearchTaskRequestMarshaller;
import software.amazon.awssdk.services.chimesdkmediapipelines.transform.StopVoiceToneAnalysisTaskRequestMarshaller;
import software.amazon.awssdk.services.chimesdkmediapipelines.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.chimesdkmediapipelines.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.chimesdkmediapipelines.transform.UpdateMediaInsightsPipelineConfigurationRequestMarshaller;
import software.amazon.awssdk.services.chimesdkmediapipelines.transform.UpdateMediaInsightsPipelineStatusRequestMarshaller;
import software.amazon.awssdk.services.chimesdkmediapipelines.transform.UpdateMediaPipelineKinesisVideoStreamPoolRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

/**
 * Internal implementation of {@link ChimeSdkMediaPipelinesClient}.
 *
 * @see ChimeSdkMediaPipelinesClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultChimeSdkMediaPipelinesClient implements ChimeSdkMediaPipelinesClient {
    private static final Logger log = Logger.loggerFor(DefaultChimeSdkMediaPipelinesClient.class);

    private final SyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    private final ChimeSdkMediaPipelinesServiceClientConfiguration serviceClientConfiguration;

    protected DefaultChimeSdkMediaPipelinesClient(ChimeSdkMediaPipelinesServiceClientConfiguration serviceClientConfiguration,
            SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.serviceClientConfiguration = serviceClientConfiguration;
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    /**
     * <p>
     * Creates a media pipeline.
     * </p>
     *
     * @param createMediaCapturePipelineRequest
     * @return Result of the CreateMediaCapturePipeline operation returned by the service.
     * @throws BadRequestException
     *         The input parameters don't match the service's restrictions.
     * @throws ForbiddenException
     *         The client is permanently forbidden from making the request.
     * @throws UnauthorizedClientException
     *         The client is not currently authorized to make the request.
     * @throws ThrottledClientException
     *         The client exceeded its request rate limit.
     * @throws ResourceLimitExceededException
     *         The request exceeds the resource limit.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable.
     * @throws ServiceFailureException
     *         The service encountered an unexpected error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChimeSdkMediaPipelinesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChimeSdkMediaPipelinesClient.CreateMediaCapturePipeline
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-media-pipelines-2021-07-15/CreateMediaCapturePipeline"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateMediaCapturePipelineResponse createMediaCapturePipeline(
            CreateMediaCapturePipelineRequest createMediaCapturePipelineRequest) throws BadRequestException, ForbiddenException,
            UnauthorizedClientException, ThrottledClientException, ResourceLimitExceededException, ServiceUnavailableException,
            ServiceFailureException, AwsServiceException, SdkClientException, ChimeSdkMediaPipelinesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateMediaCapturePipelineResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateMediaCapturePipelineResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createMediaCapturePipelineRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Media Pipelines");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateMediaCapturePipeline");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateMediaCapturePipelineRequest, CreateMediaCapturePipelineResponse>()
                            .withOperationName("CreateMediaCapturePipeline").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(createMediaCapturePipelineRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateMediaCapturePipelineRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a media concatenation pipeline.
     * </p>
     *
     * @param createMediaConcatenationPipelineRequest
     * @return Result of the CreateMediaConcatenationPipeline operation returned by the service.
     * @throws BadRequestException
     *         The input parameters don't match the service's restrictions.
     * @throws ForbiddenException
     *         The client is permanently forbidden from making the request.
     * @throws UnauthorizedClientException
     *         The client is not currently authorized to make the request.
     * @throws ThrottledClientException
     *         The client exceeded its request rate limit.
     * @throws ResourceLimitExceededException
     *         The request exceeds the resource limit.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable.
     * @throws ServiceFailureException
     *         The service encountered an unexpected error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChimeSdkMediaPipelinesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChimeSdkMediaPipelinesClient.CreateMediaConcatenationPipeline
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-media-pipelines-2021-07-15/CreateMediaConcatenationPipeline"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateMediaConcatenationPipelineResponse createMediaConcatenationPipeline(
            CreateMediaConcatenationPipelineRequest createMediaConcatenationPipelineRequest) throws BadRequestException,
            ForbiddenException, UnauthorizedClientException, ThrottledClientException, ResourceLimitExceededException,
            ServiceUnavailableException, ServiceFailureException, AwsServiceException, SdkClientException,
            ChimeSdkMediaPipelinesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateMediaConcatenationPipelineResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateMediaConcatenationPipelineResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createMediaConcatenationPipelineRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Media Pipelines");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateMediaConcatenationPipeline");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateMediaConcatenationPipelineRequest, CreateMediaConcatenationPipelineResponse>()
                            .withOperationName("CreateMediaConcatenationPipeline").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(createMediaConcatenationPipelineRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateMediaConcatenationPipelineRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a media insights pipeline.
     * </p>
     *
     * @param createMediaInsightsPipelineRequest
     * @return Result of the CreateMediaInsightsPipeline operation returned by the service.
     * @throws BadRequestException
     *         The input parameters don't match the service's restrictions.
     * @throws ForbiddenException
     *         The client is permanently forbidden from making the request.
     * @throws UnauthorizedClientException
     *         The client is not currently authorized to make the request.
     * @throws ThrottledClientException
     *         The client exceeded its request rate limit.
     * @throws ResourceLimitExceededException
     *         The request exceeds the resource limit.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable.
     * @throws ServiceFailureException
     *         The service encountered an unexpected error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChimeSdkMediaPipelinesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChimeSdkMediaPipelinesClient.CreateMediaInsightsPipeline
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-media-pipelines-2021-07-15/CreateMediaInsightsPipeline"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateMediaInsightsPipelineResponse createMediaInsightsPipeline(
            CreateMediaInsightsPipelineRequest createMediaInsightsPipelineRequest) throws BadRequestException,
            ForbiddenException, UnauthorizedClientException, ThrottledClientException, ResourceLimitExceededException,
            NotFoundException, ServiceUnavailableException, ServiceFailureException, AwsServiceException, SdkClientException,
            ChimeSdkMediaPipelinesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateMediaInsightsPipelineResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateMediaInsightsPipelineResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createMediaInsightsPipelineRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Media Pipelines");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateMediaInsightsPipeline");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateMediaInsightsPipelineRequest, CreateMediaInsightsPipelineResponse>()
                            .withOperationName("CreateMediaInsightsPipeline").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(createMediaInsightsPipelineRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateMediaInsightsPipelineRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * A structure that contains the static configurations for a media insights pipeline.
     * </p>
     *
     * @param createMediaInsightsPipelineConfigurationRequest
     * @return Result of the CreateMediaInsightsPipelineConfiguration operation returned by the service.
     * @throws BadRequestException
     *         The input parameters don't match the service's restrictions.
     * @throws ForbiddenException
     *         The client is permanently forbidden from making the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws UnauthorizedClientException
     *         The client is not currently authorized to make the request.
     * @throws ThrottledClientException
     *         The client exceeded its request rate limit.
     * @throws ResourceLimitExceededException
     *         The request exceeds the resource limit.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable.
     * @throws ServiceFailureException
     *         The service encountered an unexpected error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChimeSdkMediaPipelinesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChimeSdkMediaPipelinesClient.CreateMediaInsightsPipelineConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-media-pipelines-2021-07-15/CreateMediaInsightsPipelineConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateMediaInsightsPipelineConfigurationResponse createMediaInsightsPipelineConfiguration(
            CreateMediaInsightsPipelineConfigurationRequest createMediaInsightsPipelineConfigurationRequest)
            throws BadRequestException, ForbiddenException, NotFoundException, UnauthorizedClientException,
            ThrottledClientException, ResourceLimitExceededException, ServiceUnavailableException, ServiceFailureException,
            AwsServiceException, SdkClientException, ChimeSdkMediaPipelinesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateMediaInsightsPipelineConfigurationResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, CreateMediaInsightsPipelineConfigurationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createMediaInsightsPipelineConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Media Pipelines");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateMediaInsightsPipelineConfiguration");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateMediaInsightsPipelineConfigurationRequest, CreateMediaInsightsPipelineConfigurationResponse>()
                            .withOperationName("CreateMediaInsightsPipelineConfiguration").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler)
                            .withInput(createMediaInsightsPipelineConfigurationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateMediaInsightsPipelineConfigurationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a media live connector pipeline in an Amazon Chime SDK meeting.
     * </p>
     *
     * @param createMediaLiveConnectorPipelineRequest
     * @return Result of the CreateMediaLiveConnectorPipeline operation returned by the service.
     * @throws BadRequestException
     *         The input parameters don't match the service's restrictions.
     * @throws ForbiddenException
     *         The client is permanently forbidden from making the request.
     * @throws UnauthorizedClientException
     *         The client is not currently authorized to make the request.
     * @throws ThrottledClientException
     *         The client exceeded its request rate limit.
     * @throws ResourceLimitExceededException
     *         The request exceeds the resource limit.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable.
     * @throws ServiceFailureException
     *         The service encountered an unexpected error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChimeSdkMediaPipelinesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChimeSdkMediaPipelinesClient.CreateMediaLiveConnectorPipeline
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-media-pipelines-2021-07-15/CreateMediaLiveConnectorPipeline"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateMediaLiveConnectorPipelineResponse createMediaLiveConnectorPipeline(
            CreateMediaLiveConnectorPipelineRequest createMediaLiveConnectorPipelineRequest) throws BadRequestException,
            ForbiddenException, UnauthorizedClientException, ThrottledClientException, ResourceLimitExceededException,
            ServiceUnavailableException, ServiceFailureException, AwsServiceException, SdkClientException,
            ChimeSdkMediaPipelinesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateMediaLiveConnectorPipelineResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateMediaLiveConnectorPipelineResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createMediaLiveConnectorPipelineRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Media Pipelines");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateMediaLiveConnectorPipeline");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateMediaLiveConnectorPipelineRequest, CreateMediaLiveConnectorPipelineResponse>()
                            .withOperationName("CreateMediaLiveConnectorPipeline").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(createMediaLiveConnectorPipelineRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateMediaLiveConnectorPipelineRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates an Kinesis video stream pool for the media pipeline.
     * </p>
     *
     * @param createMediaPipelineKinesisVideoStreamPoolRequest
     * @return Result of the CreateMediaPipelineKinesisVideoStreamPool operation returned by the service.
     * @throws BadRequestException
     *         The input parameters don't match the service's restrictions.
     * @throws ForbiddenException
     *         The client is permanently forbidden from making the request.
     * @throws UnauthorizedClientException
     *         The client is not currently authorized to make the request.
     * @throws ThrottledClientException
     *         The client exceeded its request rate limit.
     * @throws ResourceLimitExceededException
     *         The request exceeds the resource limit.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable.
     * @throws ServiceFailureException
     *         The service encountered an unexpected error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChimeSdkMediaPipelinesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChimeSdkMediaPipelinesClient.CreateMediaPipelineKinesisVideoStreamPool
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-media-pipelines-2021-07-15/CreateMediaPipelineKinesisVideoStreamPool"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateMediaPipelineKinesisVideoStreamPoolResponse createMediaPipelineKinesisVideoStreamPool(
            CreateMediaPipelineKinesisVideoStreamPoolRequest createMediaPipelineKinesisVideoStreamPoolRequest)
            throws BadRequestException, ForbiddenException, UnauthorizedClientException, ThrottledClientException,
            ResourceLimitExceededException, ConflictException, ServiceUnavailableException, ServiceFailureException,
            AwsServiceException, SdkClientException, ChimeSdkMediaPipelinesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateMediaPipelineKinesisVideoStreamPoolResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, CreateMediaPipelineKinesisVideoStreamPoolResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createMediaPipelineKinesisVideoStreamPoolRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Media Pipelines");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateMediaPipelineKinesisVideoStreamPool");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateMediaPipelineKinesisVideoStreamPoolRequest, CreateMediaPipelineKinesisVideoStreamPoolResponse>()
                            .withOperationName("CreateMediaPipelineKinesisVideoStreamPool").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler)
                            .withInput(createMediaPipelineKinesisVideoStreamPoolRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateMediaPipelineKinesisVideoStreamPoolRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a streaming media pipeline.
     * </p>
     *
     * @param createMediaStreamPipelineRequest
     * @return Result of the CreateMediaStreamPipeline operation returned by the service.
     * @throws BadRequestException
     *         The input parameters don't match the service's restrictions.
     * @throws ForbiddenException
     *         The client is permanently forbidden from making the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws UnauthorizedClientException
     *         The client is not currently authorized to make the request.
     * @throws ThrottledClientException
     *         The client exceeded its request rate limit.
     * @throws ResourceLimitExceededException
     *         The request exceeds the resource limit.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable.
     * @throws ServiceFailureException
     *         The service encountered an unexpected error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChimeSdkMediaPipelinesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChimeSdkMediaPipelinesClient.CreateMediaStreamPipeline
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-media-pipelines-2021-07-15/CreateMediaStreamPipeline"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateMediaStreamPipelineResponse createMediaStreamPipeline(
            CreateMediaStreamPipelineRequest createMediaStreamPipelineRequest) throws BadRequestException, ForbiddenException,
            NotFoundException, UnauthorizedClientException, ThrottledClientException, ResourceLimitExceededException,
            ServiceUnavailableException, ServiceFailureException, AwsServiceException, SdkClientException,
            ChimeSdkMediaPipelinesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateMediaStreamPipelineResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateMediaStreamPipelineResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createMediaStreamPipelineRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Media Pipelines");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateMediaStreamPipeline");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateMediaStreamPipelineRequest, CreateMediaStreamPipelineResponse>()
                            .withOperationName("CreateMediaStreamPipeline").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(createMediaStreamPipelineRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateMediaStreamPipelineRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the media pipeline.
     * </p>
     *
     * @param deleteMediaCapturePipelineRequest
     * @return Result of the DeleteMediaCapturePipeline operation returned by the service.
     * @throws BadRequestException
     *         The input parameters don't match the service's restrictions.
     * @throws ForbiddenException
     *         The client is permanently forbidden from making the request.
     * @throws ThrottledClientException
     *         The client exceeded its request rate limit.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws UnauthorizedClientException
     *         The client is not currently authorized to make the request.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable.
     * @throws ServiceFailureException
     *         The service encountered an unexpected error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChimeSdkMediaPipelinesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChimeSdkMediaPipelinesClient.DeleteMediaCapturePipeline
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-media-pipelines-2021-07-15/DeleteMediaCapturePipeline"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteMediaCapturePipelineResponse deleteMediaCapturePipeline(
            DeleteMediaCapturePipelineRequest deleteMediaCapturePipelineRequest) throws BadRequestException, ForbiddenException,
            ThrottledClientException, NotFoundException, UnauthorizedClientException, ServiceUnavailableException,
            ServiceFailureException, AwsServiceException, SdkClientException, ChimeSdkMediaPipelinesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteMediaCapturePipelineResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteMediaCapturePipelineResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteMediaCapturePipelineRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Media Pipelines");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteMediaCapturePipeline");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteMediaCapturePipelineRequest, DeleteMediaCapturePipelineResponse>()
                            .withOperationName("DeleteMediaCapturePipeline").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(deleteMediaCapturePipelineRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteMediaCapturePipelineRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified configuration settings.
     * </p>
     *
     * @param deleteMediaInsightsPipelineConfigurationRequest
     * @return Result of the DeleteMediaInsightsPipelineConfiguration operation returned by the service.
     * @throws BadRequestException
     *         The input parameters don't match the service's restrictions.
     * @throws ForbiddenException
     *         The client is permanently forbidden from making the request.
     * @throws ThrottledClientException
     *         The client exceeded its request rate limit.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws UnauthorizedClientException
     *         The client is not currently authorized to make the request.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable.
     * @throws ServiceFailureException
     *         The service encountered an unexpected error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChimeSdkMediaPipelinesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChimeSdkMediaPipelinesClient.DeleteMediaInsightsPipelineConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-media-pipelines-2021-07-15/DeleteMediaInsightsPipelineConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteMediaInsightsPipelineConfigurationResponse deleteMediaInsightsPipelineConfiguration(
            DeleteMediaInsightsPipelineConfigurationRequest deleteMediaInsightsPipelineConfigurationRequest)
            throws BadRequestException, ForbiddenException, ThrottledClientException, NotFoundException,
            UnauthorizedClientException, ConflictException, ServiceUnavailableException, ServiceFailureException,
            AwsServiceException, SdkClientException, ChimeSdkMediaPipelinesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteMediaInsightsPipelineConfigurationResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, DeleteMediaInsightsPipelineConfigurationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteMediaInsightsPipelineConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Media Pipelines");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteMediaInsightsPipelineConfiguration");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteMediaInsightsPipelineConfigurationRequest, DeleteMediaInsightsPipelineConfigurationResponse>()
                            .withOperationName("DeleteMediaInsightsPipelineConfiguration").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler)
                            .withInput(deleteMediaInsightsPipelineConfigurationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteMediaInsightsPipelineConfigurationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the media pipeline.
     * </p>
     *
     * @param deleteMediaPipelineRequest
     * @return Result of the DeleteMediaPipeline operation returned by the service.
     * @throws BadRequestException
     *         The input parameters don't match the service's restrictions.
     * @throws ForbiddenException
     *         The client is permanently forbidden from making the request.
     * @throws ThrottledClientException
     *         The client exceeded its request rate limit.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws UnauthorizedClientException
     *         The client is not currently authorized to make the request.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable.
     * @throws ServiceFailureException
     *         The service encountered an unexpected error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChimeSdkMediaPipelinesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChimeSdkMediaPipelinesClient.DeleteMediaPipeline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-media-pipelines-2021-07-15/DeleteMediaPipeline"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteMediaPipelineResponse deleteMediaPipeline(DeleteMediaPipelineRequest deleteMediaPipelineRequest)
            throws BadRequestException, ForbiddenException, ThrottledClientException, NotFoundException,
            UnauthorizedClientException, ConflictException, ServiceUnavailableException, ServiceFailureException,
            AwsServiceException, SdkClientException, ChimeSdkMediaPipelinesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteMediaPipelineResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteMediaPipelineResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteMediaPipelineRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Media Pipelines");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteMediaPipeline");

            return clientHandler.execute(new ClientExecutionParams<DeleteMediaPipelineRequest, DeleteMediaPipelineResponse>()
                    .withOperationName("DeleteMediaPipeline").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteMediaPipelineRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteMediaPipelineRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes an Kinesis video stream pool.
     * </p>
     *
     * @param deleteMediaPipelineKinesisVideoStreamPoolRequest
     * @return Result of the DeleteMediaPipelineKinesisVideoStreamPool operation returned by the service.
     * @throws BadRequestException
     *         The input parameters don't match the service's restrictions.
     * @throws ForbiddenException
     *         The client is permanently forbidden from making the request.
     * @throws ThrottledClientException
     *         The client exceeded its request rate limit.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws UnauthorizedClientException
     *         The client is not currently authorized to make the request.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable.
     * @throws ServiceFailureException
     *         The service encountered an unexpected error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChimeSdkMediaPipelinesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChimeSdkMediaPipelinesClient.DeleteMediaPipelineKinesisVideoStreamPool
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-media-pipelines-2021-07-15/DeleteMediaPipelineKinesisVideoStreamPool"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteMediaPipelineKinesisVideoStreamPoolResponse deleteMediaPipelineKinesisVideoStreamPool(
            DeleteMediaPipelineKinesisVideoStreamPoolRequest deleteMediaPipelineKinesisVideoStreamPoolRequest)
            throws BadRequestException, ForbiddenException, ThrottledClientException, NotFoundException,
            UnauthorizedClientException, ConflictException, ServiceUnavailableException, ServiceFailureException,
            AwsServiceException, SdkClientException, ChimeSdkMediaPipelinesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteMediaPipelineKinesisVideoStreamPoolResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, DeleteMediaPipelineKinesisVideoStreamPoolResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteMediaPipelineKinesisVideoStreamPoolRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Media Pipelines");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteMediaPipelineKinesisVideoStreamPool");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteMediaPipelineKinesisVideoStreamPoolRequest, DeleteMediaPipelineKinesisVideoStreamPoolResponse>()
                            .withOperationName("DeleteMediaPipelineKinesisVideoStreamPool").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler)
                            .withInput(deleteMediaPipelineKinesisVideoStreamPoolRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteMediaPipelineKinesisVideoStreamPoolRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets an existing media pipeline.
     * </p>
     *
     * @param getMediaCapturePipelineRequest
     * @return Result of the GetMediaCapturePipeline operation returned by the service.
     * @throws BadRequestException
     *         The input parameters don't match the service's restrictions.
     * @throws ForbiddenException
     *         The client is permanently forbidden from making the request.
     * @throws UnauthorizedClientException
     *         The client is not currently authorized to make the request.
     * @throws ThrottledClientException
     *         The client exceeded its request rate limit.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable.
     * @throws ServiceFailureException
     *         The service encountered an unexpected error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChimeSdkMediaPipelinesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChimeSdkMediaPipelinesClient.GetMediaCapturePipeline
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-media-pipelines-2021-07-15/GetMediaCapturePipeline"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetMediaCapturePipelineResponse getMediaCapturePipeline(GetMediaCapturePipelineRequest getMediaCapturePipelineRequest)
            throws BadRequestException, ForbiddenException, UnauthorizedClientException, ThrottledClientException,
            NotFoundException, ServiceUnavailableException, ServiceFailureException, AwsServiceException, SdkClientException,
            ChimeSdkMediaPipelinesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetMediaCapturePipelineResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetMediaCapturePipelineResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getMediaCapturePipelineRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Media Pipelines");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetMediaCapturePipeline");

            return clientHandler
                    .execute(new ClientExecutionParams<GetMediaCapturePipelineRequest, GetMediaCapturePipelineResponse>()
                            .withOperationName("GetMediaCapturePipeline").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(getMediaCapturePipelineRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetMediaCapturePipelineRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets the configuration settings for a media insights pipeline.
     * </p>
     *
     * @param getMediaInsightsPipelineConfigurationRequest
     * @return Result of the GetMediaInsightsPipelineConfiguration operation returned by the service.
     * @throws BadRequestException
     *         The input parameters don't match the service's restrictions.
     * @throws ForbiddenException
     *         The client is permanently forbidden from making the request.
     * @throws UnauthorizedClientException
     *         The client is not currently authorized to make the request.
     * @throws ThrottledClientException
     *         The client exceeded its request rate limit.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable.
     * @throws ServiceFailureException
     *         The service encountered an unexpected error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChimeSdkMediaPipelinesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChimeSdkMediaPipelinesClient.GetMediaInsightsPipelineConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-media-pipelines-2021-07-15/GetMediaInsightsPipelineConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetMediaInsightsPipelineConfigurationResponse getMediaInsightsPipelineConfiguration(
            GetMediaInsightsPipelineConfigurationRequest getMediaInsightsPipelineConfigurationRequest)
            throws BadRequestException, ForbiddenException, UnauthorizedClientException, ThrottledClientException,
            NotFoundException, ServiceUnavailableException, ServiceFailureException, AwsServiceException, SdkClientException,
            ChimeSdkMediaPipelinesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetMediaInsightsPipelineConfigurationResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, GetMediaInsightsPipelineConfigurationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getMediaInsightsPipelineConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Media Pipelines");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetMediaInsightsPipelineConfiguration");

            return clientHandler
                    .execute(new ClientExecutionParams<GetMediaInsightsPipelineConfigurationRequest, GetMediaInsightsPipelineConfigurationResponse>()
                            .withOperationName("GetMediaInsightsPipelineConfiguration").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler)
                            .withInput(getMediaInsightsPipelineConfigurationRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetMediaInsightsPipelineConfigurationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets an existing media pipeline.
     * </p>
     *
     * @param getMediaPipelineRequest
     * @return Result of the GetMediaPipeline operation returned by the service.
     * @throws BadRequestException
     *         The input parameters don't match the service's restrictions.
     * @throws ForbiddenException
     *         The client is permanently forbidden from making the request.
     * @throws UnauthorizedClientException
     *         The client is not currently authorized to make the request.
     * @throws ThrottledClientException
     *         The client exceeded its request rate limit.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable.
     * @throws ServiceFailureException
     *         The service encountered an unexpected error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChimeSdkMediaPipelinesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChimeSdkMediaPipelinesClient.GetMediaPipeline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-media-pipelines-2021-07-15/GetMediaPipeline"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetMediaPipelineResponse getMediaPipeline(GetMediaPipelineRequest getMediaPipelineRequest) throws BadRequestException,
            ForbiddenException, UnauthorizedClientException, ThrottledClientException, NotFoundException,
            ServiceUnavailableException, ServiceFailureException, AwsServiceException, SdkClientException,
            ChimeSdkMediaPipelinesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetMediaPipelineResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetMediaPipelineResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getMediaPipelineRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Media Pipelines");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetMediaPipeline");

            return clientHandler.execute(new ClientExecutionParams<GetMediaPipelineRequest, GetMediaPipelineResponse>()
                    .withOperationName("GetMediaPipeline").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getMediaPipelineRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetMediaPipelineRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets an Kinesis video stream pool.
     * </p>
     *
     * @param getMediaPipelineKinesisVideoStreamPoolRequest
     * @return Result of the GetMediaPipelineKinesisVideoStreamPool operation returned by the service.
     * @throws BadRequestException
     *         The input parameters don't match the service's restrictions.
     * @throws ForbiddenException
     *         The client is permanently forbidden from making the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws UnauthorizedClientException
     *         The client is not currently authorized to make the request.
     * @throws ThrottledClientException
     *         The client exceeded its request rate limit.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable.
     * @throws ServiceFailureException
     *         The service encountered an unexpected error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChimeSdkMediaPipelinesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChimeSdkMediaPipelinesClient.GetMediaPipelineKinesisVideoStreamPool
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-media-pipelines-2021-07-15/GetMediaPipelineKinesisVideoStreamPool"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetMediaPipelineKinesisVideoStreamPoolResponse getMediaPipelineKinesisVideoStreamPool(
            GetMediaPipelineKinesisVideoStreamPoolRequest getMediaPipelineKinesisVideoStreamPoolRequest)
            throws BadRequestException, ForbiddenException, NotFoundException, UnauthorizedClientException,
            ThrottledClientException, ServiceUnavailableException, ServiceFailureException, AwsServiceException,
            SdkClientException, ChimeSdkMediaPipelinesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetMediaPipelineKinesisVideoStreamPoolResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, GetMediaPipelineKinesisVideoStreamPoolResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getMediaPipelineKinesisVideoStreamPoolRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Media Pipelines");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetMediaPipelineKinesisVideoStreamPool");

            return clientHandler
                    .execute(new ClientExecutionParams<GetMediaPipelineKinesisVideoStreamPoolRequest, GetMediaPipelineKinesisVideoStreamPoolResponse>()
                            .withOperationName("GetMediaPipelineKinesisVideoStreamPool").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler)
                            .withInput(getMediaPipelineKinesisVideoStreamPoolRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetMediaPipelineKinesisVideoStreamPoolRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves the details of the specified speaker search task.
     * </p>
     *
     * @param getSpeakerSearchTaskRequest
     * @return Result of the GetSpeakerSearchTask operation returned by the service.
     * @throws BadRequestException
     *         The input parameters don't match the service's restrictions.
     * @throws ForbiddenException
     *         The client is permanently forbidden from making the request.
     * @throws UnauthorizedClientException
     *         The client is not currently authorized to make the request.
     * @throws ThrottledClientException
     *         The client exceeded its request rate limit.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable.
     * @throws ServiceFailureException
     *         The service encountered an unexpected error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChimeSdkMediaPipelinesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChimeSdkMediaPipelinesClient.GetSpeakerSearchTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-media-pipelines-2021-07-15/GetSpeakerSearchTask"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetSpeakerSearchTaskResponse getSpeakerSearchTask(GetSpeakerSearchTaskRequest getSpeakerSearchTaskRequest)
            throws BadRequestException, ForbiddenException, UnauthorizedClientException, ThrottledClientException,
            NotFoundException, ServiceUnavailableException, ServiceFailureException, AwsServiceException, SdkClientException,
            ChimeSdkMediaPipelinesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetSpeakerSearchTaskResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetSpeakerSearchTaskResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getSpeakerSearchTaskRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Media Pipelines");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetSpeakerSearchTask");

            return clientHandler.execute(new ClientExecutionParams<GetSpeakerSearchTaskRequest, GetSpeakerSearchTaskResponse>()
                    .withOperationName("GetSpeakerSearchTask").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getSpeakerSearchTaskRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetSpeakerSearchTaskRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves the details of a voice tone analysis task.
     * </p>
     *
     * @param getVoiceToneAnalysisTaskRequest
     * @return Result of the GetVoiceToneAnalysisTask operation returned by the service.
     * @throws BadRequestException
     *         The input parameters don't match the service's restrictions.
     * @throws ForbiddenException
     *         The client is permanently forbidden from making the request.
     * @throws UnauthorizedClientException
     *         The client is not currently authorized to make the request.
     * @throws ThrottledClientException
     *         The client exceeded its request rate limit.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable.
     * @throws ServiceFailureException
     *         The service encountered an unexpected error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChimeSdkMediaPipelinesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChimeSdkMediaPipelinesClient.GetVoiceToneAnalysisTask
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-media-pipelines-2021-07-15/GetVoiceToneAnalysisTask"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetVoiceToneAnalysisTaskResponse getVoiceToneAnalysisTask(
            GetVoiceToneAnalysisTaskRequest getVoiceToneAnalysisTaskRequest) throws BadRequestException, ForbiddenException,
            UnauthorizedClientException, ThrottledClientException, NotFoundException, ServiceUnavailableException,
            ServiceFailureException, AwsServiceException, SdkClientException, ChimeSdkMediaPipelinesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetVoiceToneAnalysisTaskResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetVoiceToneAnalysisTaskResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getVoiceToneAnalysisTaskRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Media Pipelines");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetVoiceToneAnalysisTask");

            return clientHandler
                    .execute(new ClientExecutionParams<GetVoiceToneAnalysisTaskRequest, GetVoiceToneAnalysisTaskResponse>()
                            .withOperationName("GetVoiceToneAnalysisTask").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(getVoiceToneAnalysisTaskRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetVoiceToneAnalysisTaskRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a list of media pipelines.
     * </p>
     *
     * @param listMediaCapturePipelinesRequest
     * @return Result of the ListMediaCapturePipelines operation returned by the service.
     * @throws BadRequestException
     *         The input parameters don't match the service's restrictions.
     * @throws ForbiddenException
     *         The client is permanently forbidden from making the request.
     * @throws UnauthorizedClientException
     *         The client is not currently authorized to make the request.
     * @throws ThrottledClientException
     *         The client exceeded its request rate limit.
     * @throws ResourceLimitExceededException
     *         The request exceeds the resource limit.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable.
     * @throws ServiceFailureException
     *         The service encountered an unexpected error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChimeSdkMediaPipelinesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChimeSdkMediaPipelinesClient.ListMediaCapturePipelines
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-media-pipelines-2021-07-15/ListMediaCapturePipelines"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListMediaCapturePipelinesResponse listMediaCapturePipelines(
            ListMediaCapturePipelinesRequest listMediaCapturePipelinesRequest) throws BadRequestException, ForbiddenException,
            UnauthorizedClientException, ThrottledClientException, ResourceLimitExceededException, ServiceUnavailableException,
            ServiceFailureException, AwsServiceException, SdkClientException, ChimeSdkMediaPipelinesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListMediaCapturePipelinesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListMediaCapturePipelinesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listMediaCapturePipelinesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Media Pipelines");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListMediaCapturePipelines");

            return clientHandler
                    .execute(new ClientExecutionParams<ListMediaCapturePipelinesRequest, ListMediaCapturePipelinesResponse>()
                            .withOperationName("ListMediaCapturePipelines").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(listMediaCapturePipelinesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListMediaCapturePipelinesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the available media insights pipeline configurations.
     * </p>
     *
     * @param listMediaInsightsPipelineConfigurationsRequest
     * @return Result of the ListMediaInsightsPipelineConfigurations operation returned by the service.
     * @throws BadRequestException
     *         The input parameters don't match the service's restrictions.
     * @throws ForbiddenException
     *         The client is permanently forbidden from making the request.
     * @throws UnauthorizedClientException
     *         The client is not currently authorized to make the request.
     * @throws ThrottledClientException
     *         The client exceeded its request rate limit.
     * @throws ResourceLimitExceededException
     *         The request exceeds the resource limit.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable.
     * @throws ServiceFailureException
     *         The service encountered an unexpected error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChimeSdkMediaPipelinesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChimeSdkMediaPipelinesClient.ListMediaInsightsPipelineConfigurations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-media-pipelines-2021-07-15/ListMediaInsightsPipelineConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListMediaInsightsPipelineConfigurationsResponse listMediaInsightsPipelineConfigurations(
            ListMediaInsightsPipelineConfigurationsRequest listMediaInsightsPipelineConfigurationsRequest)
            throws BadRequestException, ForbiddenException, UnauthorizedClientException, ThrottledClientException,
            ResourceLimitExceededException, ServiceUnavailableException, ServiceFailureException, AwsServiceException,
            SdkClientException, ChimeSdkMediaPipelinesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListMediaInsightsPipelineConfigurationsResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, ListMediaInsightsPipelineConfigurationsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listMediaInsightsPipelineConfigurationsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Media Pipelines");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListMediaInsightsPipelineConfigurations");

            return clientHandler
                    .execute(new ClientExecutionParams<ListMediaInsightsPipelineConfigurationsRequest, ListMediaInsightsPipelineConfigurationsResponse>()
                            .withOperationName("ListMediaInsightsPipelineConfigurations").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler)
                            .withInput(listMediaInsightsPipelineConfigurationsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListMediaInsightsPipelineConfigurationsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the video stream pools in the media pipeline.
     * </p>
     *
     * @param listMediaPipelineKinesisVideoStreamPoolsRequest
     * @return Result of the ListMediaPipelineKinesisVideoStreamPools operation returned by the service.
     * @throws BadRequestException
     *         The input parameters don't match the service's restrictions.
     * @throws ForbiddenException
     *         The client is permanently forbidden from making the request.
     * @throws UnauthorizedClientException
     *         The client is not currently authorized to make the request.
     * @throws ThrottledClientException
     *         The client exceeded its request rate limit.
     * @throws ResourceLimitExceededException
     *         The request exceeds the resource limit.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable.
     * @throws ServiceFailureException
     *         The service encountered an unexpected error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChimeSdkMediaPipelinesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChimeSdkMediaPipelinesClient.ListMediaPipelineKinesisVideoStreamPools
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-media-pipelines-2021-07-15/ListMediaPipelineKinesisVideoStreamPools"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListMediaPipelineKinesisVideoStreamPoolsResponse listMediaPipelineKinesisVideoStreamPools(
            ListMediaPipelineKinesisVideoStreamPoolsRequest listMediaPipelineKinesisVideoStreamPoolsRequest)
            throws BadRequestException, ForbiddenException, UnauthorizedClientException, ThrottledClientException,
            ResourceLimitExceededException, ServiceUnavailableException, ServiceFailureException, AwsServiceException,
            SdkClientException, ChimeSdkMediaPipelinesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListMediaPipelineKinesisVideoStreamPoolsResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, ListMediaPipelineKinesisVideoStreamPoolsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listMediaPipelineKinesisVideoStreamPoolsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Media Pipelines");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListMediaPipelineKinesisVideoStreamPools");

            return clientHandler
                    .execute(new ClientExecutionParams<ListMediaPipelineKinesisVideoStreamPoolsRequest, ListMediaPipelineKinesisVideoStreamPoolsResponse>()
                            .withOperationName("ListMediaPipelineKinesisVideoStreamPools").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler)
                            .withInput(listMediaPipelineKinesisVideoStreamPoolsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListMediaPipelineKinesisVideoStreamPoolsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a list of media pipelines.
     * </p>
     *
     * @param listMediaPipelinesRequest
     * @return Result of the ListMediaPipelines operation returned by the service.
     * @throws BadRequestException
     *         The input parameters don't match the service's restrictions.
     * @throws ForbiddenException
     *         The client is permanently forbidden from making the request.
     * @throws UnauthorizedClientException
     *         The client is not currently authorized to make the request.
     * @throws ThrottledClientException
     *         The client exceeded its request rate limit.
     * @throws ResourceLimitExceededException
     *         The request exceeds the resource limit.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable.
     * @throws ServiceFailureException
     *         The service encountered an unexpected error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChimeSdkMediaPipelinesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChimeSdkMediaPipelinesClient.ListMediaPipelines
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-media-pipelines-2021-07-15/ListMediaPipelines"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListMediaPipelinesResponse listMediaPipelines(ListMediaPipelinesRequest listMediaPipelinesRequest)
            throws BadRequestException, ForbiddenException, UnauthorizedClientException, ThrottledClientException,
            ResourceLimitExceededException, ServiceUnavailableException, ServiceFailureException, AwsServiceException,
            SdkClientException, ChimeSdkMediaPipelinesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListMediaPipelinesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListMediaPipelinesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listMediaPipelinesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Media Pipelines");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListMediaPipelines");

            return clientHandler.execute(new ClientExecutionParams<ListMediaPipelinesRequest, ListMediaPipelinesResponse>()
                    .withOperationName("ListMediaPipelines").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listMediaPipelinesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListMediaPipelinesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the tags available for a media pipeline.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws BadRequestException
     *         The input parameters don't match the service's restrictions.
     * @throws ForbiddenException
     *         The client is permanently forbidden from making the request.
     * @throws UnauthorizedClientException
     *         The client is not currently authorized to make the request.
     * @throws ThrottledClientException
     *         The client exceeded its request rate limit.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable.
     * @throws ServiceFailureException
     *         The service encountered an unexpected error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChimeSdkMediaPipelinesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChimeSdkMediaPipelinesClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-media-pipelines-2021-07-15/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws NotFoundException, BadRequestException, ForbiddenException, UnauthorizedClientException,
            ThrottledClientException, ServiceUnavailableException, ServiceFailureException, AwsServiceException,
            SdkClientException, ChimeSdkMediaPipelinesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListTagsForResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListTagsForResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Media Pipelines");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTagsForResource");

            return clientHandler.execute(new ClientExecutionParams<ListTagsForResourceRequest, ListTagsForResourceResponse>()
                    .withOperationName("ListTagsForResource").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listTagsForResourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListTagsForResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Starts a speaker search task.
     * </p>
     * <important>
     * <p>
     * Before starting any speaker search tasks, you must provide all notices and obtain all consents from the speaker
     * as required under applicable privacy and biometrics laws, and as required under the <a
     * href="https://aws.amazon.com/service-terms/">AWS service terms</a> for the Amazon Chime SDK.
     * </p>
     * </important>
     *
     * @param startSpeakerSearchTaskRequest
     * @return Result of the StartSpeakerSearchTask operation returned by the service.
     * @throws BadRequestException
     *         The input parameters don't match the service's restrictions.
     * @throws ForbiddenException
     *         The client is permanently forbidden from making the request.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource.
     * @throws UnauthorizedClientException
     *         The client is not currently authorized to make the request.
     * @throws ThrottledClientException
     *         The client exceeded its request rate limit.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable.
     * @throws ServiceFailureException
     *         The service encountered an unexpected error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChimeSdkMediaPipelinesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChimeSdkMediaPipelinesClient.StartSpeakerSearchTask
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-media-pipelines-2021-07-15/StartSpeakerSearchTask"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public StartSpeakerSearchTaskResponse startSpeakerSearchTask(StartSpeakerSearchTaskRequest startSpeakerSearchTaskRequest)
            throws BadRequestException, ForbiddenException, ConflictException, UnauthorizedClientException,
            ThrottledClientException, NotFoundException, ServiceUnavailableException, ServiceFailureException,
            AwsServiceException, SdkClientException, ChimeSdkMediaPipelinesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<StartSpeakerSearchTaskResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, StartSpeakerSearchTaskResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startSpeakerSearchTaskRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Media Pipelines");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartSpeakerSearchTask");

            return clientHandler
                    .execute(new ClientExecutionParams<StartSpeakerSearchTaskRequest, StartSpeakerSearchTaskResponse>()
                            .withOperationName("StartSpeakerSearchTask").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(startSpeakerSearchTaskRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new StartSpeakerSearchTaskRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Starts a voice tone analysis task. For more information about voice tone analysis, see <a
     * href="https://docs.aws.amazon.com/chime-sdk/latest/dg/voice-analytics.html">Using Amazon Chime SDK voice
     * analytics</a> in the <i>Amazon Chime SDK Developer Guide</i>.
     * </p>
     * <important>
     * <p>
     * Before starting any voice tone analysis tasks, you must provide all notices and obtain all consents from the
     * speaker as required under applicable privacy and biometrics laws, and as required under the <a
     * href="https://aws.amazon.com/service-terms/">AWS service terms</a> for the Amazon Chime SDK.
     * </p>
     * </important>
     *
     * @param startVoiceToneAnalysisTaskRequest
     * @return Result of the StartVoiceToneAnalysisTask operation returned by the service.
     * @throws BadRequestException
     *         The input parameters don't match the service's restrictions.
     * @throws ForbiddenException
     *         The client is permanently forbidden from making the request.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource.
     * @throws UnauthorizedClientException
     *         The client is not currently authorized to make the request.
     * @throws ThrottledClientException
     *         The client exceeded its request rate limit.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable.
     * @throws ServiceFailureException
     *         The service encountered an unexpected error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChimeSdkMediaPipelinesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChimeSdkMediaPipelinesClient.StartVoiceToneAnalysisTask
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-media-pipelines-2021-07-15/StartVoiceToneAnalysisTask"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public StartVoiceToneAnalysisTaskResponse startVoiceToneAnalysisTask(
            StartVoiceToneAnalysisTaskRequest startVoiceToneAnalysisTaskRequest) throws BadRequestException, ForbiddenException,
            ConflictException, UnauthorizedClientException, ThrottledClientException, NotFoundException,
            ServiceUnavailableException, ServiceFailureException, AwsServiceException, SdkClientException,
            ChimeSdkMediaPipelinesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<StartVoiceToneAnalysisTaskResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, StartVoiceToneAnalysisTaskResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startVoiceToneAnalysisTaskRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Media Pipelines");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartVoiceToneAnalysisTask");

            return clientHandler
                    .execute(new ClientExecutionParams<StartVoiceToneAnalysisTaskRequest, StartVoiceToneAnalysisTaskResponse>()
                            .withOperationName("StartVoiceToneAnalysisTask").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(startVoiceToneAnalysisTaskRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new StartVoiceToneAnalysisTaskRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Stops a speaker search task.
     * </p>
     *
     * @param stopSpeakerSearchTaskRequest
     * @return Result of the StopSpeakerSearchTask operation returned by the service.
     * @throws BadRequestException
     *         The input parameters don't match the service's restrictions.
     * @throws ForbiddenException
     *         The client is permanently forbidden from making the request.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource.
     * @throws UnauthorizedClientException
     *         The client is not currently authorized to make the request.
     * @throws ThrottledClientException
     *         The client exceeded its request rate limit.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable.
     * @throws ServiceFailureException
     *         The service encountered an unexpected error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChimeSdkMediaPipelinesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChimeSdkMediaPipelinesClient.StopSpeakerSearchTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-media-pipelines-2021-07-15/StopSpeakerSearchTask"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public StopSpeakerSearchTaskResponse stopSpeakerSearchTask(StopSpeakerSearchTaskRequest stopSpeakerSearchTaskRequest)
            throws BadRequestException, ForbiddenException, ConflictException, UnauthorizedClientException,
            ThrottledClientException, NotFoundException, ServiceUnavailableException, ServiceFailureException,
            AwsServiceException, SdkClientException, ChimeSdkMediaPipelinesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<StopSpeakerSearchTaskResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, StopSpeakerSearchTaskResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, stopSpeakerSearchTaskRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Media Pipelines");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StopSpeakerSearchTask");

            return clientHandler.execute(new ClientExecutionParams<StopSpeakerSearchTaskRequest, StopSpeakerSearchTaskResponse>()
                    .withOperationName("StopSpeakerSearchTask").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(stopSpeakerSearchTaskRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new StopSpeakerSearchTaskRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Stops a voice tone analysis task.
     * </p>
     *
     * @param stopVoiceToneAnalysisTaskRequest
     * @return Result of the StopVoiceToneAnalysisTask operation returned by the service.
     * @throws BadRequestException
     *         The input parameters don't match the service's restrictions.
     * @throws ForbiddenException
     *         The client is permanently forbidden from making the request.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource.
     * @throws UnauthorizedClientException
     *         The client is not currently authorized to make the request.
     * @throws ThrottledClientException
     *         The client exceeded its request rate limit.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable.
     * @throws ServiceFailureException
     *         The service encountered an unexpected error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChimeSdkMediaPipelinesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChimeSdkMediaPipelinesClient.StopVoiceToneAnalysisTask
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-media-pipelines-2021-07-15/StopVoiceToneAnalysisTask"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public StopVoiceToneAnalysisTaskResponse stopVoiceToneAnalysisTask(
            StopVoiceToneAnalysisTaskRequest stopVoiceToneAnalysisTaskRequest) throws BadRequestException, ForbiddenException,
            ConflictException, UnauthorizedClientException, ThrottledClientException, NotFoundException,
            ServiceUnavailableException, ServiceFailureException, AwsServiceException, SdkClientException,
            ChimeSdkMediaPipelinesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<StopVoiceToneAnalysisTaskResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, StopVoiceToneAnalysisTaskResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, stopVoiceToneAnalysisTaskRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Media Pipelines");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StopVoiceToneAnalysisTask");

            return clientHandler
                    .execute(new ClientExecutionParams<StopVoiceToneAnalysisTaskRequest, StopVoiceToneAnalysisTaskResponse>()
                            .withOperationName("StopVoiceToneAnalysisTask").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(stopVoiceToneAnalysisTaskRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new StopVoiceToneAnalysisTaskRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * The ARN of the media pipeline that you want to tag. Consists of the pipeline's endpoint region, resource ID, and
     * pipeline ID.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws BadRequestException
     *         The input parameters don't match the service's restrictions.
     * @throws ForbiddenException
     *         The client is permanently forbidden from making the request.
     * @throws UnauthorizedClientException
     *         The client is not currently authorized to make the request.
     * @throws ThrottledClientException
     *         The client exceeded its request rate limit.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable.
     * @throws ServiceFailureException
     *         The service encountered an unexpected error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChimeSdkMediaPipelinesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChimeSdkMediaPipelinesClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-media-pipelines-2021-07-15/TagResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws NotFoundException, BadRequestException,
            ForbiddenException, UnauthorizedClientException, ThrottledClientException, ServiceUnavailableException,
            ServiceFailureException, AwsServiceException, SdkClientException, ChimeSdkMediaPipelinesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<TagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                TagResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, tagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Media Pipelines");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TagResource");

            return clientHandler.execute(new ClientExecutionParams<TagResourceRequest, TagResourceResponse>()
                    .withOperationName("TagResource").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(tagResourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new TagResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Removes any tags from a media pipeline.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws BadRequestException
     *         The input parameters don't match the service's restrictions.
     * @throws ForbiddenException
     *         The client is permanently forbidden from making the request.
     * @throws UnauthorizedClientException
     *         The client is not currently authorized to make the request.
     * @throws ThrottledClientException
     *         The client exceeded its request rate limit.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable.
     * @throws ServiceFailureException
     *         The service encountered an unexpected error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChimeSdkMediaPipelinesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChimeSdkMediaPipelinesClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-media-pipelines-2021-07-15/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws NotFoundException,
            BadRequestException, ForbiddenException, UnauthorizedClientException, ThrottledClientException,
            ServiceUnavailableException, ServiceFailureException, AwsServiceException, SdkClientException,
            ChimeSdkMediaPipelinesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UntagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UntagResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, untagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Media Pipelines");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UntagResource");

            return clientHandler.execute(new ClientExecutionParams<UntagResourceRequest, UntagResourceResponse>()
                    .withOperationName("UntagResource").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(untagResourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UntagResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates the media insights pipeline's configuration settings.
     * </p>
     *
     * @param updateMediaInsightsPipelineConfigurationRequest
     * @return Result of the UpdateMediaInsightsPipelineConfiguration operation returned by the service.
     * @throws BadRequestException
     *         The input parameters don't match the service's restrictions.
     * @throws ForbiddenException
     *         The client is permanently forbidden from making the request.
     * @throws UnauthorizedClientException
     *         The client is not currently authorized to make the request.
     * @throws ThrottledClientException
     *         The client exceeded its request rate limit.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable.
     * @throws ServiceFailureException
     *         The service encountered an unexpected error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChimeSdkMediaPipelinesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChimeSdkMediaPipelinesClient.UpdateMediaInsightsPipelineConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-media-pipelines-2021-07-15/UpdateMediaInsightsPipelineConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateMediaInsightsPipelineConfigurationResponse updateMediaInsightsPipelineConfiguration(
            UpdateMediaInsightsPipelineConfigurationRequest updateMediaInsightsPipelineConfigurationRequest)
            throws BadRequestException, ForbiddenException, UnauthorizedClientException, ThrottledClientException,
            NotFoundException, ConflictException, ServiceUnavailableException, ServiceFailureException, AwsServiceException,
            SdkClientException, ChimeSdkMediaPipelinesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateMediaInsightsPipelineConfigurationResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, UpdateMediaInsightsPipelineConfigurationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                updateMediaInsightsPipelineConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Media Pipelines");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateMediaInsightsPipelineConfiguration");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateMediaInsightsPipelineConfigurationRequest, UpdateMediaInsightsPipelineConfigurationResponse>()
                            .withOperationName("UpdateMediaInsightsPipelineConfiguration").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler)
                            .withInput(updateMediaInsightsPipelineConfigurationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateMediaInsightsPipelineConfigurationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates the status of a media insights pipeline.
     * </p>
     *
     * @param updateMediaInsightsPipelineStatusRequest
     * @return Result of the UpdateMediaInsightsPipelineStatus operation returned by the service.
     * @throws BadRequestException
     *         The input parameters don't match the service's restrictions.
     * @throws ForbiddenException
     *         The client is permanently forbidden from making the request.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource.
     * @throws UnauthorizedClientException
     *         The client is not currently authorized to make the request.
     * @throws ThrottledClientException
     *         The client exceeded its request rate limit.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable.
     * @throws ServiceFailureException
     *         The service encountered an unexpected error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChimeSdkMediaPipelinesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChimeSdkMediaPipelinesClient.UpdateMediaInsightsPipelineStatus
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-media-pipelines-2021-07-15/UpdateMediaInsightsPipelineStatus"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateMediaInsightsPipelineStatusResponse updateMediaInsightsPipelineStatus(
            UpdateMediaInsightsPipelineStatusRequest updateMediaInsightsPipelineStatusRequest) throws BadRequestException,
            ForbiddenException, ConflictException, UnauthorizedClientException, ThrottledClientException, NotFoundException,
            ServiceUnavailableException, ServiceFailureException, AwsServiceException, SdkClientException,
            ChimeSdkMediaPipelinesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateMediaInsightsPipelineStatusResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateMediaInsightsPipelineStatusResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                updateMediaInsightsPipelineStatusRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Media Pipelines");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateMediaInsightsPipelineStatus");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateMediaInsightsPipelineStatusRequest, UpdateMediaInsightsPipelineStatusResponse>()
                            .withOperationName("UpdateMediaInsightsPipelineStatus").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(updateMediaInsightsPipelineStatusRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateMediaInsightsPipelineStatusRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates an Kinesis video stream pool in a media pipeline.
     * </p>
     *
     * @param updateMediaPipelineKinesisVideoStreamPoolRequest
     * @return Result of the UpdateMediaPipelineKinesisVideoStreamPool operation returned by the service.
     * @throws BadRequestException
     *         The input parameters don't match the service's restrictions.
     * @throws ForbiddenException
     *         The client is permanently forbidden from making the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws UnauthorizedClientException
     *         The client is not currently authorized to make the request.
     * @throws ThrottledClientException
     *         The client exceeded its request rate limit.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable.
     * @throws ServiceFailureException
     *         The service encountered an unexpected error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChimeSdkMediaPipelinesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChimeSdkMediaPipelinesClient.UpdateMediaPipelineKinesisVideoStreamPool
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-media-pipelines-2021-07-15/UpdateMediaPipelineKinesisVideoStreamPool"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateMediaPipelineKinesisVideoStreamPoolResponse updateMediaPipelineKinesisVideoStreamPool(
            UpdateMediaPipelineKinesisVideoStreamPoolRequest updateMediaPipelineKinesisVideoStreamPoolRequest)
            throws BadRequestException, ForbiddenException, NotFoundException, UnauthorizedClientException,
            ThrottledClientException, ConflictException, ServiceUnavailableException, ServiceFailureException,
            AwsServiceException, SdkClientException, ChimeSdkMediaPipelinesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateMediaPipelineKinesisVideoStreamPoolResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, UpdateMediaPipelineKinesisVideoStreamPoolResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                updateMediaPipelineKinesisVideoStreamPoolRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Media Pipelines");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateMediaPipelineKinesisVideoStreamPool");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateMediaPipelineKinesisVideoStreamPoolRequest, UpdateMediaPipelineKinesisVideoStreamPoolResponse>()
                            .withOperationName("UpdateMediaPipelineKinesisVideoStreamPool").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler)
                            .withInput(updateMediaPipelineKinesisVideoStreamPoolRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateMediaPipelineKinesisVideoStreamPoolRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration,
            RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder
                .clientConfiguration(clientConfiguration)
                .defaultServiceExceptionSupplier(ChimeSdkMediaPipelinesException::builder)
                .protocol(AwsJsonProtocol.REST_JSON)
                .protocolVersion("1.1")
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ForbiddenException")
                                .exceptionBuilderSupplier(ForbiddenException::builder).httpStatusCode(403).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceLimitExceededException")
                                .exceptionBuilderSupplier(ResourceLimitExceededException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("UnauthorizedClientException")
                                .exceptionBuilderSupplier(UnauthorizedClientException::builder).httpStatusCode(401).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NotFoundException")
                                .exceptionBuilderSupplier(NotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ServiceFailureException")
                                .exceptionBuilderSupplier(ServiceFailureException::builder).httpStatusCode(500).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ConflictException")
                                .exceptionBuilderSupplier(ConflictException::builder).httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ThrottledClientException")
                                .exceptionBuilderSupplier(ThrottledClientException::builder).httpStatusCode(429).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ServiceUnavailableException")
                                .exceptionBuilderSupplier(ServiceUnavailableException::builder).httpStatusCode(503).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("BadRequestException")
                                .exceptionBuilderSupplier(BadRequestException::builder).httpStatusCode(400).build());
    }

    @Override
    public final ChimeSdkMediaPipelinesServiceClientConfiguration serviceClientConfiguration() {
        return this.serviceClientConfiguration;
    }

    @Override
    public void close() {
        clientHandler.close();
    }
}
