/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkmediapipelines.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that contains the runtime settings for recording a Kinesis video stream.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class KinesisVideoStreamRecordingSourceRuntimeConfiguration
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<KinesisVideoStreamRecordingSourceRuntimeConfiguration.Builder, KinesisVideoStreamRecordingSourceRuntimeConfiguration> {
    private static final SdkField<List<RecordingStreamConfiguration>> STREAMS_FIELD = SdkField
            .<List<RecordingStreamConfiguration>> builder(MarshallingType.LIST)
            .memberName("Streams")
            .getter(getter(KinesisVideoStreamRecordingSourceRuntimeConfiguration::streams))
            .setter(setter(Builder::streams))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Streams").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RecordingStreamConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(RecordingStreamConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<FragmentSelector> FRAGMENT_SELECTOR_FIELD = SdkField
            .<FragmentSelector> builder(MarshallingType.SDK_POJO).memberName("FragmentSelector")
            .getter(getter(KinesisVideoStreamRecordingSourceRuntimeConfiguration::fragmentSelector))
            .setter(setter(Builder::fragmentSelector)).constructor(FragmentSelector::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FragmentSelector").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STREAMS_FIELD,
            FRAGMENT_SELECTOR_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<RecordingStreamConfiguration> streams;

    private final FragmentSelector fragmentSelector;

    private KinesisVideoStreamRecordingSourceRuntimeConfiguration(BuilderImpl builder) {
        this.streams = builder.streams;
        this.fragmentSelector = builder.fragmentSelector;
    }

    /**
     * For responses, this returns true if the service returned a value for the Streams property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasStreams() {
        return streams != null && !(streams instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The stream or streams to be recorded.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStreams} method.
     * </p>
     * 
     * @return The stream or streams to be recorded.
     */
    public final List<RecordingStreamConfiguration> streams() {
        return streams;
    }

    /**
     * <p>
     * Describes the timestamp range and timestamp origin of a range of fragments in the Kinesis video stream.
     * </p>
     * 
     * @return Describes the timestamp range and timestamp origin of a range of fragments in the Kinesis video stream.
     */
    public final FragmentSelector fragmentSelector() {
        return fragmentSelector;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasStreams() ? streams() : null);
        hashCode = 31 * hashCode + Objects.hashCode(fragmentSelector());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KinesisVideoStreamRecordingSourceRuntimeConfiguration)) {
            return false;
        }
        KinesisVideoStreamRecordingSourceRuntimeConfiguration other = (KinesisVideoStreamRecordingSourceRuntimeConfiguration) obj;
        return hasStreams() == other.hasStreams() && Objects.equals(streams(), other.streams())
                && Objects.equals(fragmentSelector(), other.fragmentSelector());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("KinesisVideoStreamRecordingSourceRuntimeConfiguration")
                .add("Streams", hasStreams() ? streams() : null).add("FragmentSelector", fragmentSelector()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Streams":
            return Optional.ofNullable(clazz.cast(streams()));
        case "FragmentSelector":
            return Optional.ofNullable(clazz.cast(fragmentSelector()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<KinesisVideoStreamRecordingSourceRuntimeConfiguration, T> g) {
        return obj -> g.apply((KinesisVideoStreamRecordingSourceRuntimeConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, KinesisVideoStreamRecordingSourceRuntimeConfiguration> {
        /**
         * <p>
         * The stream or streams to be recorded.
         * </p>
         * 
         * @param streams
         *        The stream or streams to be recorded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streams(Collection<RecordingStreamConfiguration> streams);

        /**
         * <p>
         * The stream or streams to be recorded.
         * </p>
         * 
         * @param streams
         *        The stream or streams to be recorded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streams(RecordingStreamConfiguration... streams);

        /**
         * <p>
         * The stream or streams to be recorded.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.chimesdkmediapipelines.model.RecordingStreamConfiguration.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.chimesdkmediapipelines.model.RecordingStreamConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.chimesdkmediapipelines.model.RecordingStreamConfiguration.Builder#build()}
         * is called immediately and its result is passed to {@link #streams(List<RecordingStreamConfiguration>)}.
         * 
         * @param streams
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.chimesdkmediapipelines.model.RecordingStreamConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #streams(java.util.Collection<RecordingStreamConfiguration>)
         */
        Builder streams(Consumer<RecordingStreamConfiguration.Builder>... streams);

        /**
         * <p>
         * Describes the timestamp range and timestamp origin of a range of fragments in the Kinesis video stream.
         * </p>
         * 
         * @param fragmentSelector
         *        Describes the timestamp range and timestamp origin of a range of fragments in the Kinesis video
         *        stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fragmentSelector(FragmentSelector fragmentSelector);

        /**
         * <p>
         * Describes the timestamp range and timestamp origin of a range of fragments in the Kinesis video stream.
         * </p>
         * This is a convenience method that creates an instance of the {@link FragmentSelector.Builder} avoiding the
         * need to create one manually via {@link FragmentSelector#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FragmentSelector.Builder#build()} is called immediately and its
         * result is passed to {@link #fragmentSelector(FragmentSelector)}.
         * 
         * @param fragmentSelector
         *        a consumer that will call methods on {@link FragmentSelector.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fragmentSelector(FragmentSelector)
         */
        default Builder fragmentSelector(Consumer<FragmentSelector.Builder> fragmentSelector) {
            return fragmentSelector(FragmentSelector.builder().applyMutation(fragmentSelector).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private List<RecordingStreamConfiguration> streams = DefaultSdkAutoConstructList.getInstance();

        private FragmentSelector fragmentSelector;

        private BuilderImpl() {
        }

        private BuilderImpl(KinesisVideoStreamRecordingSourceRuntimeConfiguration model) {
            streams(model.streams);
            fragmentSelector(model.fragmentSelector);
        }

        public final List<RecordingStreamConfiguration.Builder> getStreams() {
            List<RecordingStreamConfiguration.Builder> result = RecordingStreamListCopier.copyToBuilder(this.streams);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStreams(Collection<RecordingStreamConfiguration.BuilderImpl> streams) {
            this.streams = RecordingStreamListCopier.copyFromBuilder(streams);
        }

        @Override
        public final Builder streams(Collection<RecordingStreamConfiguration> streams) {
            this.streams = RecordingStreamListCopier.copy(streams);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder streams(RecordingStreamConfiguration... streams) {
            streams(Arrays.asList(streams));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder streams(Consumer<RecordingStreamConfiguration.Builder>... streams) {
            streams(Stream.of(streams).map(c -> RecordingStreamConfiguration.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final FragmentSelector.Builder getFragmentSelector() {
            return fragmentSelector != null ? fragmentSelector.toBuilder() : null;
        }

        public final void setFragmentSelector(FragmentSelector.BuilderImpl fragmentSelector) {
            this.fragmentSelector = fragmentSelector != null ? fragmentSelector.build() : null;
        }

        @Override
        public final Builder fragmentSelector(FragmentSelector fragmentSelector) {
            this.fragmentSelector = fragmentSelector;
            return this;
        }

        @Override
        public KinesisVideoStreamRecordingSourceRuntimeConfiguration build() {
            return new KinesisVideoStreamRecordingSourceRuntimeConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
