/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chimesdkmediapipelines.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.TileOrder;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.VerticalTilePosition;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VerticalLayoutConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, VerticalLayoutConfiguration> {
    private static final SdkField<String> TILE_ORDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TileOrder").getter(VerticalLayoutConfiguration.getter(VerticalLayoutConfiguration::tileOrderAsString)).setter(VerticalLayoutConfiguration.setter(Builder::tileOrder)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TileOrder").build()}).build();
    private static final SdkField<String> TILE_POSITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TilePosition").getter(VerticalLayoutConfiguration.getter(VerticalLayoutConfiguration::tilePositionAsString)).setter(VerticalLayoutConfiguration.setter(Builder::tilePosition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TilePosition").build()}).build();
    private static final SdkField<Integer> TILE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TileCount").getter(VerticalLayoutConfiguration.getter(VerticalLayoutConfiguration::tileCount)).setter(VerticalLayoutConfiguration.setter(Builder::tileCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TileCount").build()}).build();
    private static final SdkField<String> TILE_ASPECT_RATIO_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TileAspectRatio").getter(VerticalLayoutConfiguration.getter(VerticalLayoutConfiguration::tileAspectRatio)).setter(VerticalLayoutConfiguration.setter(Builder::tileAspectRatio)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TileAspectRatio").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TILE_ORDER_FIELD, TILE_POSITION_FIELD, TILE_COUNT_FIELD, TILE_ASPECT_RATIO_FIELD));
    private static final long serialVersionUID = 1L;
    private final String tileOrder;
    private final String tilePosition;
    private final Integer tileCount;
    private final String tileAspectRatio;

    private VerticalLayoutConfiguration(BuilderImpl builder) {
        this.tileOrder = builder.tileOrder;
        this.tilePosition = builder.tilePosition;
        this.tileCount = builder.tileCount;
        this.tileAspectRatio = builder.tileAspectRatio;
    }

    public final TileOrder tileOrder() {
        return TileOrder.fromValue(this.tileOrder);
    }

    public final String tileOrderAsString() {
        return this.tileOrder;
    }

    public final VerticalTilePosition tilePosition() {
        return VerticalTilePosition.fromValue(this.tilePosition);
    }

    public final String tilePositionAsString() {
        return this.tilePosition;
    }

    public final Integer tileCount() {
        return this.tileCount;
    }

    public final String tileAspectRatio() {
        return this.tileAspectRatio;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.tileOrderAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.tilePositionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.tileCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.tileAspectRatio());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VerticalLayoutConfiguration)) {
            return false;
        }
        VerticalLayoutConfiguration other = (VerticalLayoutConfiguration)obj;
        return Objects.equals(this.tileOrderAsString(), other.tileOrderAsString()) && Objects.equals(this.tilePositionAsString(), other.tilePositionAsString()) && Objects.equals(this.tileCount(), other.tileCount()) && Objects.equals(this.tileAspectRatio(), other.tileAspectRatio());
    }

    public final String toString() {
        return ToString.builder((String)"VerticalLayoutConfiguration").add("TileOrder", (Object)this.tileOrderAsString()).add("TilePosition", (Object)this.tilePositionAsString()).add("TileCount", (Object)this.tileCount()).add("TileAspectRatio", (Object)this.tileAspectRatio()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TileOrder": {
                return Optional.ofNullable(clazz.cast(this.tileOrderAsString()));
            }
            case "TilePosition": {
                return Optional.ofNullable(clazz.cast(this.tilePositionAsString()));
            }
            case "TileCount": {
                return Optional.ofNullable(clazz.cast(this.tileCount()));
            }
            case "TileAspectRatio": {
                return Optional.ofNullable(clazz.cast(this.tileAspectRatio()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VerticalLayoutConfiguration, T> g) {
        return obj -> g.apply((VerticalLayoutConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String tileOrder;
        private String tilePosition;
        private Integer tileCount;
        private String tileAspectRatio;

        private BuilderImpl() {
        }

        private BuilderImpl(VerticalLayoutConfiguration model) {
            this.tileOrder(model.tileOrder);
            this.tilePosition(model.tilePosition);
            this.tileCount(model.tileCount);
            this.tileAspectRatio(model.tileAspectRatio);
        }

        public final String getTileOrder() {
            return this.tileOrder;
        }

        public final void setTileOrder(String tileOrder) {
            this.tileOrder = tileOrder;
        }

        @Override
        public final Builder tileOrder(String tileOrder) {
            this.tileOrder = tileOrder;
            return this;
        }

        @Override
        public final Builder tileOrder(TileOrder tileOrder) {
            this.tileOrder(tileOrder == null ? null : tileOrder.toString());
            return this;
        }

        public final String getTilePosition() {
            return this.tilePosition;
        }

        public final void setTilePosition(String tilePosition) {
            this.tilePosition = tilePosition;
        }

        @Override
        public final Builder tilePosition(String tilePosition) {
            this.tilePosition = tilePosition;
            return this;
        }

        @Override
        public final Builder tilePosition(VerticalTilePosition tilePosition) {
            this.tilePosition(tilePosition == null ? null : tilePosition.toString());
            return this;
        }

        public final Integer getTileCount() {
            return this.tileCount;
        }

        public final void setTileCount(Integer tileCount) {
            this.tileCount = tileCount;
        }

        @Override
        public final Builder tileCount(Integer tileCount) {
            this.tileCount = tileCount;
            return this;
        }

        public final String getTileAspectRatio() {
            return this.tileAspectRatio;
        }

        public final void setTileAspectRatio(String tileAspectRatio) {
            this.tileAspectRatio = tileAspectRatio;
        }

        @Override
        public final Builder tileAspectRatio(String tileAspectRatio) {
            this.tileAspectRatio = tileAspectRatio;
            return this;
        }

        public VerticalLayoutConfiguration build() {
            return new VerticalLayoutConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, VerticalLayoutConfiguration> {
        public Builder tileOrder(String var1);

        public Builder tileOrder(TileOrder var1);

        public Builder tilePosition(String var1);

        public Builder tilePosition(VerticalTilePosition var1);

        public Builder tileCount(Integer var1);

        public Builder tileAspectRatio(String var1);
    }
}

