/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chimesdkmediapipelines.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaPipelineTaskStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VoiceToneAnalysisTask
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, VoiceToneAnalysisTask> {
    private static final SdkField<String> VOICE_TONE_ANALYSIS_TASK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VoiceToneAnalysisTaskId").getter(VoiceToneAnalysisTask.getter(VoiceToneAnalysisTask::voiceToneAnalysisTaskId)).setter(VoiceToneAnalysisTask.setter(Builder::voiceToneAnalysisTaskId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VoiceToneAnalysisTaskId").build()}).build();
    private static final SdkField<String> VOICE_TONE_ANALYSIS_TASK_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VoiceToneAnalysisTaskStatus").getter(VoiceToneAnalysisTask.getter(VoiceToneAnalysisTask::voiceToneAnalysisTaskStatusAsString)).setter(VoiceToneAnalysisTask.setter(Builder::voiceToneAnalysisTaskStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VoiceToneAnalysisTaskStatus").build()}).build();
    private static final SdkField<Instant> CREATED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedTimestamp").getter(VoiceToneAnalysisTask.getter(VoiceToneAnalysisTask::createdTimestamp)).setter(VoiceToneAnalysisTask.setter(Builder::createdTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTimestamp").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> UPDATED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("UpdatedTimestamp").getter(VoiceToneAnalysisTask.getter(VoiceToneAnalysisTask::updatedTimestamp)).setter(VoiceToneAnalysisTask.setter(Builder::updatedTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedTimestamp").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VOICE_TONE_ANALYSIS_TASK_ID_FIELD, VOICE_TONE_ANALYSIS_TASK_STATUS_FIELD, CREATED_TIMESTAMP_FIELD, UPDATED_TIMESTAMP_FIELD));
    private static final long serialVersionUID = 1L;
    private final String voiceToneAnalysisTaskId;
    private final String voiceToneAnalysisTaskStatus;
    private final Instant createdTimestamp;
    private final Instant updatedTimestamp;

    private VoiceToneAnalysisTask(BuilderImpl builder) {
        this.voiceToneAnalysisTaskId = builder.voiceToneAnalysisTaskId;
        this.voiceToneAnalysisTaskStatus = builder.voiceToneAnalysisTaskStatus;
        this.createdTimestamp = builder.createdTimestamp;
        this.updatedTimestamp = builder.updatedTimestamp;
    }

    public final String voiceToneAnalysisTaskId() {
        return this.voiceToneAnalysisTaskId;
    }

    public final MediaPipelineTaskStatus voiceToneAnalysisTaskStatus() {
        return MediaPipelineTaskStatus.fromValue(this.voiceToneAnalysisTaskStatus);
    }

    public final String voiceToneAnalysisTaskStatusAsString() {
        return this.voiceToneAnalysisTaskStatus;
    }

    public final Instant createdTimestamp() {
        return this.createdTimestamp;
    }

    public final Instant updatedTimestamp() {
        return this.updatedTimestamp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.voiceToneAnalysisTaskId());
        hashCode = 31 * hashCode + Objects.hashCode(this.voiceToneAnalysisTaskStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedTimestamp());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VoiceToneAnalysisTask)) {
            return false;
        }
        VoiceToneAnalysisTask other = (VoiceToneAnalysisTask)obj;
        return Objects.equals(this.voiceToneAnalysisTaskId(), other.voiceToneAnalysisTaskId()) && Objects.equals(this.voiceToneAnalysisTaskStatusAsString(), other.voiceToneAnalysisTaskStatusAsString()) && Objects.equals(this.createdTimestamp(), other.createdTimestamp()) && Objects.equals(this.updatedTimestamp(), other.updatedTimestamp());
    }

    public final String toString() {
        return ToString.builder((String)"VoiceToneAnalysisTask").add("VoiceToneAnalysisTaskId", (Object)this.voiceToneAnalysisTaskId()).add("VoiceToneAnalysisTaskStatus", (Object)this.voiceToneAnalysisTaskStatusAsString()).add("CreatedTimestamp", (Object)this.createdTimestamp()).add("UpdatedTimestamp", (Object)this.updatedTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VoiceToneAnalysisTaskId": {
                return Optional.ofNullable(clazz.cast(this.voiceToneAnalysisTaskId()));
            }
            case "VoiceToneAnalysisTaskStatus": {
                return Optional.ofNullable(clazz.cast(this.voiceToneAnalysisTaskStatusAsString()));
            }
            case "CreatedTimestamp": {
                return Optional.ofNullable(clazz.cast(this.createdTimestamp()));
            }
            case "UpdatedTimestamp": {
                return Optional.ofNullable(clazz.cast(this.updatedTimestamp()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VoiceToneAnalysisTask, T> g) {
        return obj -> g.apply((VoiceToneAnalysisTask)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String voiceToneAnalysisTaskId;
        private String voiceToneAnalysisTaskStatus;
        private Instant createdTimestamp;
        private Instant updatedTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(VoiceToneAnalysisTask model) {
            this.voiceToneAnalysisTaskId(model.voiceToneAnalysisTaskId);
            this.voiceToneAnalysisTaskStatus(model.voiceToneAnalysisTaskStatus);
            this.createdTimestamp(model.createdTimestamp);
            this.updatedTimestamp(model.updatedTimestamp);
        }

        public final String getVoiceToneAnalysisTaskId() {
            return this.voiceToneAnalysisTaskId;
        }

        public final void setVoiceToneAnalysisTaskId(String voiceToneAnalysisTaskId) {
            this.voiceToneAnalysisTaskId = voiceToneAnalysisTaskId;
        }

        @Override
        public final Builder voiceToneAnalysisTaskId(String voiceToneAnalysisTaskId) {
            this.voiceToneAnalysisTaskId = voiceToneAnalysisTaskId;
            return this;
        }

        public final String getVoiceToneAnalysisTaskStatus() {
            return this.voiceToneAnalysisTaskStatus;
        }

        public final void setVoiceToneAnalysisTaskStatus(String voiceToneAnalysisTaskStatus) {
            this.voiceToneAnalysisTaskStatus = voiceToneAnalysisTaskStatus;
        }

        @Override
        public final Builder voiceToneAnalysisTaskStatus(String voiceToneAnalysisTaskStatus) {
            this.voiceToneAnalysisTaskStatus = voiceToneAnalysisTaskStatus;
            return this;
        }

        @Override
        public final Builder voiceToneAnalysisTaskStatus(MediaPipelineTaskStatus voiceToneAnalysisTaskStatus) {
            this.voiceToneAnalysisTaskStatus(voiceToneAnalysisTaskStatus == null ? null : voiceToneAnalysisTaskStatus.toString());
            return this;
        }

        public final Instant getCreatedTimestamp() {
            return this.createdTimestamp;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        @Override
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        public final Instant getUpdatedTimestamp() {
            return this.updatedTimestamp;
        }

        public final void setUpdatedTimestamp(Instant updatedTimestamp) {
            this.updatedTimestamp = updatedTimestamp;
        }

        @Override
        public final Builder updatedTimestamp(Instant updatedTimestamp) {
            this.updatedTimestamp = updatedTimestamp;
            return this;
        }

        public VoiceToneAnalysisTask build() {
            return new VoiceToneAnalysisTask(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, VoiceToneAnalysisTask> {
        public Builder voiceToneAnalysisTaskId(String var1);

        public Builder voiceToneAnalysisTaskStatus(String var1);

        public Builder voiceToneAnalysisTaskStatus(MediaPipelineTaskStatus var1);

        public Builder createdTimestamp(Instant var1);

        public Builder updatedTimestamp(Instant var1);
    }
}

