/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkmeetings.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchUpdateAttendeeCapabilitiesExceptRequest extends ChimeSdkMeetingsRequest implements
        ToCopyableBuilder<BatchUpdateAttendeeCapabilitiesExceptRequest.Builder, BatchUpdateAttendeeCapabilitiesExceptRequest> {
    private static final SdkField<String> MEETING_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MeetingId").getter(getter(BatchUpdateAttendeeCapabilitiesExceptRequest::meetingId))
            .setter(setter(Builder::meetingId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("MeetingId").build()).build();

    private static final SdkField<List<AttendeeIdItem>> EXCLUDED_ATTENDEE_IDS_FIELD = SdkField
            .<List<AttendeeIdItem>> builder(MarshallingType.LIST)
            .memberName("ExcludedAttendeeIds")
            .getter(getter(BatchUpdateAttendeeCapabilitiesExceptRequest::excludedAttendeeIds))
            .setter(setter(Builder::excludedAttendeeIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExcludedAttendeeIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AttendeeIdItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(AttendeeIdItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<AttendeeCapabilities> CAPABILITIES_FIELD = SdkField
            .<AttendeeCapabilities> builder(MarshallingType.SDK_POJO).memberName("Capabilities")
            .getter(getter(BatchUpdateAttendeeCapabilitiesExceptRequest::capabilities)).setter(setter(Builder::capabilities))
            .constructor(AttendeeCapabilities::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Capabilities").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEETING_ID_FIELD,
            EXCLUDED_ATTENDEE_IDS_FIELD, CAPABILITIES_FIELD));

    private final String meetingId;

    private final List<AttendeeIdItem> excludedAttendeeIds;

    private final AttendeeCapabilities capabilities;

    private BatchUpdateAttendeeCapabilitiesExceptRequest(BuilderImpl builder) {
        super(builder);
        this.meetingId = builder.meetingId;
        this.excludedAttendeeIds = builder.excludedAttendeeIds;
        this.capabilities = builder.capabilities;
    }

    /**
     * <p>
     * The ID of the meeting associated with the update request.
     * </p>
     * 
     * @return The ID of the meeting associated with the update request.
     */
    public final String meetingId() {
        return meetingId;
    }

    /**
     * For responses, this returns true if the service returned a value for the ExcludedAttendeeIds property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasExcludedAttendeeIds() {
        return excludedAttendeeIds != null && !(excludedAttendeeIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The <code>AttendeeIDs</code> that you want to exclude from one or more capabilities.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasExcludedAttendeeIds} method.
     * </p>
     * 
     * @return The <code>AttendeeIDs</code> that you want to exclude from one or more capabilities.
     */
    public final List<AttendeeIdItem> excludedAttendeeIds() {
        return excludedAttendeeIds;
    }

    /**
     * <p>
     * The capabilities (<code>audio</code>, <code>video</code>, or <code>content</code>) that you want to update.
     * </p>
     * 
     * @return The capabilities (<code>audio</code>, <code>video</code>, or <code>content</code>) that you want to
     *         update.
     */
    public final AttendeeCapabilities capabilities() {
        return capabilities;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(meetingId());
        hashCode = 31 * hashCode + Objects.hashCode(hasExcludedAttendeeIds() ? excludedAttendeeIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(capabilities());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchUpdateAttendeeCapabilitiesExceptRequest)) {
            return false;
        }
        BatchUpdateAttendeeCapabilitiesExceptRequest other = (BatchUpdateAttendeeCapabilitiesExceptRequest) obj;
        return Objects.equals(meetingId(), other.meetingId()) && hasExcludedAttendeeIds() == other.hasExcludedAttendeeIds()
                && Objects.equals(excludedAttendeeIds(), other.excludedAttendeeIds())
                && Objects.equals(capabilities(), other.capabilities());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchUpdateAttendeeCapabilitiesExceptRequest").add("MeetingId", meetingId())
                .add("ExcludedAttendeeIds", hasExcludedAttendeeIds() ? excludedAttendeeIds() : null)
                .add("Capabilities", capabilities()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MeetingId":
            return Optional.ofNullable(clazz.cast(meetingId()));
        case "ExcludedAttendeeIds":
            return Optional.ofNullable(clazz.cast(excludedAttendeeIds()));
        case "Capabilities":
            return Optional.ofNullable(clazz.cast(capabilities()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchUpdateAttendeeCapabilitiesExceptRequest, T> g) {
        return obj -> g.apply((BatchUpdateAttendeeCapabilitiesExceptRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ChimeSdkMeetingsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, BatchUpdateAttendeeCapabilitiesExceptRequest> {
        /**
         * <p>
         * The ID of the meeting associated with the update request.
         * </p>
         * 
         * @param meetingId
         *        The ID of the meeting associated with the update request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder meetingId(String meetingId);

        /**
         * <p>
         * The <code>AttendeeIDs</code> that you want to exclude from one or more capabilities.
         * </p>
         * 
         * @param excludedAttendeeIds
         *        The <code>AttendeeIDs</code> that you want to exclude from one or more capabilities.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder excludedAttendeeIds(Collection<AttendeeIdItem> excludedAttendeeIds);

        /**
         * <p>
         * The <code>AttendeeIDs</code> that you want to exclude from one or more capabilities.
         * </p>
         * 
         * @param excludedAttendeeIds
         *        The <code>AttendeeIDs</code> that you want to exclude from one or more capabilities.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder excludedAttendeeIds(AttendeeIdItem... excludedAttendeeIds);

        /**
         * <p>
         * The <code>AttendeeIDs</code> that you want to exclude from one or more capabilities.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.chimesdkmeetings.model.AttendeeIdItem.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.chimesdkmeetings.model.AttendeeIdItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.chimesdkmeetings.model.AttendeeIdItem.Builder#build()} is called
         * immediately and its result is passed to {@link #excludedAttendeeIds(List<AttendeeIdItem>)}.
         * 
         * @param excludedAttendeeIds
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.chimesdkmeetings.model.AttendeeIdItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #excludedAttendeeIds(java.util.Collection<AttendeeIdItem>)
         */
        Builder excludedAttendeeIds(Consumer<AttendeeIdItem.Builder>... excludedAttendeeIds);

        /**
         * <p>
         * The capabilities (<code>audio</code>, <code>video</code>, or <code>content</code>) that you want to update.
         * </p>
         * 
         * @param capabilities
         *        The capabilities (<code>audio</code>, <code>video</code>, or <code>content</code>) that you want to
         *        update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capabilities(AttendeeCapabilities capabilities);

        /**
         * <p>
         * The capabilities (<code>audio</code>, <code>video</code>, or <code>content</code>) that you want to update.
         * </p>
         * This is a convenience method that creates an instance of the {@link AttendeeCapabilities.Builder} avoiding
         * the need to create one manually via {@link AttendeeCapabilities#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AttendeeCapabilities.Builder#build()} is called immediately and
         * its result is passed to {@link #capabilities(AttendeeCapabilities)}.
         * 
         * @param capabilities
         *        a consumer that will call methods on {@link AttendeeCapabilities.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #capabilities(AttendeeCapabilities)
         */
        default Builder capabilities(Consumer<AttendeeCapabilities.Builder> capabilities) {
            return capabilities(AttendeeCapabilities.builder().applyMutation(capabilities).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ChimeSdkMeetingsRequest.BuilderImpl implements Builder {
        private String meetingId;

        private List<AttendeeIdItem> excludedAttendeeIds = DefaultSdkAutoConstructList.getInstance();

        private AttendeeCapabilities capabilities;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchUpdateAttendeeCapabilitiesExceptRequest model) {
            super(model);
            meetingId(model.meetingId);
            excludedAttendeeIds(model.excludedAttendeeIds);
            capabilities(model.capabilities);
        }

        public final String getMeetingId() {
            return meetingId;
        }

        public final void setMeetingId(String meetingId) {
            this.meetingId = meetingId;
        }

        @Override
        public final Builder meetingId(String meetingId) {
            this.meetingId = meetingId;
            return this;
        }

        public final List<AttendeeIdItem.Builder> getExcludedAttendeeIds() {
            List<AttendeeIdItem.Builder> result = AttendeeIdsListCopier.copyToBuilder(this.excludedAttendeeIds);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setExcludedAttendeeIds(Collection<AttendeeIdItem.BuilderImpl> excludedAttendeeIds) {
            this.excludedAttendeeIds = AttendeeIdsListCopier.copyFromBuilder(excludedAttendeeIds);
        }

        @Override
        public final Builder excludedAttendeeIds(Collection<AttendeeIdItem> excludedAttendeeIds) {
            this.excludedAttendeeIds = AttendeeIdsListCopier.copy(excludedAttendeeIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder excludedAttendeeIds(AttendeeIdItem... excludedAttendeeIds) {
            excludedAttendeeIds(Arrays.asList(excludedAttendeeIds));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder excludedAttendeeIds(Consumer<AttendeeIdItem.Builder>... excludedAttendeeIds) {
            excludedAttendeeIds(Stream.of(excludedAttendeeIds).map(c -> AttendeeIdItem.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final AttendeeCapabilities.Builder getCapabilities() {
            return capabilities != null ? capabilities.toBuilder() : null;
        }

        public final void setCapabilities(AttendeeCapabilities.BuilderImpl capabilities) {
            this.capabilities = capabilities != null ? capabilities.build() : null;
        }

        @Override
        public final Builder capabilities(AttendeeCapabilities capabilities) {
            this.capabilities = capabilities;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchUpdateAttendeeCapabilitiesExceptRequest build() {
            return new BatchUpdateAttendeeCapabilitiesExceptRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
