/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chimesdkmeetings.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.chimesdkmeetings.model.AttendeeFeatures;
import software.amazon.awssdk.services.chimesdkmeetings.model.AudioFeatures;
import software.amazon.awssdk.services.chimesdkmeetings.model.ContentFeatures;
import software.amazon.awssdk.services.chimesdkmeetings.model.VideoFeatures;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MeetingFeaturesConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MeetingFeaturesConfiguration> {
    private static final SdkField<AudioFeatures> AUDIO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Audio").getter(MeetingFeaturesConfiguration.getter(MeetingFeaturesConfiguration::audio)).setter(MeetingFeaturesConfiguration.setter(Builder::audio)).constructor(AudioFeatures::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Audio").build()}).build();
    private static final SdkField<VideoFeatures> VIDEO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Video").getter(MeetingFeaturesConfiguration.getter(MeetingFeaturesConfiguration::video)).setter(MeetingFeaturesConfiguration.setter(Builder::video)).constructor(VideoFeatures::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Video").build()}).build();
    private static final SdkField<ContentFeatures> CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Content").getter(MeetingFeaturesConfiguration.getter(MeetingFeaturesConfiguration::content)).setter(MeetingFeaturesConfiguration.setter(Builder::content)).constructor(ContentFeatures::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Content").build()}).build();
    private static final SdkField<AttendeeFeatures> ATTENDEE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Attendee").getter(MeetingFeaturesConfiguration.getter(MeetingFeaturesConfiguration::attendee)).setter(MeetingFeaturesConfiguration.setter(Builder::attendee)).constructor(AttendeeFeatures::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attendee").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUDIO_FIELD, VIDEO_FIELD, CONTENT_FIELD, ATTENDEE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = MeetingFeaturesConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final AudioFeatures audio;
    private final VideoFeatures video;
    private final ContentFeatures content;
    private final AttendeeFeatures attendee;

    private MeetingFeaturesConfiguration(BuilderImpl builder) {
        this.audio = builder.audio;
        this.video = builder.video;
        this.content = builder.content;
        this.attendee = builder.attendee;
    }

    public final AudioFeatures audio() {
        return this.audio;
    }

    public final VideoFeatures video() {
        return this.video;
    }

    public final ContentFeatures content() {
        return this.content;
    }

    public final AttendeeFeatures attendee() {
        return this.attendee;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.audio());
        hashCode = 31 * hashCode + Objects.hashCode(this.video());
        hashCode = 31 * hashCode + Objects.hashCode(this.content());
        hashCode = 31 * hashCode + Objects.hashCode(this.attendee());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MeetingFeaturesConfiguration)) {
            return false;
        }
        MeetingFeaturesConfiguration other = (MeetingFeaturesConfiguration)obj;
        return Objects.equals(this.audio(), other.audio()) && Objects.equals(this.video(), other.video()) && Objects.equals(this.content(), other.content()) && Objects.equals(this.attendee(), other.attendee());
    }

    public final String toString() {
        return ToString.builder((String)"MeetingFeaturesConfiguration").add("Audio", (Object)this.audio()).add("Video", (Object)this.video()).add("Content", (Object)this.content()).add("Attendee", (Object)this.attendee()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Audio": {
                return Optional.ofNullable(clazz.cast(this.audio()));
            }
            case "Video": {
                return Optional.ofNullable(clazz.cast(this.video()));
            }
            case "Content": {
                return Optional.ofNullable(clazz.cast(this.content()));
            }
            case "Attendee": {
                return Optional.ofNullable(clazz.cast(this.attendee()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Audio", AUDIO_FIELD);
        map.put("Video", VIDEO_FIELD);
        map.put("Content", CONTENT_FIELD);
        map.put("Attendee", ATTENDEE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MeetingFeaturesConfiguration, T> g) {
        return obj -> g.apply((MeetingFeaturesConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private AudioFeatures audio;
        private VideoFeatures video;
        private ContentFeatures content;
        private AttendeeFeatures attendee;

        private BuilderImpl() {
        }

        private BuilderImpl(MeetingFeaturesConfiguration model) {
            this.audio(model.audio);
            this.video(model.video);
            this.content(model.content);
            this.attendee(model.attendee);
        }

        public final AudioFeatures.Builder getAudio() {
            return this.audio != null ? this.audio.toBuilder() : null;
        }

        public final void setAudio(AudioFeatures.BuilderImpl audio) {
            this.audio = audio != null ? audio.build() : null;
        }

        @Override
        public final Builder audio(AudioFeatures audio) {
            this.audio = audio;
            return this;
        }

        public final VideoFeatures.Builder getVideo() {
            return this.video != null ? this.video.toBuilder() : null;
        }

        public final void setVideo(VideoFeatures.BuilderImpl video) {
            this.video = video != null ? video.build() : null;
        }

        @Override
        public final Builder video(VideoFeatures video) {
            this.video = video;
            return this;
        }

        public final ContentFeatures.Builder getContent() {
            return this.content != null ? this.content.toBuilder() : null;
        }

        public final void setContent(ContentFeatures.BuilderImpl content) {
            this.content = content != null ? content.build() : null;
        }

        @Override
        public final Builder content(ContentFeatures content) {
            this.content = content;
            return this;
        }

        public final AttendeeFeatures.Builder getAttendee() {
            return this.attendee != null ? this.attendee.toBuilder() : null;
        }

        public final void setAttendee(AttendeeFeatures.BuilderImpl attendee) {
            this.attendee = attendee != null ? attendee.build() : null;
        }

        @Override
        public final Builder attendee(AttendeeFeatures attendee) {
            this.attendee = attendee;
            return this;
        }

        public MeetingFeaturesConfiguration build() {
            return new MeetingFeaturesConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MeetingFeaturesConfiguration> {
        public Builder audio(AudioFeatures var1);

        default public Builder audio(Consumer<AudioFeatures.Builder> audio) {
            return this.audio((AudioFeatures)((AudioFeatures.Builder)AudioFeatures.builder().applyMutation(audio)).build());
        }

        public Builder video(VideoFeatures var1);

        default public Builder video(Consumer<VideoFeatures.Builder> video) {
            return this.video((VideoFeatures)((VideoFeatures.Builder)VideoFeatures.builder().applyMutation(video)).build());
        }

        public Builder content(ContentFeatures var1);

        default public Builder content(Consumer<ContentFeatures.Builder> content) {
            return this.content((ContentFeatures)((ContentFeatures.Builder)ContentFeatures.builder().applyMutation(content)).build());
        }

        public Builder attendee(AttendeeFeatures var1);

        default public Builder attendee(Consumer<AttendeeFeatures.Builder> attendee) {
            return this.attendee((AttendeeFeatures)((AttendeeFeatures.Builder)AttendeeFeatures.builder().applyMutation(attendee)).build());
        }
    }
}

