/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkvoice.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteSipRuleRequest extends ChimeSdkVoiceRequest implements
        ToCopyableBuilder<DeleteSipRuleRequest.Builder, DeleteSipRuleRequest> {
    private static final SdkField<String> SIP_RULE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SipRuleId").getter(getter(DeleteSipRuleRequest::sipRuleId)).setter(setter(Builder::sipRuleId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("sipRuleId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SIP_RULE_ID_FIELD));

    private final String sipRuleId;

    private DeleteSipRuleRequest(BuilderImpl builder) {
        super(builder);
        this.sipRuleId = builder.sipRuleId;
    }

    /**
     * <p>
     * The SIP rule ID.
     * </p>
     * 
     * @return The SIP rule ID.
     */
    public final String sipRuleId() {
        return sipRuleId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(sipRuleId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteSipRuleRequest)) {
            return false;
        }
        DeleteSipRuleRequest other = (DeleteSipRuleRequest) obj;
        return Objects.equals(sipRuleId(), other.sipRuleId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteSipRuleRequest").add("SipRuleId", sipRuleId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SipRuleId":
            return Optional.ofNullable(clazz.cast(sipRuleId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteSipRuleRequest, T> g) {
        return obj -> g.apply((DeleteSipRuleRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ChimeSdkVoiceRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeleteSipRuleRequest> {
        /**
         * <p>
         * The SIP rule ID.
         * </p>
         * 
         * @param sipRuleId
         *        The SIP rule ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sipRuleId(String sipRuleId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ChimeSdkVoiceRequest.BuilderImpl implements Builder {
        private String sipRuleId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteSipRuleRequest model) {
            super(model);
            sipRuleId(model.sipRuleId);
        }

        public final String getSipRuleId() {
            return sipRuleId;
        }

        public final void setSipRuleId(String sipRuleId) {
            this.sipRuleId = sipRuleId;
        }

        @Override
        public final Builder sipRuleId(String sipRuleId) {
            this.sipRuleId = sipRuleId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteSipRuleRequest build() {
            return new DeleteSipRuleRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
