/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkvoice.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartVoiceToneAnalysisTaskResponse extends ChimeSdkVoiceResponse implements
        ToCopyableBuilder<StartVoiceToneAnalysisTaskResponse.Builder, StartVoiceToneAnalysisTaskResponse> {
    private static final SdkField<VoiceToneAnalysisTask> VOICE_TONE_ANALYSIS_TASK_FIELD = SdkField
            .<VoiceToneAnalysisTask> builder(MarshallingType.SDK_POJO).memberName("VoiceToneAnalysisTask")
            .getter(getter(StartVoiceToneAnalysisTaskResponse::voiceToneAnalysisTask))
            .setter(setter(Builder::voiceToneAnalysisTask)).constructor(VoiceToneAnalysisTask::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VoiceToneAnalysisTask").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(VOICE_TONE_ANALYSIS_TASK_FIELD));

    private final VoiceToneAnalysisTask voiceToneAnalysisTask;

    private StartVoiceToneAnalysisTaskResponse(BuilderImpl builder) {
        super(builder);
        this.voiceToneAnalysisTask = builder.voiceToneAnalysisTask;
    }

    /**
     * <p>
     * The details of the voice tone analysis task.
     * </p>
     * 
     * @return The details of the voice tone analysis task.
     */
    public final VoiceToneAnalysisTask voiceToneAnalysisTask() {
        return voiceToneAnalysisTask;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(voiceToneAnalysisTask());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartVoiceToneAnalysisTaskResponse)) {
            return false;
        }
        StartVoiceToneAnalysisTaskResponse other = (StartVoiceToneAnalysisTaskResponse) obj;
        return Objects.equals(voiceToneAnalysisTask(), other.voiceToneAnalysisTask());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartVoiceToneAnalysisTaskResponse").add("VoiceToneAnalysisTask", voiceToneAnalysisTask())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VoiceToneAnalysisTask":
            return Optional.ofNullable(clazz.cast(voiceToneAnalysisTask()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartVoiceToneAnalysisTaskResponse, T> g) {
        return obj -> g.apply((StartVoiceToneAnalysisTaskResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ChimeSdkVoiceResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, StartVoiceToneAnalysisTaskResponse> {
        /**
         * <p>
         * The details of the voice tone analysis task.
         * </p>
         * 
         * @param voiceToneAnalysisTask
         *        The details of the voice tone analysis task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder voiceToneAnalysisTask(VoiceToneAnalysisTask voiceToneAnalysisTask);

        /**
         * <p>
         * The details of the voice tone analysis task.
         * </p>
         * This is a convenience method that creates an instance of the {@link VoiceToneAnalysisTask.Builder} avoiding
         * the need to create one manually via {@link VoiceToneAnalysisTask#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VoiceToneAnalysisTask.Builder#build()} is called immediately and
         * its result is passed to {@link #voiceToneAnalysisTask(VoiceToneAnalysisTask)}.
         * 
         * @param voiceToneAnalysisTask
         *        a consumer that will call methods on {@link VoiceToneAnalysisTask.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #voiceToneAnalysisTask(VoiceToneAnalysisTask)
         */
        default Builder voiceToneAnalysisTask(Consumer<VoiceToneAnalysisTask.Builder> voiceToneAnalysisTask) {
            return voiceToneAnalysisTask(VoiceToneAnalysisTask.builder().applyMutation(voiceToneAnalysisTask).build());
        }
    }

    static final class BuilderImpl extends ChimeSdkVoiceResponse.BuilderImpl implements Builder {
        private VoiceToneAnalysisTask voiceToneAnalysisTask;

        private BuilderImpl() {
        }

        private BuilderImpl(StartVoiceToneAnalysisTaskResponse model) {
            super(model);
            voiceToneAnalysisTask(model.voiceToneAnalysisTask);
        }

        public final VoiceToneAnalysisTask.Builder getVoiceToneAnalysisTask() {
            return voiceToneAnalysisTask != null ? voiceToneAnalysisTask.toBuilder() : null;
        }

        public final void setVoiceToneAnalysisTask(VoiceToneAnalysisTask.BuilderImpl voiceToneAnalysisTask) {
            this.voiceToneAnalysisTask = voiceToneAnalysisTask != null ? voiceToneAnalysisTask.build() : null;
        }

        @Override
        public final Builder voiceToneAnalysisTask(VoiceToneAnalysisTask voiceToneAnalysisTask) {
            this.voiceToneAnalysisTask = voiceToneAnalysisTask;
            return this;
        }

        @Override
        public StartVoiceToneAnalysisTaskResponse build() {
            return new StartVoiceToneAnalysisTaskResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
