/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chimesdkvoice.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.chimesdkvoice.model.ChimeSdkVoiceRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.VoiceConnectorItem;
import software.amazon.awssdk.services.chimesdkvoice.model.VoiceConnectorItemListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateVoiceConnectorGroupRequest
extends ChimeSdkVoiceRequest
implements ToCopyableBuilder<Builder, CreateVoiceConnectorGroupRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CreateVoiceConnectorGroupRequest.getter(CreateVoiceConnectorGroupRequest::name)).setter(CreateVoiceConnectorGroupRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<List<VoiceConnectorItem>> VOICE_CONNECTOR_ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("VoiceConnectorItems").getter(CreateVoiceConnectorGroupRequest.getter(CreateVoiceConnectorGroupRequest::voiceConnectorItems)).setter(CreateVoiceConnectorGroupRequest.setter(Builder::voiceConnectorItems)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VoiceConnectorItems").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(VoiceConnectorItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, VOICE_CONNECTOR_ITEMS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateVoiceConnectorGroupRequest.memberNameToFieldInitializer();
    private final String name;
    private final List<VoiceConnectorItem> voiceConnectorItems;

    private CreateVoiceConnectorGroupRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.voiceConnectorItems = builder.voiceConnectorItems;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasVoiceConnectorItems() {
        return this.voiceConnectorItems != null && !(this.voiceConnectorItems instanceof SdkAutoConstructList);
    }

    public final List<VoiceConnectorItem> voiceConnectorItems() {
        return this.voiceConnectorItems;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVoiceConnectorItems() ? this.voiceConnectorItems() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateVoiceConnectorGroupRequest)) {
            return false;
        }
        CreateVoiceConnectorGroupRequest other = (CreateVoiceConnectorGroupRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && this.hasVoiceConnectorItems() == other.hasVoiceConnectorItems() && Objects.equals(this.voiceConnectorItems(), other.voiceConnectorItems());
    }

    public final String toString() {
        return ToString.builder((String)"CreateVoiceConnectorGroupRequest").add("Name", (Object)this.name()).add("VoiceConnectorItems", this.hasVoiceConnectorItems() ? this.voiceConnectorItems() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "VoiceConnectorItems": {
                return Optional.ofNullable(clazz.cast(this.voiceConnectorItems()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Name", NAME_FIELD);
        map.put("VoiceConnectorItems", VOICE_CONNECTOR_ITEMS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateVoiceConnectorGroupRequest, T> g) {
        return obj -> g.apply((CreateVoiceConnectorGroupRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ChimeSdkVoiceRequest.BuilderImpl
    implements Builder {
        private String name;
        private List<VoiceConnectorItem> voiceConnectorItems = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateVoiceConnectorGroupRequest model) {
            super(model);
            this.name(model.name);
            this.voiceConnectorItems(model.voiceConnectorItems);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final List<VoiceConnectorItem.Builder> getVoiceConnectorItems() {
            List<VoiceConnectorItem.Builder> result = VoiceConnectorItemListCopier.copyToBuilder(this.voiceConnectorItems);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVoiceConnectorItems(Collection<VoiceConnectorItem.BuilderImpl> voiceConnectorItems) {
            this.voiceConnectorItems = VoiceConnectorItemListCopier.copyFromBuilder(voiceConnectorItems);
        }

        @Override
        public final Builder voiceConnectorItems(Collection<VoiceConnectorItem> voiceConnectorItems) {
            this.voiceConnectorItems = VoiceConnectorItemListCopier.copy(voiceConnectorItems);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder voiceConnectorItems(VoiceConnectorItem ... voiceConnectorItems) {
            this.voiceConnectorItems(Arrays.asList(voiceConnectorItems));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder voiceConnectorItems(Consumer<VoiceConnectorItem.Builder> ... voiceConnectorItems) {
            this.voiceConnectorItems(Stream.of(voiceConnectorItems).map(c -> (VoiceConnectorItem)((VoiceConnectorItem.Builder)VoiceConnectorItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateVoiceConnectorGroupRequest build() {
            return new CreateVoiceConnectorGroupRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ChimeSdkVoiceRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateVoiceConnectorGroupRequest> {
        public Builder name(String var1);

        public Builder voiceConnectorItems(Collection<VoiceConnectorItem> var1);

        public Builder voiceConnectorItems(VoiceConnectorItem ... var1);

        public Builder voiceConnectorItems(Consumer<VoiceConnectorItem.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

