/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chimesdkvoice.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum SessionBorderControllerType {
    RIBBON_SBC("RIBBON_SBC"),
    ORACLE_ACME_PACKET_SBC("ORACLE_ACME_PACKET_SBC"),
    AVAYA_SBCE("AVAYA_SBCE"),
    CISCO_UNIFIED_BORDER_ELEMENT("CISCO_UNIFIED_BORDER_ELEMENT"),
    AUDIOCODES_MEDIANT_SBC("AUDIOCODES_MEDIANT_SBC"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, SessionBorderControllerType> VALUE_MAP;
    private final String value;

    private SessionBorderControllerType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SessionBorderControllerType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SessionBorderControllerType> knownValues() {
        EnumSet<SessionBorderControllerType> knownValues = EnumSet.allOf(SessionBorderControllerType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(SessionBorderControllerType.class, SessionBorderControllerType::toString);
    }
}

