/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanrooms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cleanrooms.model.AccessBudgetDetails;
import software.amazon.awssdk.services.cleanrooms.model.AccessBudgetDetailsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AccessBudget
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AccessBudget> {
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceArn").getter(AccessBudget.getter(AccessBudget::resourceArn)).setter(AccessBudget.setter(Builder::resourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceArn").build()}).build();
    private static final SdkField<List<AccessBudgetDetails>> DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("details").getter(AccessBudget.getter(AccessBudget::details)).setter(AccessBudget.setter(Builder::details)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("details").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AccessBudgetDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> AGGREGATE_REMAINING_BUDGET_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("aggregateRemainingBudget").getter(AccessBudget.getter(AccessBudget::aggregateRemainingBudget)).setter(AccessBudget.setter(Builder::aggregateRemainingBudget)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aggregateRemainingBudget").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ARN_FIELD, DETAILS_FIELD, AGGREGATE_REMAINING_BUDGET_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AccessBudget.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String resourceArn;
    private final List<AccessBudgetDetails> details;
    private final Integer aggregateRemainingBudget;

    private AccessBudget(BuilderImpl builder) {
        this.resourceArn = builder.resourceArn;
        this.details = builder.details;
        this.aggregateRemainingBudget = builder.aggregateRemainingBudget;
    }

    public final String resourceArn() {
        return this.resourceArn;
    }

    public final boolean hasDetails() {
        return this.details != null && !(this.details instanceof SdkAutoConstructList);
    }

    public final List<AccessBudgetDetails> details() {
        return this.details;
    }

    public final Integer aggregateRemainingBudget() {
        return this.aggregateRemainingBudget;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDetails() ? this.details() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.aggregateRemainingBudget());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccessBudget)) {
            return false;
        }
        AccessBudget other = (AccessBudget)obj;
        return Objects.equals(this.resourceArn(), other.resourceArn()) && this.hasDetails() == other.hasDetails() && Objects.equals(this.details(), other.details()) && Objects.equals(this.aggregateRemainingBudget(), other.aggregateRemainingBudget());
    }

    public final String toString() {
        return ToString.builder((String)"AccessBudget").add("ResourceArn", (Object)this.resourceArn()).add("Details", this.hasDetails() ? this.details() : null).add("AggregateRemainingBudget", (Object)this.aggregateRemainingBudget()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "resourceArn": {
                return Optional.ofNullable(clazz.cast(this.resourceArn()));
            }
            case "details": {
                return Optional.ofNullable(clazz.cast(this.details()));
            }
            case "aggregateRemainingBudget": {
                return Optional.ofNullable(clazz.cast(this.aggregateRemainingBudget()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("resourceArn", RESOURCE_ARN_FIELD);
        map.put("details", DETAILS_FIELD);
        map.put("aggregateRemainingBudget", AGGREGATE_REMAINING_BUDGET_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AccessBudget, T> g) {
        return obj -> g.apply((AccessBudget)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String resourceArn;
        private List<AccessBudgetDetails> details = DefaultSdkAutoConstructList.getInstance();
        private Integer aggregateRemainingBudget;

        private BuilderImpl() {
        }

        private BuilderImpl(AccessBudget model) {
            this.resourceArn(model.resourceArn);
            this.details(model.details);
            this.aggregateRemainingBudget(model.aggregateRemainingBudget);
        }

        public final String getResourceArn() {
            return this.resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final List<AccessBudgetDetails.Builder> getDetails() {
            List<AccessBudgetDetails.Builder> result = AccessBudgetDetailsListCopier.copyToBuilder(this.details);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDetails(Collection<AccessBudgetDetails.BuilderImpl> details) {
            this.details = AccessBudgetDetailsListCopier.copyFromBuilder(details);
        }

        @Override
        public final Builder details(Collection<AccessBudgetDetails> details) {
            this.details = AccessBudgetDetailsListCopier.copy(details);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder details(AccessBudgetDetails ... details) {
            this.details(Arrays.asList(details));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder details(Consumer<AccessBudgetDetails.Builder> ... details) {
            this.details(Stream.of(details).map(c -> (AccessBudgetDetails)((AccessBudgetDetails.Builder)AccessBudgetDetails.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getAggregateRemainingBudget() {
            return this.aggregateRemainingBudget;
        }

        public final void setAggregateRemainingBudget(Integer aggregateRemainingBudget) {
            this.aggregateRemainingBudget = aggregateRemainingBudget;
        }

        @Override
        public final Builder aggregateRemainingBudget(Integer aggregateRemainingBudget) {
            this.aggregateRemainingBudget = aggregateRemainingBudget;
            return this;
        }

        public AccessBudget build() {
            return new AccessBudget(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AccessBudget> {
        public Builder resourceArn(String var1);

        public Builder details(Collection<AccessBudgetDetails> var1);

        public Builder details(AccessBudgetDetails ... var1);

        public Builder details(Consumer<AccessBudgetDetails.Builder> ... var1);

        public Builder aggregateRemainingBudget(Integer var1);
    }
}

