/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanrooms.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cleanrooms.model.Change;

final class ChangeListCopier {
    ChangeListCopier() {
    }

    static List<Change> copy(Collection<? extends Change> changeListParam) {
        Object list;
        if (changeListParam == null || changeListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            ArrayList modifiableList = new ArrayList(changeListParam.size());
            changeListParam.forEach(entry -> modifiableList.add(entry));
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<Change> copyFromBuilder(Collection<? extends Change.Builder> changeListParam) {
        Object list;
        if (changeListParam == null || changeListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            ArrayList modifiableList = new ArrayList(changeListParam.size());
            changeListParam.forEach(entry -> {
                Change member = entry == null ? null : (Change)entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<Change.Builder> copyToBuilder(Collection<? extends Change> changeListParam) {
        Object list;
        if (changeListParam == null || changeListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            ArrayList modifiableList = new ArrayList(changeListParam.size());
            changeListParam.forEach(entry -> {
                Change.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}

