/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanrooms.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.cleanrooms.model.AnalysisFormat;
import software.amazon.awssdk.services.cleanrooms.model.AnalysisParameter;
import software.amazon.awssdk.services.cleanrooms.model.AnalysisParameterListCopier;
import software.amazon.awssdk.services.cleanrooms.model.AnalysisSchema;
import software.amazon.awssdk.services.cleanrooms.model.AnalysisSource;
import software.amazon.awssdk.services.cleanrooms.model.CleanRoomsRequest;
import software.amazon.awssdk.services.cleanrooms.model.ErrorMessageConfiguration;
import software.amazon.awssdk.services.cleanrooms.model.SyntheticDataParameters;
import software.amazon.awssdk.services.cleanrooms.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateAnalysisTemplateRequest
extends CleanRoomsRequest
implements ToCopyableBuilder<Builder, CreateAnalysisTemplateRequest> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(CreateAnalysisTemplateRequest.getter(CreateAnalysisTemplateRequest::description)).setter(CreateAnalysisTemplateRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> MEMBERSHIP_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("membershipIdentifier").getter(CreateAnalysisTemplateRequest.getter(CreateAnalysisTemplateRequest::membershipIdentifier)).setter(CreateAnalysisTemplateRequest.setter(Builder::membershipIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("membershipIdentifier").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CreateAnalysisTemplateRequest.getter(CreateAnalysisTemplateRequest::name)).setter(CreateAnalysisTemplateRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("format").getter(CreateAnalysisTemplateRequest.getter(CreateAnalysisTemplateRequest::formatAsString)).setter(CreateAnalysisTemplateRequest.setter(Builder::format)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("format").build()}).build();
    private static final SdkField<AnalysisSource> SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("source").getter(CreateAnalysisTemplateRequest.getter(CreateAnalysisTemplateRequest::source)).setter(CreateAnalysisTemplateRequest.setter(Builder::source)).constructor(AnalysisSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("source").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateAnalysisTemplateRequest.getter(CreateAnalysisTemplateRequest::tags)).setter(CreateAnalysisTemplateRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<List<AnalysisParameter>> ANALYSIS_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("analysisParameters").getter(CreateAnalysisTemplateRequest.getter(CreateAnalysisTemplateRequest::analysisParameters)).setter(CreateAnalysisTemplateRequest.setter(Builder::analysisParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("analysisParameters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AnalysisParameter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<AnalysisSchema> SCHEMA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("schema").getter(CreateAnalysisTemplateRequest.getter(CreateAnalysisTemplateRequest::schema)).setter(CreateAnalysisTemplateRequest.setter(Builder::schema)).constructor(AnalysisSchema::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schema").build()}).build();
    private static final SdkField<ErrorMessageConfiguration> ERROR_MESSAGE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("errorMessageConfiguration").getter(CreateAnalysisTemplateRequest.getter(CreateAnalysisTemplateRequest::errorMessageConfiguration)).setter(CreateAnalysisTemplateRequest.setter(Builder::errorMessageConfiguration)).constructor(ErrorMessageConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorMessageConfiguration").build()}).build();
    private static final SdkField<SyntheticDataParameters> SYNTHETIC_DATA_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("syntheticDataParameters").getter(CreateAnalysisTemplateRequest.getter(CreateAnalysisTemplateRequest::syntheticDataParameters)).setter(CreateAnalysisTemplateRequest.setter(Builder::syntheticDataParameters)).constructor(SyntheticDataParameters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("syntheticDataParameters").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD, MEMBERSHIP_IDENTIFIER_FIELD, NAME_FIELD, FORMAT_FIELD, SOURCE_FIELD, TAGS_FIELD, ANALYSIS_PARAMETERS_FIELD, SCHEMA_FIELD, ERROR_MESSAGE_CONFIGURATION_FIELD, SYNTHETIC_DATA_PARAMETERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateAnalysisTemplateRequest.memberNameToFieldInitializer();
    private final String description;
    private final String membershipIdentifier;
    private final String name;
    private final String format;
    private final AnalysisSource source;
    private final Map<String, String> tags;
    private final List<AnalysisParameter> analysisParameters;
    private final AnalysisSchema schema;
    private final ErrorMessageConfiguration errorMessageConfiguration;
    private final SyntheticDataParameters syntheticDataParameters;

    private CreateAnalysisTemplateRequest(BuilderImpl builder) {
        super(builder);
        this.description = builder.description;
        this.membershipIdentifier = builder.membershipIdentifier;
        this.name = builder.name;
        this.format = builder.format;
        this.source = builder.source;
        this.tags = builder.tags;
        this.analysisParameters = builder.analysisParameters;
        this.schema = builder.schema;
        this.errorMessageConfiguration = builder.errorMessageConfiguration;
        this.syntheticDataParameters = builder.syntheticDataParameters;
    }

    public final String description() {
        return this.description;
    }

    public final String membershipIdentifier() {
        return this.membershipIdentifier;
    }

    public final String name() {
        return this.name;
    }

    public final AnalysisFormat format() {
        return AnalysisFormat.fromValue(this.format);
    }

    public final String formatAsString() {
        return this.format;
    }

    public final AnalysisSource source() {
        return this.source;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final boolean hasAnalysisParameters() {
        return this.analysisParameters != null && !(this.analysisParameters instanceof SdkAutoConstructList);
    }

    public final List<AnalysisParameter> analysisParameters() {
        return this.analysisParameters;
    }

    public final AnalysisSchema schema() {
        return this.schema;
    }

    public final ErrorMessageConfiguration errorMessageConfiguration() {
        return this.errorMessageConfiguration;
    }

    public final SyntheticDataParameters syntheticDataParameters() {
        return this.syntheticDataParameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.membershipIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.formatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.source());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAnalysisParameters() ? this.analysisParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.schema());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorMessageConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.syntheticDataParameters());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAnalysisTemplateRequest)) {
            return false;
        }
        CreateAnalysisTemplateRequest other = (CreateAnalysisTemplateRequest)((Object)obj);
        return Objects.equals(this.description(), other.description()) && Objects.equals(this.membershipIdentifier(), other.membershipIdentifier()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.formatAsString(), other.formatAsString()) && Objects.equals(this.source(), other.source()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && this.hasAnalysisParameters() == other.hasAnalysisParameters() && Objects.equals(this.analysisParameters(), other.analysisParameters()) && Objects.equals(this.schema(), other.schema()) && Objects.equals(this.errorMessageConfiguration(), other.errorMessageConfiguration()) && Objects.equals(this.syntheticDataParameters(), other.syntheticDataParameters());
    }

    public final String toString() {
        return ToString.builder((String)"CreateAnalysisTemplateRequest").add("Description", (Object)this.description()).add("MembershipIdentifier", (Object)this.membershipIdentifier()).add("Name", (Object)this.name()).add("Format", (Object)this.formatAsString()).add("Source", (Object)this.source()).add("Tags", this.hasTags() ? this.tags() : null).add("AnalysisParameters", (Object)(this.analysisParameters() == null ? null : "*** Sensitive Data Redacted ***")).add("Schema", (Object)this.schema()).add("ErrorMessageConfiguration", (Object)this.errorMessageConfiguration()).add("SyntheticDataParameters", (Object)this.syntheticDataParameters()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "membershipIdentifier": {
                return Optional.ofNullable(clazz.cast(this.membershipIdentifier()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "format": {
                return Optional.ofNullable(clazz.cast(this.formatAsString()));
            }
            case "source": {
                return Optional.ofNullable(clazz.cast(this.source()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "analysisParameters": {
                return Optional.ofNullable(clazz.cast(this.analysisParameters()));
            }
            case "schema": {
                return Optional.ofNullable(clazz.cast(this.schema()));
            }
            case "errorMessageConfiguration": {
                return Optional.ofNullable(clazz.cast(this.errorMessageConfiguration()));
            }
            case "syntheticDataParameters": {
                return Optional.ofNullable(clazz.cast(this.syntheticDataParameters()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("description", DESCRIPTION_FIELD);
        map.put("membershipIdentifier", MEMBERSHIP_IDENTIFIER_FIELD);
        map.put("name", NAME_FIELD);
        map.put("format", FORMAT_FIELD);
        map.put("source", SOURCE_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("analysisParameters", ANALYSIS_PARAMETERS_FIELD);
        map.put("schema", SCHEMA_FIELD);
        map.put("errorMessageConfiguration", ERROR_MESSAGE_CONFIGURATION_FIELD);
        map.put("syntheticDataParameters", SYNTHETIC_DATA_PARAMETERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateAnalysisTemplateRequest, T> g) {
        return obj -> g.apply((CreateAnalysisTemplateRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CleanRoomsRequest.BuilderImpl
    implements Builder {
        private String description;
        private String membershipIdentifier;
        private String name;
        private String format;
        private AnalysisSource source;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private List<AnalysisParameter> analysisParameters = DefaultSdkAutoConstructList.getInstance();
        private AnalysisSchema schema;
        private ErrorMessageConfiguration errorMessageConfiguration;
        private SyntheticDataParameters syntheticDataParameters;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAnalysisTemplateRequest model) {
            super(model);
            this.description(model.description);
            this.membershipIdentifier(model.membershipIdentifier);
            this.name(model.name);
            this.format(model.format);
            this.source(model.source);
            this.tags(model.tags);
            this.analysisParameters(model.analysisParameters);
            this.schema(model.schema);
            this.errorMessageConfiguration(model.errorMessageConfiguration);
            this.syntheticDataParameters(model.syntheticDataParameters);
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getMembershipIdentifier() {
            return this.membershipIdentifier;
        }

        public final void setMembershipIdentifier(String membershipIdentifier) {
            this.membershipIdentifier = membershipIdentifier;
        }

        @Override
        public final Builder membershipIdentifier(String membershipIdentifier) {
            this.membershipIdentifier = membershipIdentifier;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getFormat() {
            return this.format;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        public final Builder format(AnalysisFormat format) {
            this.format(format == null ? null : format.toString());
            return this;
        }

        public final AnalysisSource.Builder getSource() {
            return this.source != null ? this.source.toBuilder() : null;
        }

        public final void setSource(AnalysisSource.BuilderImpl source) {
            this.source = source != null ? source.build() : null;
        }

        @Override
        public final Builder source(AnalysisSource source) {
            this.source = source;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final List<AnalysisParameter.Builder> getAnalysisParameters() {
            List<AnalysisParameter.Builder> result = AnalysisParameterListCopier.copyToBuilder(this.analysisParameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAnalysisParameters(Collection<AnalysisParameter.BuilderImpl> analysisParameters) {
            this.analysisParameters = AnalysisParameterListCopier.copyFromBuilder(analysisParameters);
        }

        @Override
        public final Builder analysisParameters(Collection<AnalysisParameter> analysisParameters) {
            this.analysisParameters = AnalysisParameterListCopier.copy(analysisParameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder analysisParameters(AnalysisParameter ... analysisParameters) {
            this.analysisParameters(Arrays.asList(analysisParameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder analysisParameters(Consumer<AnalysisParameter.Builder> ... analysisParameters) {
            this.analysisParameters(Stream.of(analysisParameters).map(c -> (AnalysisParameter)((AnalysisParameter.Builder)AnalysisParameter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final AnalysisSchema.Builder getSchema() {
            return this.schema != null ? this.schema.toBuilder() : null;
        }

        public final void setSchema(AnalysisSchema.BuilderImpl schema) {
            this.schema = schema != null ? schema.build() : null;
        }

        @Override
        public final Builder schema(AnalysisSchema schema) {
            this.schema = schema;
            return this;
        }

        public final ErrorMessageConfiguration.Builder getErrorMessageConfiguration() {
            return this.errorMessageConfiguration != null ? this.errorMessageConfiguration.toBuilder() : null;
        }

        public final void setErrorMessageConfiguration(ErrorMessageConfiguration.BuilderImpl errorMessageConfiguration) {
            this.errorMessageConfiguration = errorMessageConfiguration != null ? errorMessageConfiguration.build() : null;
        }

        @Override
        public final Builder errorMessageConfiguration(ErrorMessageConfiguration errorMessageConfiguration) {
            this.errorMessageConfiguration = errorMessageConfiguration;
            return this;
        }

        public final SyntheticDataParameters.Builder getSyntheticDataParameters() {
            return this.syntheticDataParameters != null ? this.syntheticDataParameters.toBuilder() : null;
        }

        public final void setSyntheticDataParameters(SyntheticDataParameters.BuilderImpl syntheticDataParameters) {
            this.syntheticDataParameters = syntheticDataParameters != null ? syntheticDataParameters.build() : null;
        }

        @Override
        public final Builder syntheticDataParameters(SyntheticDataParameters syntheticDataParameters) {
            this.syntheticDataParameters = syntheticDataParameters;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateAnalysisTemplateRequest build() {
            return new CreateAnalysisTemplateRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CleanRoomsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateAnalysisTemplateRequest> {
        public Builder description(String var1);

        public Builder membershipIdentifier(String var1);

        public Builder name(String var1);

        public Builder format(String var1);

        public Builder format(AnalysisFormat var1);

        public Builder source(AnalysisSource var1);

        default public Builder source(Consumer<AnalysisSource.Builder> source) {
            return this.source((AnalysisSource)((AnalysisSource.Builder)AnalysisSource.builder().applyMutation(source)).build());
        }

        public Builder tags(Map<String, String> var1);

        public Builder analysisParameters(Collection<AnalysisParameter> var1);

        public Builder analysisParameters(AnalysisParameter ... var1);

        public Builder analysisParameters(Consumer<AnalysisParameter.Builder> ... var1);

        public Builder schema(AnalysisSchema var1);

        default public Builder schema(Consumer<AnalysisSchema.Builder> schema) {
            return this.schema((AnalysisSchema)((AnalysisSchema.Builder)AnalysisSchema.builder().applyMutation(schema)).build());
        }

        public Builder errorMessageConfiguration(ErrorMessageConfiguration var1);

        default public Builder errorMessageConfiguration(Consumer<ErrorMessageConfiguration.Builder> errorMessageConfiguration) {
            return this.errorMessageConfiguration((ErrorMessageConfiguration)((ErrorMessageConfiguration.Builder)ErrorMessageConfiguration.builder().applyMutation(errorMessageConfiguration)).build());
        }

        public Builder syntheticDataParameters(SyntheticDataParameters var1);

        default public Builder syntheticDataParameters(Consumer<SyntheticDataParameters.Builder> syntheticDataParameters) {
            return this.syntheticDataParameters((SyntheticDataParameters)((SyntheticDataParameters.Builder)SyntheticDataParameters.builder().applyMutation(syntheticDataParameters)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

