/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanrooms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.cleanrooms.model.AthenaTableReference;
import software.amazon.awssdk.services.cleanrooms.model.GlueTableReference;
import software.amazon.awssdk.services.cleanrooms.model.SnowflakeTableReference;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TableReference
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TableReference> {
    private static final SdkField<GlueTableReference> GLUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("glue").getter(TableReference.getter(TableReference::glue)).setter(TableReference.setter(Builder::glue)).constructor(GlueTableReference::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("glue").build()}).build();
    private static final SdkField<SnowflakeTableReference> SNOWFLAKE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("snowflake").getter(TableReference.getter(TableReference::snowflake)).setter(TableReference.setter(Builder::snowflake)).constructor(SnowflakeTableReference::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("snowflake").build()}).build();
    private static final SdkField<AthenaTableReference> ATHENA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("athena").getter(TableReference.getter(TableReference::athena)).setter(TableReference.setter(Builder::athena)).constructor(AthenaTableReference::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("athena").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GLUE_FIELD, SNOWFLAKE_FIELD, ATHENA_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TableReference.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final GlueTableReference glue;
    private final SnowflakeTableReference snowflake;
    private final AthenaTableReference athena;
    private final Type type;

    private TableReference(BuilderImpl builder) {
        this.glue = builder.glue;
        this.snowflake = builder.snowflake;
        this.athena = builder.athena;
        this.type = builder.type;
    }

    public final GlueTableReference glue() {
        return this.glue;
    }

    public final SnowflakeTableReference snowflake() {
        return this.snowflake;
    }

    public final AthenaTableReference athena() {
        return this.athena;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.glue());
        hashCode = 31 * hashCode + Objects.hashCode(this.snowflake());
        hashCode = 31 * hashCode + Objects.hashCode(this.athena());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TableReference)) {
            return false;
        }
        TableReference other = (TableReference)obj;
        return Objects.equals(this.glue(), other.glue()) && Objects.equals(this.snowflake(), other.snowflake()) && Objects.equals(this.athena(), other.athena());
    }

    public final String toString() {
        return ToString.builder((String)"TableReference").add("Glue", (Object)this.glue()).add("Snowflake", (Object)this.snowflake()).add("Athena", (Object)this.athena()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "glue": {
                return Optional.ofNullable(clazz.cast(this.glue()));
            }
            case "snowflake": {
                return Optional.ofNullable(clazz.cast(this.snowflake()));
            }
            case "athena": {
                return Optional.ofNullable(clazz.cast(this.athena()));
            }
        }
        return Optional.empty();
    }

    public static TableReference fromGlue(GlueTableReference glue) {
        return (TableReference)TableReference.builder().glue(glue).build();
    }

    public static TableReference fromGlue(Consumer<GlueTableReference.Builder> glue) {
        GlueTableReference.Builder builder = GlueTableReference.builder();
        glue.accept(builder);
        return TableReference.fromGlue((GlueTableReference)builder.build());
    }

    public static TableReference fromSnowflake(SnowflakeTableReference snowflake) {
        return (TableReference)TableReference.builder().snowflake(snowflake).build();
    }

    public static TableReference fromSnowflake(Consumer<SnowflakeTableReference.Builder> snowflake) {
        SnowflakeTableReference.Builder builder = SnowflakeTableReference.builder();
        snowflake.accept(builder);
        return TableReference.fromSnowflake((SnowflakeTableReference)builder.build());
    }

    public static TableReference fromAthena(AthenaTableReference athena) {
        return (TableReference)TableReference.builder().athena(athena).build();
    }

    public static TableReference fromAthena(Consumer<AthenaTableReference.Builder> athena) {
        AthenaTableReference.Builder builder = AthenaTableReference.builder();
        athena.accept(builder);
        return TableReference.fromAthena((AthenaTableReference)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("glue", GLUE_FIELD);
        map.put("snowflake", SNOWFLAKE_FIELD);
        map.put("athena", ATHENA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TableReference, T> g) {
        return obj -> g.apply((TableReference)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        GLUE,
        SNOWFLAKE,
        ATHENA,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private GlueTableReference glue;
        private SnowflakeTableReference snowflake;
        private AthenaTableReference athena;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(TableReference model) {
            this.glue(model.glue);
            this.snowflake(model.snowflake);
            this.athena(model.athena);
        }

        public final GlueTableReference.Builder getGlue() {
            return this.glue != null ? this.glue.toBuilder() : null;
        }

        public final void setGlue(GlueTableReference.BuilderImpl glue) {
            GlueTableReference oldValue = this.glue;
            this.glue = glue != null ? glue.build() : null;
            this.handleUnionValueChange(Type.GLUE, oldValue, this.glue);
        }

        @Override
        public final Builder glue(GlueTableReference glue) {
            GlueTableReference oldValue = this.glue;
            this.glue = glue;
            this.handleUnionValueChange(Type.GLUE, oldValue, this.glue);
            return this;
        }

        public final SnowflakeTableReference.Builder getSnowflake() {
            return this.snowflake != null ? this.snowflake.toBuilder() : null;
        }

        public final void setSnowflake(SnowflakeTableReference.BuilderImpl snowflake) {
            SnowflakeTableReference oldValue = this.snowflake;
            this.snowflake = snowflake != null ? snowflake.build() : null;
            this.handleUnionValueChange(Type.SNOWFLAKE, oldValue, this.snowflake);
        }

        @Override
        public final Builder snowflake(SnowflakeTableReference snowflake) {
            SnowflakeTableReference oldValue = this.snowflake;
            this.snowflake = snowflake;
            this.handleUnionValueChange(Type.SNOWFLAKE, oldValue, this.snowflake);
            return this;
        }

        public final AthenaTableReference.Builder getAthena() {
            return this.athena != null ? this.athena.toBuilder() : null;
        }

        public final void setAthena(AthenaTableReference.BuilderImpl athena) {
            AthenaTableReference oldValue = this.athena;
            this.athena = athena != null ? athena.build() : null;
            this.handleUnionValueChange(Type.ATHENA, oldValue, this.athena);
        }

        @Override
        public final Builder athena(AthenaTableReference athena) {
            AthenaTableReference oldValue = this.athena;
            this.athena = athena;
            this.handleUnionValueChange(Type.ATHENA, oldValue, this.athena);
            return this;
        }

        public TableReference build() {
            return new TableReference(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TableReference> {
        public Builder glue(GlueTableReference var1);

        default public Builder glue(Consumer<GlueTableReference.Builder> glue) {
            return this.glue((GlueTableReference)((GlueTableReference.Builder)GlueTableReference.builder().applyMutation(glue)).build());
        }

        public Builder snowflake(SnowflakeTableReference var1);

        default public Builder snowflake(Consumer<SnowflakeTableReference.Builder> snowflake) {
            return this.snowflake((SnowflakeTableReference)((SnowflakeTableReference.Builder)SnowflakeTableReference.builder().applyMutation(snowflake)).build());
        }

        public Builder athena(AthenaTableReference var1);

        default public Builder athena(Consumer<AthenaTableReference.Builder> athena) {
            return this.athena((AthenaTableReference)((AthenaTableReference.Builder)AthenaTableReference.builder().applyMutation(athena)).build());
        }
    }
}

