/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanrooms.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cleanrooms.model.CleanRoomsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateConfiguredTableAssociationRequest
extends CleanRoomsRequest
implements ToCopyableBuilder<Builder, UpdateConfiguredTableAssociationRequest> {
    private static final SdkField<String> CONFIGURED_TABLE_ASSOCIATION_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("configuredTableAssociationIdentifier").getter(UpdateConfiguredTableAssociationRequest.getter(UpdateConfiguredTableAssociationRequest::configuredTableAssociationIdentifier)).setter(UpdateConfiguredTableAssociationRequest.setter(Builder::configuredTableAssociationIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("configuredTableAssociationIdentifier").build()}).build();
    private static final SdkField<String> MEMBERSHIP_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("membershipIdentifier").getter(UpdateConfiguredTableAssociationRequest.getter(UpdateConfiguredTableAssociationRequest::membershipIdentifier)).setter(UpdateConfiguredTableAssociationRequest.setter(Builder::membershipIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("membershipIdentifier").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(UpdateConfiguredTableAssociationRequest.getter(UpdateConfiguredTableAssociationRequest::description)).setter(UpdateConfiguredTableAssociationRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(UpdateConfiguredTableAssociationRequest.getter(UpdateConfiguredTableAssociationRequest::roleArn)).setter(UpdateConfiguredTableAssociationRequest.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURED_TABLE_ASSOCIATION_IDENTIFIER_FIELD, MEMBERSHIP_IDENTIFIER_FIELD, DESCRIPTION_FIELD, ROLE_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateConfiguredTableAssociationRequest.memberNameToFieldInitializer();
    private final String configuredTableAssociationIdentifier;
    private final String membershipIdentifier;
    private final String description;
    private final String roleArn;

    private UpdateConfiguredTableAssociationRequest(BuilderImpl builder) {
        super(builder);
        this.configuredTableAssociationIdentifier = builder.configuredTableAssociationIdentifier;
        this.membershipIdentifier = builder.membershipIdentifier;
        this.description = builder.description;
        this.roleArn = builder.roleArn;
    }

    public final String configuredTableAssociationIdentifier() {
        return this.configuredTableAssociationIdentifier;
    }

    public final String membershipIdentifier() {
        return this.membershipIdentifier;
    }

    public final String description() {
        return this.description;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.configuredTableAssociationIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.membershipIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateConfiguredTableAssociationRequest)) {
            return false;
        }
        UpdateConfiguredTableAssociationRequest other = (UpdateConfiguredTableAssociationRequest)((Object)obj);
        return Objects.equals(this.configuredTableAssociationIdentifier(), other.configuredTableAssociationIdentifier()) && Objects.equals(this.membershipIdentifier(), other.membershipIdentifier()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.roleArn(), other.roleArn());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateConfiguredTableAssociationRequest").add("ConfiguredTableAssociationIdentifier", (Object)this.configuredTableAssociationIdentifier()).add("MembershipIdentifier", (Object)this.membershipIdentifier()).add("Description", (Object)this.description()).add("RoleArn", (Object)this.roleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "configuredTableAssociationIdentifier": {
                return Optional.ofNullable(clazz.cast(this.configuredTableAssociationIdentifier()));
            }
            case "membershipIdentifier": {
                return Optional.ofNullable(clazz.cast(this.membershipIdentifier()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("configuredTableAssociationIdentifier", CONFIGURED_TABLE_ASSOCIATION_IDENTIFIER_FIELD);
        map.put("membershipIdentifier", MEMBERSHIP_IDENTIFIER_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("roleArn", ROLE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateConfiguredTableAssociationRequest, T> g) {
        return obj -> g.apply((UpdateConfiguredTableAssociationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CleanRoomsRequest.BuilderImpl
    implements Builder {
        private String configuredTableAssociationIdentifier;
        private String membershipIdentifier;
        private String description;
        private String roleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateConfiguredTableAssociationRequest model) {
            super(model);
            this.configuredTableAssociationIdentifier(model.configuredTableAssociationIdentifier);
            this.membershipIdentifier(model.membershipIdentifier);
            this.description(model.description);
            this.roleArn(model.roleArn);
        }

        public final String getConfiguredTableAssociationIdentifier() {
            return this.configuredTableAssociationIdentifier;
        }

        public final void setConfiguredTableAssociationIdentifier(String configuredTableAssociationIdentifier) {
            this.configuredTableAssociationIdentifier = configuredTableAssociationIdentifier;
        }

        @Override
        public final Builder configuredTableAssociationIdentifier(String configuredTableAssociationIdentifier) {
            this.configuredTableAssociationIdentifier = configuredTableAssociationIdentifier;
            return this;
        }

        public final String getMembershipIdentifier() {
            return this.membershipIdentifier;
        }

        public final void setMembershipIdentifier(String membershipIdentifier) {
            this.membershipIdentifier = membershipIdentifier;
        }

        @Override
        public final Builder membershipIdentifier(String membershipIdentifier) {
            this.membershipIdentifier = membershipIdentifier;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateConfiguredTableAssociationRequest build() {
            return new UpdateConfiguredTableAssociationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CleanRoomsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateConfiguredTableAssociationRequest> {
        public Builder configuredTableAssociationIdentifier(String var1);

        public Builder membershipIdentifier(String var1);

        public Builder description(String var1);

        public Builder roleArn(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

