/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanrooms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.cleanrooms.model.SparkPropertiesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class WorkerComputeConfigurationProperties
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, WorkerComputeConfigurationProperties> {
    private static final SdkField<Map<String, String>> SPARK_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("spark").getter(WorkerComputeConfigurationProperties.getter(WorkerComputeConfigurationProperties::spark)).setter(WorkerComputeConfigurationProperties.setter(Builder::spark)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("spark").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SPARK_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = WorkerComputeConfigurationProperties.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Map<String, String> spark;
    private final Type type;

    private WorkerComputeConfigurationProperties(BuilderImpl builder) {
        this.spark = builder.spark;
        this.type = builder.type;
    }

    public final boolean hasSpark() {
        return this.spark != null && !(this.spark instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> spark() {
        return this.spark;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSpark() ? this.spark() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkerComputeConfigurationProperties)) {
            return false;
        }
        WorkerComputeConfigurationProperties other = (WorkerComputeConfigurationProperties)obj;
        return this.hasSpark() == other.hasSpark() && Objects.equals(this.spark(), other.spark());
    }

    public final String toString() {
        return ToString.builder((String)"WorkerComputeConfigurationProperties").add("Spark", this.hasSpark() ? this.spark() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "spark": {
                return Optional.ofNullable(clazz.cast(this.spark()));
            }
        }
        return Optional.empty();
    }

    public static WorkerComputeConfigurationProperties fromSpark(Map<String, String> spark) {
        return (WorkerComputeConfigurationProperties)WorkerComputeConfigurationProperties.builder().spark(spark).build();
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Map<String, String>>> map = new HashMap<String, SdkField<Map<String, String>>>();
        map.put("spark", SPARK_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WorkerComputeConfigurationProperties, T> g) {
        return obj -> g.apply((WorkerComputeConfigurationProperties)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        SPARK,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private Map<String, String> spark = DefaultSdkAutoConstructMap.getInstance();
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(WorkerComputeConfigurationProperties model) {
            this.spark(model.spark);
        }

        public final Map<String, String> getSpark() {
            if (this.spark instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.spark;
        }

        public final void setSpark(Map<String, String> spark) {
            Map<String, String> oldValue = this.spark;
            this.spark = SparkPropertiesCopier.copy(spark);
            this.handleUnionValueChange(Type.SPARK, oldValue, this.spark);
        }

        @Override
        public final Builder spark(Map<String, String> spark) {
            Map<String, String> oldValue = this.spark;
            this.spark = SparkPropertiesCopier.copy(spark);
            this.handleUnionValueChange(Type.SPARK, oldValue, this.spark);
            return this;
        }

        public WorkerComputeConfigurationProperties build() {
            return new WorkerComputeConfigurationProperties(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, WorkerComputeConfigurationProperties> {
        public Builder spark(Map<String, String> var1);
    }
}

