/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanroomsml.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cleanroomsml.model.CleanRoomsMlRequest;
import software.amazon.awssdk.services.cleanroomsml.model.PolicyExistenceCondition;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutConfiguredAudienceModelPolicyRequest
extends CleanRoomsMlRequest
implements ToCopyableBuilder<Builder, PutConfiguredAudienceModelPolicyRequest> {
    private static final SdkField<String> CONFIGURED_AUDIENCE_MODEL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("configuredAudienceModelArn").getter(PutConfiguredAudienceModelPolicyRequest.getter(PutConfiguredAudienceModelPolicyRequest::configuredAudienceModelArn)).setter(PutConfiguredAudienceModelPolicyRequest.setter(Builder::configuredAudienceModelArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("configuredAudienceModelArn").build()}).build();
    private static final SdkField<String> CONFIGURED_AUDIENCE_MODEL_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("configuredAudienceModelPolicy").getter(PutConfiguredAudienceModelPolicyRequest.getter(PutConfiguredAudienceModelPolicyRequest::configuredAudienceModelPolicy)).setter(PutConfiguredAudienceModelPolicyRequest.setter(Builder::configuredAudienceModelPolicy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuredAudienceModelPolicy").build()}).build();
    private static final SdkField<String> POLICY_EXISTENCE_CONDITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("policyExistenceCondition").getter(PutConfiguredAudienceModelPolicyRequest.getter(PutConfiguredAudienceModelPolicyRequest::policyExistenceConditionAsString)).setter(PutConfiguredAudienceModelPolicyRequest.setter(Builder::policyExistenceCondition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyExistenceCondition").build()}).build();
    private static final SdkField<String> PREVIOUS_POLICY_HASH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("previousPolicyHash").getter(PutConfiguredAudienceModelPolicyRequest.getter(PutConfiguredAudienceModelPolicyRequest::previousPolicyHash)).setter(PutConfiguredAudienceModelPolicyRequest.setter(Builder::previousPolicyHash)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("previousPolicyHash").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURED_AUDIENCE_MODEL_ARN_FIELD, CONFIGURED_AUDIENCE_MODEL_POLICY_FIELD, POLICY_EXISTENCE_CONDITION_FIELD, PREVIOUS_POLICY_HASH_FIELD));
    private final String configuredAudienceModelArn;
    private final String configuredAudienceModelPolicy;
    private final String policyExistenceCondition;
    private final String previousPolicyHash;

    private PutConfiguredAudienceModelPolicyRequest(BuilderImpl builder) {
        super(builder);
        this.configuredAudienceModelArn = builder.configuredAudienceModelArn;
        this.configuredAudienceModelPolicy = builder.configuredAudienceModelPolicy;
        this.policyExistenceCondition = builder.policyExistenceCondition;
        this.previousPolicyHash = builder.previousPolicyHash;
    }

    public final String configuredAudienceModelArn() {
        return this.configuredAudienceModelArn;
    }

    public final String configuredAudienceModelPolicy() {
        return this.configuredAudienceModelPolicy;
    }

    public final PolicyExistenceCondition policyExistenceCondition() {
        return PolicyExistenceCondition.fromValue(this.policyExistenceCondition);
    }

    public final String policyExistenceConditionAsString() {
        return this.policyExistenceCondition;
    }

    public final String previousPolicyHash() {
        return this.previousPolicyHash;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.configuredAudienceModelArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.configuredAudienceModelPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyExistenceConditionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.previousPolicyHash());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutConfiguredAudienceModelPolicyRequest)) {
            return false;
        }
        PutConfiguredAudienceModelPolicyRequest other = (PutConfiguredAudienceModelPolicyRequest)((Object)obj);
        return Objects.equals(this.configuredAudienceModelArn(), other.configuredAudienceModelArn()) && Objects.equals(this.configuredAudienceModelPolicy(), other.configuredAudienceModelPolicy()) && Objects.equals(this.policyExistenceConditionAsString(), other.policyExistenceConditionAsString()) && Objects.equals(this.previousPolicyHash(), other.previousPolicyHash());
    }

    public final String toString() {
        return ToString.builder((String)"PutConfiguredAudienceModelPolicyRequest").add("ConfiguredAudienceModelArn", (Object)this.configuredAudienceModelArn()).add("ConfiguredAudienceModelPolicy", (Object)this.configuredAudienceModelPolicy()).add("PolicyExistenceCondition", (Object)this.policyExistenceConditionAsString()).add("PreviousPolicyHash", (Object)this.previousPolicyHash()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "configuredAudienceModelArn": {
                return Optional.ofNullable(clazz.cast(this.configuredAudienceModelArn()));
            }
            case "configuredAudienceModelPolicy": {
                return Optional.ofNullable(clazz.cast(this.configuredAudienceModelPolicy()));
            }
            case "policyExistenceCondition": {
                return Optional.ofNullable(clazz.cast(this.policyExistenceConditionAsString()));
            }
            case "previousPolicyHash": {
                return Optional.ofNullable(clazz.cast(this.previousPolicyHash()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutConfiguredAudienceModelPolicyRequest, T> g) {
        return obj -> g.apply((PutConfiguredAudienceModelPolicyRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CleanRoomsMlRequest.BuilderImpl
    implements Builder {
        private String configuredAudienceModelArn;
        private String configuredAudienceModelPolicy;
        private String policyExistenceCondition;
        private String previousPolicyHash;

        private BuilderImpl() {
        }

        private BuilderImpl(PutConfiguredAudienceModelPolicyRequest model) {
            super(model);
            this.configuredAudienceModelArn(model.configuredAudienceModelArn);
            this.configuredAudienceModelPolicy(model.configuredAudienceModelPolicy);
            this.policyExistenceCondition(model.policyExistenceCondition);
            this.previousPolicyHash(model.previousPolicyHash);
        }

        public final String getConfiguredAudienceModelArn() {
            return this.configuredAudienceModelArn;
        }

        public final void setConfiguredAudienceModelArn(String configuredAudienceModelArn) {
            this.configuredAudienceModelArn = configuredAudienceModelArn;
        }

        @Override
        public final Builder configuredAudienceModelArn(String configuredAudienceModelArn) {
            this.configuredAudienceModelArn = configuredAudienceModelArn;
            return this;
        }

        public final String getConfiguredAudienceModelPolicy() {
            return this.configuredAudienceModelPolicy;
        }

        public final void setConfiguredAudienceModelPolicy(String configuredAudienceModelPolicy) {
            this.configuredAudienceModelPolicy = configuredAudienceModelPolicy;
        }

        @Override
        public final Builder configuredAudienceModelPolicy(String configuredAudienceModelPolicy) {
            this.configuredAudienceModelPolicy = configuredAudienceModelPolicy;
            return this;
        }

        public final String getPolicyExistenceCondition() {
            return this.policyExistenceCondition;
        }

        public final void setPolicyExistenceCondition(String policyExistenceCondition) {
            this.policyExistenceCondition = policyExistenceCondition;
        }

        @Override
        public final Builder policyExistenceCondition(String policyExistenceCondition) {
            this.policyExistenceCondition = policyExistenceCondition;
            return this;
        }

        @Override
        public final Builder policyExistenceCondition(PolicyExistenceCondition policyExistenceCondition) {
            this.policyExistenceCondition(policyExistenceCondition == null ? null : policyExistenceCondition.toString());
            return this;
        }

        public final String getPreviousPolicyHash() {
            return this.previousPolicyHash;
        }

        public final void setPreviousPolicyHash(String previousPolicyHash) {
            this.previousPolicyHash = previousPolicyHash;
        }

        @Override
        public final Builder previousPolicyHash(String previousPolicyHash) {
            this.previousPolicyHash = previousPolicyHash;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutConfiguredAudienceModelPolicyRequest build() {
            return new PutConfiguredAudienceModelPolicyRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CleanRoomsMlRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutConfiguredAudienceModelPolicyRequest> {
        public Builder configuredAudienceModelArn(String var1);

        public Builder configuredAudienceModelPolicy(String var1);

        public Builder policyExistenceCondition(String var1);

        public Builder policyExistenceCondition(PolicyExistenceCondition var1);

        public Builder previousPolicyHash(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

