/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanroomsml.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cleanroomsml.CleanRoomsMlClient;
import software.amazon.awssdk.services.cleanroomsml.internal.UserAgentUtils;
import software.amazon.awssdk.services.cleanroomsml.model.AudienceExportJobSummary;
import software.amazon.awssdk.services.cleanroomsml.model.ListAudienceExportJobsRequest;
import software.amazon.awssdk.services.cleanroomsml.model.ListAudienceExportJobsResponse;

public class ListAudienceExportJobsIterable
implements SdkIterable<ListAudienceExportJobsResponse> {
    private final CleanRoomsMlClient client;
    private final ListAudienceExportJobsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAudienceExportJobsIterable(CleanRoomsMlClient client, ListAudienceExportJobsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListAudienceExportJobsResponseFetcher();
    }

    public Iterator<ListAudienceExportJobsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<AudienceExportJobSummary> audienceExportJobs() {
        Function<ListAudienceExportJobsResponse, Iterator> getIterator = response -> {
            if (response != null && response.audienceExportJobs() != null) {
                return response.audienceExportJobs().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListAudienceExportJobsResponseFetcher
    implements SyncPageFetcher<ListAudienceExportJobsResponse> {
        private ListAudienceExportJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListAudienceExportJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAudienceExportJobsResponse nextPage(ListAudienceExportJobsResponse previousPage) {
            if (previousPage == null) {
                return ListAudienceExportJobsIterable.this.client.listAudienceExportJobs(ListAudienceExportJobsIterable.this.firstRequest);
            }
            return ListAudienceExportJobsIterable.this.client.listAudienceExportJobs((ListAudienceExportJobsRequest)((Object)ListAudienceExportJobsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

