/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanroomsml.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cleanroomsml.CleanRoomsMlClient;
import software.amazon.awssdk.services.cleanroomsml.internal.UserAgentUtils;
import software.amazon.awssdk.services.cleanroomsml.model.AudienceModelSummary;
import software.amazon.awssdk.services.cleanroomsml.model.ListAudienceModelsRequest;
import software.amazon.awssdk.services.cleanroomsml.model.ListAudienceModelsResponse;

public class ListAudienceModelsIterable
implements SdkIterable<ListAudienceModelsResponse> {
    private final CleanRoomsMlClient client;
    private final ListAudienceModelsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAudienceModelsIterable(CleanRoomsMlClient client, ListAudienceModelsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListAudienceModelsResponseFetcher();
    }

    public Iterator<ListAudienceModelsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<AudienceModelSummary> audienceModels() {
        Function<ListAudienceModelsResponse, Iterator> getIterator = response -> {
            if (response != null && response.audienceModels() != null) {
                return response.audienceModels().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListAudienceModelsResponseFetcher
    implements SyncPageFetcher<ListAudienceModelsResponse> {
        private ListAudienceModelsResponseFetcher() {
        }

        public boolean hasNextPage(ListAudienceModelsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAudienceModelsResponse nextPage(ListAudienceModelsResponse previousPage) {
            if (previousPage == null) {
                return ListAudienceModelsIterable.this.client.listAudienceModels(ListAudienceModelsIterable.this.firstRequest);
            }
            return ListAudienceModelsIterable.this.client.listAudienceModels((ListAudienceModelsRequest)((Object)ListAudienceModelsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

