/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanroomsml.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cleanroomsml.CleanRoomsMlClient;
import software.amazon.awssdk.services.cleanroomsml.internal.UserAgentUtils;
import software.amazon.awssdk.services.cleanroomsml.model.ConfiguredAudienceModelSummary;
import software.amazon.awssdk.services.cleanroomsml.model.ListConfiguredAudienceModelsRequest;
import software.amazon.awssdk.services.cleanroomsml.model.ListConfiguredAudienceModelsResponse;

public class ListConfiguredAudienceModelsIterable
implements SdkIterable<ListConfiguredAudienceModelsResponse> {
    private final CleanRoomsMlClient client;
    private final ListConfiguredAudienceModelsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListConfiguredAudienceModelsIterable(CleanRoomsMlClient client, ListConfiguredAudienceModelsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListConfiguredAudienceModelsResponseFetcher();
    }

    public Iterator<ListConfiguredAudienceModelsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ConfiguredAudienceModelSummary> configuredAudienceModels() {
        Function<ListConfiguredAudienceModelsResponse, Iterator> getIterator = response -> {
            if (response != null && response.configuredAudienceModels() != null) {
                return response.configuredAudienceModels().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListConfiguredAudienceModelsResponseFetcher
    implements SyncPageFetcher<ListConfiguredAudienceModelsResponse> {
        private ListConfiguredAudienceModelsResponseFetcher() {
        }

        public boolean hasNextPage(ListConfiguredAudienceModelsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListConfiguredAudienceModelsResponse nextPage(ListConfiguredAudienceModelsResponse previousPage) {
            if (previousPage == null) {
                return ListConfiguredAudienceModelsIterable.this.client.listConfiguredAudienceModels(ListConfiguredAudienceModelsIterable.this.firstRequest);
            }
            return ListConfiguredAudienceModelsIterable.this.client.listConfiguredAudienceModels((ListConfiguredAudienceModelsRequest)((Object)ListConfiguredAudienceModelsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

