/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListDirectoriesResponse extends CloudDirectoryResponse implements
        ToCopyableBuilder<ListDirectoriesResponse.Builder, ListDirectoriesResponse> {
    private static final SdkField<List<Directory>> DIRECTORIES_FIELD = SdkField
            .<List<Directory>> builder(MarshallingType.LIST)
            .memberName("Directories")
            .getter(getter(ListDirectoriesResponse::directories))
            .setter(setter(Builder::directories))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Directories").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Directory> builder(MarshallingType.SDK_POJO)
                                            .constructor(Directory::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListDirectoriesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIRECTORIES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<Directory> directories;

    private final String nextToken;

    private ListDirectoriesResponse(BuilderImpl builder) {
        super(builder);
        this.directories = builder.directories;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Directories property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDirectories() {
        return directories != null && !(directories instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Lists all directories that are associated with your account in pagination fashion.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDirectories} method.
     * </p>
     * 
     * @return Lists all directories that are associated with your account in pagination fashion.
     */
    public final List<Directory> directories() {
        return directories;
    }

    /**
     * <p>
     * The pagination token.
     * </p>
     * 
     * @return The pagination token.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasDirectories() ? directories() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDirectoriesResponse)) {
            return false;
        }
        ListDirectoriesResponse other = (ListDirectoriesResponse) obj;
        return hasDirectories() == other.hasDirectories() && Objects.equals(directories(), other.directories())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListDirectoriesResponse").add("Directories", hasDirectories() ? directories() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Directories":
            return Optional.ofNullable(clazz.cast(directories()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListDirectoriesResponse, T> g) {
        return obj -> g.apply((ListDirectoriesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudDirectoryResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListDirectoriesResponse> {
        /**
         * <p>
         * Lists all directories that are associated with your account in pagination fashion.
         * </p>
         * 
         * @param directories
         *        Lists all directories that are associated with your account in pagination fashion.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directories(Collection<Directory> directories);

        /**
         * <p>
         * Lists all directories that are associated with your account in pagination fashion.
         * </p>
         * 
         * @param directories
         *        Lists all directories that are associated with your account in pagination fashion.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directories(Directory... directories);

        /**
         * <p>
         * Lists all directories that are associated with your account in pagination fashion.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.clouddirectory.model.Directory.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.clouddirectory.model.Directory#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.clouddirectory.model.Directory.Builder#build()} is called immediately
         * and its result is passed to {@link #directories(List<Directory>)}.
         * 
         * @param directories
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.clouddirectory.model.Directory.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #directories(java.util.Collection<Directory>)
         */
        Builder directories(Consumer<Directory.Builder>... directories);

        /**
         * <p>
         * The pagination token.
         * </p>
         * 
         * @param nextToken
         *        The pagination token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends CloudDirectoryResponse.BuilderImpl implements Builder {
        private List<Directory> directories = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDirectoriesResponse model) {
            super(model);
            directories(model.directories);
            nextToken(model.nextToken);
        }

        public final List<Directory.Builder> getDirectories() {
            List<Directory.Builder> result = DirectoryListCopier.copyToBuilder(this.directories);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDirectories(Collection<Directory.BuilderImpl> directories) {
            this.directories = DirectoryListCopier.copyFromBuilder(directories);
        }

        @Override
        public final Builder directories(Collection<Directory> directories) {
            this.directories = DirectoryListCopier.copy(directories);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder directories(Directory... directories) {
            directories(Arrays.asList(directories));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder directories(Consumer<Directory.Builder>... directories) {
            directories(Stream.of(directories).map(c -> Directory.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListDirectoriesResponse build() {
            return new ListDirectoriesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
