/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudformation.model.CloudFormationResponse;
import software.amazon.awssdk.services.cloudformation.model.ResourceScanSummariesCopier;
import software.amazon.awssdk.services.cloudformation.model.ResourceScanSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListResourceScansResponse
extends CloudFormationResponse
implements ToCopyableBuilder<Builder, ListResourceScansResponse> {
    private static final SdkField<List<ResourceScanSummary>> RESOURCE_SCAN_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ResourceScanSummaries").getter(ListResourceScansResponse.getter(ListResourceScansResponse::resourceScanSummaries)).setter(ListResourceScansResponse.setter(Builder::resourceScanSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceScanSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResourceScanSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListResourceScansResponse.getter(ListResourceScansResponse::nextToken)).setter(ListResourceScansResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_SCAN_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private final List<ResourceScanSummary> resourceScanSummaries;
    private final String nextToken;

    private ListResourceScansResponse(BuilderImpl builder) {
        super(builder);
        this.resourceScanSummaries = builder.resourceScanSummaries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasResourceScanSummaries() {
        return this.resourceScanSummaries != null && !(this.resourceScanSummaries instanceof SdkAutoConstructList);
    }

    public final List<ResourceScanSummary> resourceScanSummaries() {
        return this.resourceScanSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourceScanSummaries() ? this.resourceScanSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListResourceScansResponse)) {
            return false;
        }
        ListResourceScansResponse other = (ListResourceScansResponse)((Object)obj);
        return this.hasResourceScanSummaries() == other.hasResourceScanSummaries() && Objects.equals(this.resourceScanSummaries(), other.resourceScanSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListResourceScansResponse").add("ResourceScanSummaries", this.hasResourceScanSummaries() ? this.resourceScanSummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceScanSummaries": {
                return Optional.ofNullable(clazz.cast(this.resourceScanSummaries()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListResourceScansResponse, T> g) {
        return obj -> g.apply((ListResourceScansResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudFormationResponse.BuilderImpl
    implements Builder {
        private List<ResourceScanSummary> resourceScanSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListResourceScansResponse model) {
            super(model);
            this.resourceScanSummaries(model.resourceScanSummaries);
            this.nextToken(model.nextToken);
        }

        public final List<ResourceScanSummary.Builder> getResourceScanSummaries() {
            List<ResourceScanSummary.Builder> result = ResourceScanSummariesCopier.copyToBuilder(this.resourceScanSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResourceScanSummaries(Collection<ResourceScanSummary.BuilderImpl> resourceScanSummaries) {
            this.resourceScanSummaries = ResourceScanSummariesCopier.copyFromBuilder(resourceScanSummaries);
        }

        @Override
        public final Builder resourceScanSummaries(Collection<ResourceScanSummary> resourceScanSummaries) {
            this.resourceScanSummaries = ResourceScanSummariesCopier.copy(resourceScanSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceScanSummaries(ResourceScanSummary ... resourceScanSummaries) {
            this.resourceScanSummaries(Arrays.asList(resourceScanSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceScanSummaries(Consumer<ResourceScanSummary.Builder> ... resourceScanSummaries) {
            this.resourceScanSummaries(Stream.of(resourceScanSummaries).map(c -> (ResourceScanSummary)((ResourceScanSummary.Builder)ResourceScanSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListResourceScansResponse build() {
            return new ListResourceScansResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudFormationResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListResourceScansResponse> {
        public Builder resourceScanSummaries(Collection<ResourceScanSummary> var1);

        public Builder resourceScanSummaries(ResourceScanSummary ... var1);

        public Builder resourceScanSummaries(Consumer<ResourceScanSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

