/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum TypeTestsStatus {
    PASSED("PASSED"),
    FAILED("FAILED"),
    IN_PROGRESS("IN_PROGRESS"),
    NOT_TESTED("NOT_TESTED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, TypeTestsStatus> VALUE_MAP;
    private final String value;

    private TypeTestsStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static TypeTestsStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<TypeTestsStatus> knownValues() {
        EnumSet<TypeTestsStatus> knownValues = EnumSet.allOf(TypeTestsStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(TypeTestsStatus.class, TypeTestsStatus::toString);
    }
}

