/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cloudformation.CloudFormationClient;
import software.amazon.awssdk.services.cloudformation.internal.UserAgentUtils;
import software.amazon.awssdk.services.cloudformation.model.ListStacksRequest;
import software.amazon.awssdk.services.cloudformation.model.ListStacksResponse;
import software.amazon.awssdk.services.cloudformation.model.StackSummary;

public class ListStacksIterable
implements SdkIterable<ListStacksResponse> {
    private final CloudFormationClient client;
    private final ListStacksRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListStacksIterable(CloudFormationClient client, ListStacksRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListStacksResponseFetcher();
    }

    public Iterator<ListStacksResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<StackSummary> stackSummaries() {
        Function<ListStacksResponse, Iterator> getIterator = response -> {
            if (response != null && response.stackSummaries() != null) {
                return response.stackSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListStacksResponseFetcher
    implements SyncPageFetcher<ListStacksResponse> {
        private ListStacksResponseFetcher() {
        }

        public boolean hasNextPage(ListStacksResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListStacksResponse nextPage(ListStacksResponse previousPage) {
            if (previousPage == null) {
                return ListStacksIterable.this.client.listStacks(ListStacksIterable.this.firstRequest);
            }
            return ListStacksIterable.this.client.listStacks((ListStacksRequest)((Object)ListStacksIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

