/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Determines whether CloudFront includes the <code>X-Content-Type-Options</code> HTTP response header with its value
 * set to <code>nosniff</code>.
 * </p>
 * <p>
 * For more information about the <code>X-Content-Type-Options</code> HTTP response header, see <a
 * href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-Content-Type-Options">X-Content-Type-Options</a> in
 * the MDN Web Docs.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResponseHeadersPolicyContentTypeOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<ResponseHeadersPolicyContentTypeOptions.Builder, ResponseHeadersPolicyContentTypeOptions> {
    private static final SdkField<Boolean> OVERRIDE_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Override")
            .getter(getter(ResponseHeadersPolicyContentTypeOptions::override))
            .setter(setter(Builder::override))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Override")
                    .unmarshallLocationName("Override").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OVERRIDE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean override;

    private ResponseHeadersPolicyContentTypeOptions(BuilderImpl builder) {
        this.override = builder.override;
    }

    /**
     * <p>
     * A Boolean that determines whether CloudFront overrides the <code>X-Content-Type-Options</code> HTTP response
     * header received from the origin with the one specified in this response headers policy.
     * </p>
     * 
     * @return A Boolean that determines whether CloudFront overrides the <code>X-Content-Type-Options</code> HTTP
     *         response header received from the origin with the one specified in this response headers policy.
     */
    public final Boolean override() {
        return override;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(override());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResponseHeadersPolicyContentTypeOptions)) {
            return false;
        }
        ResponseHeadersPolicyContentTypeOptions other = (ResponseHeadersPolicyContentTypeOptions) obj;
        return Objects.equals(override(), other.override());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResponseHeadersPolicyContentTypeOptions").add("Override", override()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Override":
            return Optional.ofNullable(clazz.cast(override()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResponseHeadersPolicyContentTypeOptions, T> g) {
        return obj -> g.apply((ResponseHeadersPolicyContentTypeOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResponseHeadersPolicyContentTypeOptions> {
        /**
         * <p>
         * A Boolean that determines whether CloudFront overrides the <code>X-Content-Type-Options</code> HTTP response
         * header received from the origin with the one specified in this response headers policy.
         * </p>
         * 
         * @param override
         *        A Boolean that determines whether CloudFront overrides the <code>X-Content-Type-Options</code> HTTP
         *        response header received from the origin with the one specified in this response headers policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder override(Boolean override);
    }

    static final class BuilderImpl implements Builder {
        private Boolean override;

        private BuilderImpl() {
        }

        private BuilderImpl(ResponseHeadersPolicyContentTypeOptions model) {
            override(model.override);
        }

        public final Boolean getOverride() {
            return override;
        }

        public final void setOverride(Boolean override) {
            this.override = override;
        }

        @Override
        public final Builder override(Boolean override) {
            this.override = override;
            return this;
        }

        @Override
        public ResponseHeadersPolicyContentTypeOptions build() {
            return new ResponseHeadersPolicyContentTypeOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
