/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum SslProtocol {
    SSL_V3("SSLv3"),
    TLS_V1("TLSv1"),
    TLS_V1_1("TLSv1.1"),
    TLS_V1_2("TLSv1.2"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, SslProtocol> VALUE_MAP;
    private final String value;

    private SslProtocol(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SslProtocol fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SslProtocol> knownValues() {
        EnumSet<SslProtocol> knownValues = EnumSet.allOf(SslProtocol.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(SslProtocol.class, SslProtocol::toString);
    }
}

