/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum IpamCidrStatus {
    PROVISIONED("provisioned"),
    FAILED_PROVISION("failed-provision"),
    PROVISIONING("provisioning"),
    DEPROVISIONED("deprovisioned"),
    FAILED_DEPROVISION("failed-deprovision"),
    DEPROVISIONING("deprovisioning"),
    ADVERTISED("advertised"),
    FAILED_ADVERTISE("failed-advertise"),
    ADVERTISING("advertising"),
    WITHDRAWN("withdrawn"),
    FAILED_WITHDRAW("failed-withdraw"),
    WITHDRAWING("withdrawing"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, IpamCidrStatus> VALUE_MAP;
    private final String value;

    private IpamCidrStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static IpamCidrStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<IpamCidrStatus> knownValues() {
        EnumSet<IpamCidrStatus> knownValues = EnumSet.allOf(IpamCidrStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(IpamCidrStatus.class, IpamCidrStatus::toString);
    }
}

