/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudfront.model.IpamCidrConfig;
import software.amazon.awssdk.services.cloudfront.model.IpamCidrConfigListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IpamConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IpamConfig> {
    private static final SdkField<Integer> QUANTITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Quantity").getter(IpamConfig.getter(IpamConfig::quantity)).setter(IpamConfig.setter(Builder::quantity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Quantity").unmarshallLocationName("Quantity").build()}).build();
    private static final SdkField<List<IpamCidrConfig>> IPAM_CIDR_CONFIGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("IpamCidrConfigs").getter(IpamConfig.getter(IpamConfig::ipamCidrConfigs)).setter(IpamConfig.setter(Builder::ipamCidrConfigs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpamCidrConfigs").unmarshallLocationName("IpamCidrConfigs").build(), ListTrait.builder().memberLocationName("IpamCidrConfig").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(IpamCidrConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpamCidrConfig").unmarshallLocationName("IpamCidrConfig").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUANTITY_FIELD, IPAM_CIDR_CONFIGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = IpamConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer quantity;
    private final List<IpamCidrConfig> ipamCidrConfigs;

    private IpamConfig(BuilderImpl builder) {
        this.quantity = builder.quantity;
        this.ipamCidrConfigs = builder.ipamCidrConfigs;
    }

    public final Integer quantity() {
        return this.quantity;
    }

    public final boolean hasIpamCidrConfigs() {
        return this.ipamCidrConfigs != null && !(this.ipamCidrConfigs instanceof SdkAutoConstructList);
    }

    public final List<IpamCidrConfig> ipamCidrConfigs() {
        return this.ipamCidrConfigs;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.quantity());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIpamCidrConfigs() ? this.ipamCidrConfigs() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IpamConfig)) {
            return false;
        }
        IpamConfig other = (IpamConfig)obj;
        return Objects.equals(this.quantity(), other.quantity()) && this.hasIpamCidrConfigs() == other.hasIpamCidrConfigs() && Objects.equals(this.ipamCidrConfigs(), other.ipamCidrConfigs());
    }

    public final String toString() {
        return ToString.builder((String)"IpamConfig").add("Quantity", (Object)this.quantity()).add("IpamCidrConfigs", this.hasIpamCidrConfigs() ? this.ipamCidrConfigs() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Quantity": {
                return Optional.ofNullable(clazz.cast(this.quantity()));
            }
            case "IpamCidrConfigs": {
                return Optional.ofNullable(clazz.cast(this.ipamCidrConfigs()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Quantity", QUANTITY_FIELD);
        map.put("IpamCidrConfigs", IPAM_CIDR_CONFIGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IpamConfig, T> g) {
        return obj -> g.apply((IpamConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer quantity;
        private List<IpamCidrConfig> ipamCidrConfigs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(IpamConfig model) {
            this.quantity(model.quantity);
            this.ipamCidrConfigs(model.ipamCidrConfigs);
        }

        public final Integer getQuantity() {
            return this.quantity;
        }

        public final void setQuantity(Integer quantity) {
            this.quantity = quantity;
        }

        @Override
        public final Builder quantity(Integer quantity) {
            this.quantity = quantity;
            return this;
        }

        public final List<IpamCidrConfig.Builder> getIpamCidrConfigs() {
            List<IpamCidrConfig.Builder> result = IpamCidrConfigListCopier.copyToBuilder(this.ipamCidrConfigs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIpamCidrConfigs(Collection<IpamCidrConfig.BuilderImpl> ipamCidrConfigs) {
            this.ipamCidrConfigs = IpamCidrConfigListCopier.copyFromBuilder(ipamCidrConfigs);
        }

        @Override
        public final Builder ipamCidrConfigs(Collection<IpamCidrConfig> ipamCidrConfigs) {
            this.ipamCidrConfigs = IpamCidrConfigListCopier.copy(ipamCidrConfigs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipamCidrConfigs(IpamCidrConfig ... ipamCidrConfigs) {
            this.ipamCidrConfigs(Arrays.asList(ipamCidrConfigs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipamCidrConfigs(Consumer<IpamCidrConfig.Builder> ... ipamCidrConfigs) {
            this.ipamCidrConfigs(Stream.of(ipamCidrConfigs).map(c -> (IpamCidrConfig)((IpamCidrConfig.Builder)IpamCidrConfig.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public IpamConfig build() {
            return new IpamConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IpamConfig> {
        public Builder quantity(Integer var1);

        public Builder ipamCidrConfigs(Collection<IpamCidrConfig> var1);

        public Builder ipamCidrConfigs(IpamCidrConfig ... var1);

        public Builder ipamCidrConfigs(Consumer<IpamCidrConfig.Builder> ... var1);
    }
}

