/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfrontkeyvaluestore;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.cloudfrontkeyvaluestore.CloudFrontKeyValueStoreAsyncClientBuilder;
import software.amazon.awssdk.services.cloudfrontkeyvaluestore.CloudFrontKeyValueStoreServiceClientConfiguration;
import software.amazon.awssdk.services.cloudfrontkeyvaluestore.DefaultCloudFrontKeyValueStoreAsyncClientBuilder;
import software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.DeleteKeyRequest;
import software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.DeleteKeyResponse;
import software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.DescribeKeyValueStoreRequest;
import software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.DescribeKeyValueStoreResponse;
import software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.GetKeyRequest;
import software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.GetKeyResponse;
import software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.ListKeysRequest;
import software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.ListKeysResponse;
import software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.PutKeyRequest;
import software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.PutKeyResponse;
import software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.UpdateKeysRequest;
import software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.UpdateKeysResponse;
import software.amazon.awssdk.services.cloudfrontkeyvaluestore.paginators.ListKeysPublisher;

@SdkPublicApi
@ThreadSafe
public interface CloudFrontKeyValueStoreAsyncClient
extends AwsClient {
    public static final String SERVICE_NAME = "cloudfront-keyvaluestore";
    public static final String SERVICE_METADATA_ID = "cloudfront-keyvaluestore";

    default public CompletableFuture<DeleteKeyResponse> deleteKey(DeleteKeyRequest deleteKeyRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<DeleteKeyResponse> deleteKey(Consumer<DeleteKeyRequest.Builder> deleteKeyRequest) {
        return this.deleteKey((DeleteKeyRequest)((Object)((DeleteKeyRequest.Builder)DeleteKeyRequest.builder().applyMutation(deleteKeyRequest)).build()));
    }

    default public CompletableFuture<DescribeKeyValueStoreResponse> describeKeyValueStore(DescribeKeyValueStoreRequest describeKeyValueStoreRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<DescribeKeyValueStoreResponse> describeKeyValueStore(Consumer<DescribeKeyValueStoreRequest.Builder> describeKeyValueStoreRequest) {
        return this.describeKeyValueStore((DescribeKeyValueStoreRequest)((Object)((DescribeKeyValueStoreRequest.Builder)DescribeKeyValueStoreRequest.builder().applyMutation(describeKeyValueStoreRequest)).build()));
    }

    default public CompletableFuture<GetKeyResponse> getKey(GetKeyRequest getKeyRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<GetKeyResponse> getKey(Consumer<GetKeyRequest.Builder> getKeyRequest) {
        return this.getKey((GetKeyRequest)((Object)((GetKeyRequest.Builder)GetKeyRequest.builder().applyMutation(getKeyRequest)).build()));
    }

    default public CompletableFuture<ListKeysResponse> listKeys(ListKeysRequest listKeysRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<ListKeysResponse> listKeys(Consumer<ListKeysRequest.Builder> listKeysRequest) {
        return this.listKeys((ListKeysRequest)((Object)((ListKeysRequest.Builder)ListKeysRequest.builder().applyMutation(listKeysRequest)).build()));
    }

    default public ListKeysPublisher listKeysPaginator(ListKeysRequest listKeysRequest) {
        return new ListKeysPublisher(this, listKeysRequest);
    }

    default public ListKeysPublisher listKeysPaginator(Consumer<ListKeysRequest.Builder> listKeysRequest) {
        return this.listKeysPaginator((ListKeysRequest)((Object)((ListKeysRequest.Builder)ListKeysRequest.builder().applyMutation(listKeysRequest)).build()));
    }

    default public CompletableFuture<PutKeyResponse> putKey(PutKeyRequest putKeyRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<PutKeyResponse> putKey(Consumer<PutKeyRequest.Builder> putKeyRequest) {
        return this.putKey((PutKeyRequest)((Object)((PutKeyRequest.Builder)PutKeyRequest.builder().applyMutation(putKeyRequest)).build()));
    }

    default public CompletableFuture<UpdateKeysResponse> updateKeys(UpdateKeysRequest updateKeysRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<UpdateKeysResponse> updateKeys(Consumer<UpdateKeysRequest.Builder> updateKeysRequest) {
        return this.updateKeys((UpdateKeysRequest)((Object)((UpdateKeysRequest.Builder)UpdateKeysRequest.builder().applyMutation(updateKeysRequest)).build()));
    }

    default public CloudFrontKeyValueStoreServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    public static CloudFrontKeyValueStoreAsyncClient create() {
        return (CloudFrontKeyValueStoreAsyncClient)CloudFrontKeyValueStoreAsyncClient.builder().build();
    }

    public static CloudFrontKeyValueStoreAsyncClientBuilder builder() {
        return new DefaultCloudFrontKeyValueStoreAsyncClientBuilder();
    }
}

