/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfrontkeyvaluestore.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.CloudFrontKeyValueStoreRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteKeyRequest
extends CloudFrontKeyValueStoreRequest
implements ToCopyableBuilder<Builder, DeleteKeyRequest> {
    private static final SdkField<String> KVS_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KvsARN").getter(DeleteKeyRequest.getter(DeleteKeyRequest::kvsARN)).setter(DeleteKeyRequest.setter(Builder::kvsARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("KvsARN").build()}).build();
    private static final SdkField<String> KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Key").getter(DeleteKeyRequest.getter(DeleteKeyRequest::key)).setter(DeleteKeyRequest.setter(Builder::key)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("Key").build()}).build();
    private static final SdkField<String> IF_MATCH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IfMatch").getter(DeleteKeyRequest.getter(DeleteKeyRequest::ifMatch)).setter(DeleteKeyRequest.setter(Builder::ifMatch)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("If-Match").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KVS_ARN_FIELD, KEY_FIELD, IF_MATCH_FIELD));
    private final String kvsARN;
    private final String key;
    private final String ifMatch;

    private DeleteKeyRequest(BuilderImpl builder) {
        super(builder);
        this.kvsARN = builder.kvsARN;
        this.key = builder.key;
        this.ifMatch = builder.ifMatch;
    }

    public final String kvsARN() {
        return this.kvsARN;
    }

    public final String key() {
        return this.key;
    }

    public final String ifMatch() {
        return this.ifMatch;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.kvsARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.key());
        hashCode = 31 * hashCode + Objects.hashCode(this.ifMatch());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteKeyRequest)) {
            return false;
        }
        DeleteKeyRequest other = (DeleteKeyRequest)((Object)obj);
        return Objects.equals(this.kvsARN(), other.kvsARN()) && Objects.equals(this.key(), other.key()) && Objects.equals(this.ifMatch(), other.ifMatch());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteKeyRequest").add("KvsARN", (Object)this.kvsARN()).add("Key", (Object)this.key()).add("IfMatch", (Object)this.ifMatch()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "KvsARN": {
                return Optional.ofNullable(clazz.cast(this.kvsARN()));
            }
            case "Key": {
                return Optional.ofNullable(clazz.cast(this.key()));
            }
            case "IfMatch": {
                return Optional.ofNullable(clazz.cast(this.ifMatch()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteKeyRequest, T> g) {
        return obj -> g.apply((DeleteKeyRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudFrontKeyValueStoreRequest.BuilderImpl
    implements Builder {
        private String kvsARN;
        private String key;
        private String ifMatch;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteKeyRequest model) {
            super(model);
            this.kvsARN(model.kvsARN);
            this.key(model.key);
            this.ifMatch(model.ifMatch);
        }

        public final String getKvsARN() {
            return this.kvsARN;
        }

        public final void setKvsARN(String kvsARN) {
            this.kvsARN = kvsARN;
        }

        @Override
        public final Builder kvsARN(String kvsARN) {
            this.kvsARN = kvsARN;
            return this;
        }

        public final String getKey() {
            return this.key;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final String getIfMatch() {
            return this.ifMatch;
        }

        public final void setIfMatch(String ifMatch) {
            this.ifMatch = ifMatch;
        }

        @Override
        public final Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteKeyRequest build() {
            return new DeleteKeyRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudFrontKeyValueStoreRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteKeyRequest> {
        public Builder kvsARN(String var1);

        public Builder key(String var1);

        public Builder ifMatch(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

