/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudhsmv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains one or more certificates or a certificate signing request (CSR).
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Certificates implements SdkPojo, Serializable, ToCopyableBuilder<Certificates.Builder, Certificates> {
    private static final SdkField<String> CLUSTER_CSR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterCsr").getter(getter(Certificates::clusterCsr)).setter(setter(Builder::clusterCsr))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterCsr").build()).build();

    private static final SdkField<String> HSM_CERTIFICATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HsmCertificate").getter(getter(Certificates::hsmCertificate)).setter(setter(Builder::hsmCertificate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HsmCertificate").build()).build();

    private static final SdkField<String> AWS_HARDWARE_CERTIFICATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AwsHardwareCertificate").getter(getter(Certificates::awsHardwareCertificate))
            .setter(setter(Builder::awsHardwareCertificate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsHardwareCertificate").build())
            .build();

    private static final SdkField<String> MANUFACTURER_HARDWARE_CERTIFICATE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ManufacturerHardwareCertificate")
            .getter(getter(Certificates::manufacturerHardwareCertificate))
            .setter(setter(Builder::manufacturerHardwareCertificate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManufacturerHardwareCertificate")
                    .build()).build();

    private static final SdkField<String> CLUSTER_CERTIFICATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterCertificate").getter(getter(Certificates::clusterCertificate))
            .setter(setter(Builder::clusterCertificate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterCertificate").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_CSR_FIELD,
            HSM_CERTIFICATE_FIELD, AWS_HARDWARE_CERTIFICATE_FIELD, MANUFACTURER_HARDWARE_CERTIFICATE_FIELD,
            CLUSTER_CERTIFICATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String clusterCsr;

    private final String hsmCertificate;

    private final String awsHardwareCertificate;

    private final String manufacturerHardwareCertificate;

    private final String clusterCertificate;

    private Certificates(BuilderImpl builder) {
        this.clusterCsr = builder.clusterCsr;
        this.hsmCertificate = builder.hsmCertificate;
        this.awsHardwareCertificate = builder.awsHardwareCertificate;
        this.manufacturerHardwareCertificate = builder.manufacturerHardwareCertificate;
        this.clusterCertificate = builder.clusterCertificate;
    }

    /**
     * <p>
     * The cluster's certificate signing request (CSR). The CSR exists only when the cluster's state is
     * <code>UNINITIALIZED</code>.
     * </p>
     * 
     * @return The cluster's certificate signing request (CSR). The CSR exists only when the cluster's state is
     *         <code>UNINITIALIZED</code>.
     */
    public final String clusterCsr() {
        return clusterCsr;
    }

    /**
     * <p>
     * The HSM certificate issued (signed) by the HSM hardware.
     * </p>
     * 
     * @return The HSM certificate issued (signed) by the HSM hardware.
     */
    public final String hsmCertificate() {
        return hsmCertificate;
    }

    /**
     * <p>
     * The HSM hardware certificate issued (signed) by AWS CloudHSM.
     * </p>
     * 
     * @return The HSM hardware certificate issued (signed) by AWS CloudHSM.
     */
    public final String awsHardwareCertificate() {
        return awsHardwareCertificate;
    }

    /**
     * <p>
     * The HSM hardware certificate issued (signed) by the hardware manufacturer.
     * </p>
     * 
     * @return The HSM hardware certificate issued (signed) by the hardware manufacturer.
     */
    public final String manufacturerHardwareCertificate() {
        return manufacturerHardwareCertificate;
    }

    /**
     * <p>
     * The cluster certificate issued (signed) by the issuing certificate authority (CA) of the cluster's owner.
     * </p>
     * 
     * @return The cluster certificate issued (signed) by the issuing certificate authority (CA) of the cluster's owner.
     */
    public final String clusterCertificate() {
        return clusterCertificate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(clusterCsr());
        hashCode = 31 * hashCode + Objects.hashCode(hsmCertificate());
        hashCode = 31 * hashCode + Objects.hashCode(awsHardwareCertificate());
        hashCode = 31 * hashCode + Objects.hashCode(manufacturerHardwareCertificate());
        hashCode = 31 * hashCode + Objects.hashCode(clusterCertificate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Certificates)) {
            return false;
        }
        Certificates other = (Certificates) obj;
        return Objects.equals(clusterCsr(), other.clusterCsr()) && Objects.equals(hsmCertificate(), other.hsmCertificate())
                && Objects.equals(awsHardwareCertificate(), other.awsHardwareCertificate())
                && Objects.equals(manufacturerHardwareCertificate(), other.manufacturerHardwareCertificate())
                && Objects.equals(clusterCertificate(), other.clusterCertificate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Certificates").add("ClusterCsr", clusterCsr()).add("HsmCertificate", hsmCertificate())
                .add("AwsHardwareCertificate", awsHardwareCertificate())
                .add("ManufacturerHardwareCertificate", manufacturerHardwareCertificate())
                .add("ClusterCertificate", clusterCertificate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClusterCsr":
            return Optional.ofNullable(clazz.cast(clusterCsr()));
        case "HsmCertificate":
            return Optional.ofNullable(clazz.cast(hsmCertificate()));
        case "AwsHardwareCertificate":
            return Optional.ofNullable(clazz.cast(awsHardwareCertificate()));
        case "ManufacturerHardwareCertificate":
            return Optional.ofNullable(clazz.cast(manufacturerHardwareCertificate()));
        case "ClusterCertificate":
            return Optional.ofNullable(clazz.cast(clusterCertificate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Certificates, T> g) {
        return obj -> g.apply((Certificates) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Certificates> {
        /**
         * <p>
         * The cluster's certificate signing request (CSR). The CSR exists only when the cluster's state is
         * <code>UNINITIALIZED</code>.
         * </p>
         * 
         * @param clusterCsr
         *        The cluster's certificate signing request (CSR). The CSR exists only when the cluster's state is
         *        <code>UNINITIALIZED</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterCsr(String clusterCsr);

        /**
         * <p>
         * The HSM certificate issued (signed) by the HSM hardware.
         * </p>
         * 
         * @param hsmCertificate
         *        The HSM certificate issued (signed) by the HSM hardware.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hsmCertificate(String hsmCertificate);

        /**
         * <p>
         * The HSM hardware certificate issued (signed) by AWS CloudHSM.
         * </p>
         * 
         * @param awsHardwareCertificate
         *        The HSM hardware certificate issued (signed) by AWS CloudHSM.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsHardwareCertificate(String awsHardwareCertificate);

        /**
         * <p>
         * The HSM hardware certificate issued (signed) by the hardware manufacturer.
         * </p>
         * 
         * @param manufacturerHardwareCertificate
         *        The HSM hardware certificate issued (signed) by the hardware manufacturer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder manufacturerHardwareCertificate(String manufacturerHardwareCertificate);

        /**
         * <p>
         * The cluster certificate issued (signed) by the issuing certificate authority (CA) of the cluster's owner.
         * </p>
         * 
         * @param clusterCertificate
         *        The cluster certificate issued (signed) by the issuing certificate authority (CA) of the cluster's
         *        owner.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterCertificate(String clusterCertificate);
    }

    static final class BuilderImpl implements Builder {
        private String clusterCsr;

        private String hsmCertificate;

        private String awsHardwareCertificate;

        private String manufacturerHardwareCertificate;

        private String clusterCertificate;

        private BuilderImpl() {
        }

        private BuilderImpl(Certificates model) {
            clusterCsr(model.clusterCsr);
            hsmCertificate(model.hsmCertificate);
            awsHardwareCertificate(model.awsHardwareCertificate);
            manufacturerHardwareCertificate(model.manufacturerHardwareCertificate);
            clusterCertificate(model.clusterCertificate);
        }

        public final String getClusterCsr() {
            return clusterCsr;
        }

        public final void setClusterCsr(String clusterCsr) {
            this.clusterCsr = clusterCsr;
        }

        @Override
        public final Builder clusterCsr(String clusterCsr) {
            this.clusterCsr = clusterCsr;
            return this;
        }

        public final String getHsmCertificate() {
            return hsmCertificate;
        }

        public final void setHsmCertificate(String hsmCertificate) {
            this.hsmCertificate = hsmCertificate;
        }

        @Override
        public final Builder hsmCertificate(String hsmCertificate) {
            this.hsmCertificate = hsmCertificate;
            return this;
        }

        public final String getAwsHardwareCertificate() {
            return awsHardwareCertificate;
        }

        public final void setAwsHardwareCertificate(String awsHardwareCertificate) {
            this.awsHardwareCertificate = awsHardwareCertificate;
        }

        @Override
        public final Builder awsHardwareCertificate(String awsHardwareCertificate) {
            this.awsHardwareCertificate = awsHardwareCertificate;
            return this;
        }

        public final String getManufacturerHardwareCertificate() {
            return manufacturerHardwareCertificate;
        }

        public final void setManufacturerHardwareCertificate(String manufacturerHardwareCertificate) {
            this.manufacturerHardwareCertificate = manufacturerHardwareCertificate;
        }

        @Override
        public final Builder manufacturerHardwareCertificate(String manufacturerHardwareCertificate) {
            this.manufacturerHardwareCertificate = manufacturerHardwareCertificate;
            return this;
        }

        public final String getClusterCertificate() {
            return clusterCertificate;
        }

        public final void setClusterCertificate(String clusterCertificate) {
            this.clusterCertificate = clusterCertificate;
        }

        @Override
        public final Builder clusterCertificate(String clusterCertificate) {
            this.clusterCertificate = clusterCertificate;
            return this;
        }

        @Override
        public Certificates build() {
            return new Certificates(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
