/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudhsmv2.auth.scheme;

import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.http.auth.spi.scheme.AuthSchemeOption;
import software.amazon.awssdk.http.auth.spi.scheme.AuthSchemeProvider;
import software.amazon.awssdk.services.cloudhsmv2.auth.scheme.CloudHsmV2AuthSchemeParams;
import software.amazon.awssdk.services.cloudhsmv2.auth.scheme.internal.DefaultCloudHsmV2AuthSchemeProvider;
import software.amazon.awssdk.services.cloudhsmv2.auth.scheme.internal.PreferredCloudHsmV2AuthSchemeProvider;

@SdkPublicApi
public interface CloudHsmV2AuthSchemeProvider
extends AuthSchemeProvider {
    public List<AuthSchemeOption> resolveAuthScheme(CloudHsmV2AuthSchemeParams var1);

    default public List<AuthSchemeOption> resolveAuthScheme(Consumer<CloudHsmV2AuthSchemeParams.Builder> consumer) {
        CloudHsmV2AuthSchemeParams.Builder builder = CloudHsmV2AuthSchemeParams.builder();
        consumer.accept(builder);
        return this.resolveAuthScheme(builder.build());
    }

    public static CloudHsmV2AuthSchemeProvider defaultProvider() {
        return DefaultCloudHsmV2AuthSchemeProvider.create();
    }

    public static CloudHsmV2AuthSchemeProvider defaultProvider(List<String> authSchemePreference) {
        return new PreferredCloudHsmV2AuthSchemeProvider(CloudHsmV2AuthSchemeProvider.defaultProvider(), authSchemePreference);
    }
}

